/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.diffview.effigy.HollowEffigyFactory;
import com.netflix.hollow.diffview.effigy.HollowRecordDiffUI;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyFieldPairer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HollowObjectDiffViewGenerator {
    private final HollowDataAccess fromDataAccess;
    private final HollowDataAccess toDataAccess;
    private final HollowRecordDiffUI diffUI;
    private final String typeName;
    private final int fromOrdinal;
    private final int toOrdinal;

    public HollowObjectDiffViewGenerator(HollowDataAccess fromDataAccess, HollowDataAccess toDataAccess, HollowRecordDiffUI diffUI, String typeName, int fromOrdinal, int toOrdinal) {
        this.fromDataAccess = fromDataAccess;
        this.toDataAccess = toDataAccess;
        this.diffUI = diffUI;
        this.typeName = typeName;
        this.fromOrdinal = fromOrdinal;
        this.toOrdinal = toOrdinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HollowDiffViewRow getHollowDiffViewRows() {
        HollowEffigy toEffigy;
        HollowEffigy fromEffigy;
        Object effigyFactory;
        if (this.diffUI != null && this.diffUI.getCustomHollowEffigyFactory(this.typeName) != null) {
            Object object = effigyFactory = this.diffUI.getCustomHollowEffigyFactory(this.typeName);
            synchronized (object) {
                effigyFactory.setFromHollowRecord(this.fromDataAccess.getTypeDataAccess(this.typeName), this.fromOrdinal);
                effigyFactory.setToHollowRecord(this.toDataAccess.getTypeDataAccess(this.typeName), this.toOrdinal);
                effigyFactory.generateEffigies();
                fromEffigy = effigyFactory.getFromEffigy();
                toEffigy = effigyFactory.getToEffigy();
            }
        } else {
            effigyFactory = new HollowEffigyFactory();
            fromEffigy = this.fromOrdinal == -1 ? null : ((HollowEffigyFactory)effigyFactory).effigy(this.fromDataAccess, this.typeName, this.fromOrdinal);
            toEffigy = this.toOrdinal == -1 ? null : ((HollowEffigyFactory)effigyFactory).effigy(this.toDataAccess, this.typeName, this.toOrdinal);
        }
        HollowDiffViewRow rootRow = this.createRootRow(fromEffigy, toEffigy);
        this.traverseEffigyToCreateViewRows(rootRow);
        return rootRow;
    }

    List<HollowDiffViewRow> traverseEffigyToCreateViewRows(HollowDiffViewRow parent) {
        if (parent.getFieldPair().isLeafNode()) {
            return Collections.emptyList();
        }
        HollowEffigy.Field fromField = parent.getFieldPair().getFrom();
        HollowEffigy.Field toField = parent.getFieldPair().getTo();
        HollowEffigy from = fromField == null ? null : (HollowEffigy)fromField.getValue();
        HollowEffigy to = toField == null ? null : (HollowEffigy)toField.getValue();
        List<HollowEffigyFieldPairer.EffigyFieldPair> pairs = HollowEffigyFieldPairer.pair(from, to, this.diffUI.getMatchHints());
        ArrayList<HollowDiffViewRow> childRows = new ArrayList<HollowDiffViewRow>();
        int i = 0;
        while (i < pairs.size()) {
            HollowEffigyFieldPairer.EffigyFieldPair pair = pairs.get(i);
            int indentation = parent.getRowPath().length + 1;
            int[] rowPath = Arrays.copyOf(parent.getRowPath(), indentation);
            rowPath[rowPath.length - 1] = i++;
            childRows.add(new HollowDiffViewRow(pair, rowPath, parent, this));
        }
        return childRows;
    }

    private HollowDiffViewRow createRootRow(HollowEffigy fromEffigy, HollowEffigy toEffigy) {
        HollowEffigy.Field fromField = fromEffigy == null ? null : new HollowEffigy.Field(null, fromEffigy);
        HollowEffigy.Field toField = toEffigy == null ? null : new HollowEffigy.Field(null, toEffigy);
        HollowEffigyFieldPairer.EffigyFieldPair fieldPair = new HollowEffigyFieldPairer.EffigyFieldPair(fromField, toField, -1, -1);
        return new HollowDiffViewRow(fieldPair, new int[0], null, this);
    }
}

