/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui;

import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.ui.HollowUIRouter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HollowDiffUIRouter
extends HollowUIRouter {
    private final Map<String, HollowDiffUI> diffUIs = new LinkedHashMap<String, HollowDiffUI>();

    public HollowDiffUIRouter() {
        this("");
    }

    public HollowDiffUIRouter(String baseUrlPath) {
        super(baseUrlPath);
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String diffUIKey = this.getTargetRootPath(req.getPathInfo());
        if ("resource".equals(diffUIKey)) {
            if (this.serveResource(req, resp, this.getResourceName(req.getPathInfo(), diffUIKey))) {
                return;
            }
        } else {
            HollowDiffUI ui = this.diffUIs.get(diffUIKey);
            if (ui == null && (ui = this.diffUIs.get("")) != null) {
                diffUIKey = "";
            }
            if (ui != null && ui.serveRequest(this.getResourceName(req.getPathInfo(), diffUIKey), req, resp)) {
                return;
            }
        }
    }

    public Map<String, HollowDiffUI> getDiffUIs() {
        return this.diffUIs;
    }

    public HollowDiffUI addDiff(String diffPath, HollowDiff diff, String fromBlobName, String toBlobName) {
        HollowDiffUI diffUI = new HollowDiffUI(this.baseUrlPath, diffPath, diff, fromBlobName, toBlobName, this.velocityEngine);
        this.diffUIs.put(diffPath, diffUI);
        return diffUI;
    }

    public void removeDiff(String diffPath) {
        this.diffUIs.remove(diffPath);
    }
}

