/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.pages;

import com.google.gson.Gson;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.VersionTimestampConverter;
import com.netflix.hollow.history.ui.model.HistoryOverviewRow;
import com.netflix.hollow.history.ui.pages.HistoryPage;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;
import com.netflix.hollow.ui.HollowUISession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;

public class HistoryOverviewPage
extends HistoryPage {
    public HistoryOverviewPage(HollowHistoryUI ui) {
        super(ui, "history-overview.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        List<HistoryOverviewRow> rows = this.getHistoryOverview();
        ctx.put("overviewDisplayHeaders", (Object)this.ui.getOverviewDisplayHeaders());
        ctx.put("overviewRows", rows);
    }

    public void sendJson(HttpServletRequest request, HttpServletResponse response) {
        List<HistoryOverviewRow> rows = this.getHistoryOverview();
        try {
            PrintWriter out = response.getWriter();
            Gson gson = new Gson();
            String json = gson.toJson(rows);
            out.println(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<HistoryOverviewRow> getHistoryOverview() {
        ArrayList<HistoryOverviewRow> rows = new ArrayList<HistoryOverviewRow>();
        for (HollowHistoricalState state : this.ui.getHistory().getHistoricalStates()) {
            ChangeBreakdown totalBreakdown = new ChangeBreakdown();
            HashMap<String, ChangeBreakdown> topLevelChangesByType = new HashMap<String, ChangeBreakdown>();
            for (Map.Entry entry : state.getKeyOrdinalMapping().getTypeMappings().entrySet()) {
                topLevelChangesByType.put((String)entry.getKey(), new ChangeBreakdown((HollowHistoricalStateTypeKeyOrdinalMapping)entry.getValue()));
                totalBreakdown.addTypeBreakown((HollowHistoricalStateTypeKeyOrdinalMapping)entry.getValue());
            }
            String[] overviewDisplayHeaderValues = this.getOverviewDisplayHeaderValues(state, this.ui.getOverviewDisplayHeaders());
            String reshardingInvocationHeader = this.getReshardingInvocationTag(state);
            rows.add(new HistoryOverviewRow(VersionTimestampConverter.getTimestamp(state.getVersion(), this.ui.getTimeZone()), state.getVersion(), totalBreakdown, topLevelChangesByType, overviewDisplayHeaderValues, reshardingInvocationHeader));
        }
        return rows;
    }

    private String[] getOverviewDisplayHeaderValues(HollowHistoricalState state, String[] overviewDisplayHeaders) {
        String[] values = new String[overviewDisplayHeaders.length];
        Map<String, String> nextStateHeaders = this.getNextStateHeaderTags(state);
        for (int i = 0; i < overviewDisplayHeaders.length; ++i) {
            values[i] = nextStateHeaders.get(overviewDisplayHeaders[i]);
        }
        return values;
    }

    private String getReshardingInvocationTag(HollowHistoricalState state) {
        Map<String, String> nextStateHeaders = this.getNextStateHeaderTags(state);
        return nextStateHeaders.get("hollow.type.resharding.invoked");
    }

    private Map<String, String> getNextStateHeaderTags(HollowHistoricalState state) {
        Map toTags = this.ui.getHistory().getLatestState().getHeaderTags();
        if (state.getNextState() != null) {
            toTags = state.getNextState().getHeaderEntries();
        }
        return toTags;
    }

    public static class ChangeBreakdown {
        private int modifiedRecords;
        private int addedRecords;
        private int removedRecords;

        public ChangeBreakdown() {
        }

        public ChangeBreakdown(HollowHistoricalStateTypeKeyOrdinalMapping keyMapping) {
            this.addTypeBreakown(keyMapping);
        }

        private void addTypeBreakown(HollowHistoricalStateTypeKeyOrdinalMapping keyMapping) {
            this.modifiedRecords += keyMapping.getNumberOfModifiedRecords();
            this.addedRecords += keyMapping.getNumberOfNewRecords();
            this.removedRecords += keyMapping.getNumberOfRemovedRecords();
        }

        public int getModifiedRecords() {
            return this.modifiedRecords;
        }

        public int getAddedRecords() {
            return this.addedRecords;
        }

        public int getRemovedRecords() {
            return this.removedRecords;
        }

        public int getTotal() {
            return this.modifiedRecords + this.addedRecords + this.removedRecords;
        }
    }
}

