/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.model;

import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.history.ui.naming.HollowHistoryRecordNamer;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;

public class RecordDiff
implements Comparable<RecordDiff> {
    private final HollowHistoryRecordNamer recordNamer;
    private final HollowHistoricalState historicalState;
    private final HollowHistoricalStateTypeKeyOrdinalMapping typeKeyOrdinalMapping;
    private final HollowObjectTypeDataAccess typeDataAccess;
    private final int keyOrdinal;
    private final int fromOrdinal;
    private final int toOrdinal;

    public RecordDiff(HollowHistoricalState historicalState, HollowHistoryRecordNamer recordNamer, HollowHistoricalStateTypeKeyOrdinalMapping typeKeyOrdinalMapping, HollowObjectTypeDataAccess typeDataAccess, int keyOrdinal, int fromOrdinal, int toOrdinal) {
        this.historicalState = historicalState;
        this.recordNamer = recordNamer;
        this.typeKeyOrdinalMapping = typeKeyOrdinalMapping;
        this.typeDataAccess = typeDataAccess;
        this.keyOrdinal = keyOrdinal;
        this.fromOrdinal = fromOrdinal;
        this.toOrdinal = toOrdinal;
    }

    public int getKeyOrdinal() {
        return this.keyOrdinal;
    }

    public String getIdentifierString() {
        return this.recordNamer.getRecordName(this.historicalState, this.typeKeyOrdinalMapping, this.keyOrdinal, this.typeDataAccess, this.toOrdinal != -1 ? this.toOrdinal : this.fromOrdinal);
    }

    public int getFromOrdinal() {
        return this.fromOrdinal;
    }

    public int getToOrdinal() {
        return this.toOrdinal;
    }

    @Override
    public int compareTo(RecordDiff o) {
        return o.getIdentifierString().compareTo(this.getIdentifierString());
    }
}

