/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.jetty;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.VersionTimestampConverter;
import com.netflix.hollow.history.ui.jetty.OptionalDependencyHelper;
import com.netflix.hollow.tools.history.HollowHistory;
import java.util.TimeZone;

public class HollowHistoryUIServer {
    private static final UIServer.Factory FACTORY = new OptionalDependencyHelper().historyUIServerFactory();
    private final UIServer server;
    private final HollowHistoryUI ui;

    public HollowHistoryUIServer(HollowConsumer consumer, int port) {
        this(new HollowHistoryUI("", consumer), port);
    }

    public HollowHistoryUIServer(HollowConsumer consumer, int port, TimeZone timeZone) {
        this(new HollowHistoryUI("", consumer, timeZone), port);
    }

    public HollowHistoryUIServer(HollowConsumer consumerFwd, HollowConsumer consumerRev, int port) {
        this(new HollowHistoryUI("", consumerFwd, consumerRev), port);
    }

    public HollowHistoryUIServer(HollowConsumer consumer, int numStatesToTrack, int port, TimeZone timeZone) {
        this(new HollowHistoryUI("", consumer, numStatesToTrack, timeZone), port);
    }

    public HollowHistoryUIServer(HollowConsumer consumer, int numStatesToTrack, int port) {
        this(new HollowHistoryUI("", consumer, numStatesToTrack, VersionTimestampConverter.PACIFIC_TIMEZONE), port);
    }

    public HollowHistoryUIServer(HollowHistory history, int port) {
        this(new HollowHistoryUI("", history), port);
    }

    public HollowHistoryUIServer(HollowHistoryUI ui, int port) {
        this.server = FACTORY.newServer(ui, port);
        this.ui = ui;
    }

    public HollowHistoryUIServer start() throws Exception {
        this.server.start();
        return this;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public HollowHistoryUIServer join() throws InterruptedException {
        this.server.join();
        return this;
    }

    public HollowHistoryUI getUI() {
        return this.ui;
    }

    static interface UIServer {
        public void start() throws Exception;

        public void stop() throws Exception;

        public void join() throws InterruptedException;

        public static interface Factory {
            public UIServer newServer(HollowHistoryUI var1, int var2);
        }
    }
}

