/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.jetty;

import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.jetty.OptionalDependencyHelper;
import com.netflix.hollow.tools.diff.HollowDiff;

public class HollowDiffUIServer {
    private static final UIServer.Factory FACTORY = new OptionalDependencyHelper().uiServerFactory();
    private final UIServer server;

    public HollowDiffUIServer() {
        this(8080);
    }

    public HollowDiffUIServer(int port) {
        this.server = FACTORY.newServer(port);
    }

    public HollowDiffUI addDiff(String diffPath, HollowDiff diff) {
        return this.addDiff(diffPath, diff, "FROM", "TO");
    }

    public HollowDiffUI addDiff(String diffPath, HollowDiff diff, String fromBlobName, String toBlobName) {
        return this.server.addDiff(diffPath, diff, fromBlobName, toBlobName);
    }

    public HollowDiffUIServer start() throws Exception {
        this.server.start();
        return this;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public HollowDiffUIServer join() throws InterruptedException {
        this.server.join();
        return this;
    }

    static interface UIServer {
        public void start() throws Exception;

        public void stop() throws Exception;

        public void join() throws InterruptedException;

        public HollowDiffUI addDiff(String var1, HollowDiff var2, String var3, String var4);

        public static interface Factory {
            public UIServer newServer(int var1);
        }
    }
}

