/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.pages;

import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.model.HollowHeaderEntry;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.ui.HollowUISession;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class DiffPage {
    protected final HollowDiffUI diffUI;
    protected final Template template;
    protected final Template headerTemplate;
    protected final Template footerTemplate;
    protected String env = "";
    protected boolean isHeaderEnabled = false;

    public DiffPage(HollowDiffUI diffUI, String templateName) {
        this.diffUI = diffUI;
        this.template = diffUI.getVelocity().getTemplate(templateName);
        this.headerTemplate = diffUI.getVelocity().getTemplate("diff-header.vm");
        this.footerTemplate = diffUI.getVelocity().getTemplate("diff-footer.vm");
    }

    public void render(HttpServletRequest req, HollowUISession session, Writer writer) {
        this.processCookies(req);
        VelocityContext ctx = new VelocityContext();
        ctx.put("request", (Object)req);
        ctx.put("env", (Object)this.env);
        ctx.put("isHeaderEnabled", (Object)this.isHeaderEnabled);
        ctx.put("basePath", (Object)this.diffUI.getBaseURLPath());
        ctx.put("path", (Object)this.diffUI.getDiffUIPath());
        ctx.put("fromBlobName", (Object)this.diffUI.getFromBlobName());
        ctx.put("toBlobName", (Object)this.diffUI.getToBlobName());
        this.setUpContext(req, session, ctx);
        ctx.put("headerEntries", this.getHeaderEntries());
        this.headerTemplate.merge((Context)ctx, writer);
        this.template.merge((Context)ctx, writer);
        this.footerTemplate.merge((Context)ctx, writer);
    }

    private void processCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if ("env".equals(name)) {
                    this.env = value;
                    continue;
                }
                if (!"isHeaderEnabled".equals(name)) continue;
                this.isHeaderEnabled = Boolean.valueOf(value);
            }
        }
    }

    protected abstract void setUpContext(HttpServletRequest var1, HollowUISession var2, VelocityContext var3);

    protected HollowDiff getDiff() {
        return this.diffUI.getDiff();
    }

    protected int intParam(HttpServletRequest req, HollowUISession session, String ctx, String paramName, int defaultValue) {
        return Integer.parseInt(this.param(req, session, ctx, paramName, String.valueOf(defaultValue)));
    }

    protected boolean boolParam(HttpServletRequest req, HollowUISession session, String ctx, String paramName, boolean defaultValue) {
        return Boolean.parseBoolean(this.param(req, session, ctx, paramName, String.valueOf(defaultValue)));
    }

    protected String param(HttpServletRequest req, HollowUISession session, String ctx, String paramName, String defaultValue) {
        String sessionParamName = ctx + "_" + paramName;
        String reqParam = req.getParameter(paramName);
        if (reqParam != null) {
            session.setAttribute(sessionParamName, (Object)reqParam);
            return reqParam;
        }
        String sessionParam = (String)session.getAttribute(sessionParamName);
        if (sessionParam != null) {
            return sessionParam;
        }
        return defaultValue;
    }

    protected HollowTypeDiff getTypeDiff(String typeName) {
        for (HollowTypeDiff typeDiff : this.getDiff().getTypeDiffs()) {
            if (!typeDiff.getTypeName().equals(typeName)) continue;
            return typeDiff;
        }
        return null;
    }

    private List<HollowHeaderEntry> getHeaderEntries() {
        Map fromTags = this.diffUI.getDiff().getFromStateEngine().getHeaderTags();
        Map toTags = this.diffUI.getDiff().getToStateEngine().getHeaderTags();
        HashSet allKeys = new HashSet();
        allKeys.addAll(fromTags.keySet());
        allKeys.addAll(toTags.keySet());
        ArrayList<HollowHeaderEntry> entries = new ArrayList<HollowHeaderEntry>();
        int i = 0;
        for (String key : allKeys) {
            entries.add(new HollowHeaderEntry(i++, key, (String)fromTags.get(key), (String)toTags.get(key)));
        }
        return entries;
    }
}

