/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diffview.HollowObjectDiffViewGenerator;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyFieldPairer;
import java.util.List;

public class HollowDiffViewRow {
    private final int[] rowPath;
    private final HollowEffigyFieldPairer.EffigyFieldPair fieldPair;
    private final HollowDiffViewRow parent;
    private final HollowObjectDiffViewGenerator viewGenerator;
    private boolean isVisible;
    private List<HollowDiffViewRow> children;
    private long moreFromRowsBits = -1L;
    private long moreToRowsBits = -1L;

    public HollowDiffViewRow(HollowEffigyFieldPairer.EffigyFieldPair fieldPair, int[] rowPath, HollowDiffViewRow parent, HollowObjectDiffViewGenerator viewGenerator) {
        this.fieldPair = fieldPair;
        this.rowPath = rowPath;
        this.parent = parent;
        this.viewGenerator = viewGenerator;
        this.isVisible = false;
    }

    public boolean areChildrenPopulated() {
        return this.children != null;
    }

    public HollowEffigyFieldPairer.EffigyFieldPair getFieldPair() {
        return this.fieldPair;
    }

    public int[] getRowPath() {
        return this.rowPath;
    }

    public HollowDiffViewRow getParent() {
        return this.parent;
    }

    public int getIndentation() {
        return this.rowPath.length;
    }

    public void setVisibility(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public Action getAvailableAction() {
        if (this.getChildren().isEmpty()) {
            return Action.NONE;
        }
        boolean foundVisibleChild = false;
        boolean foundInvisibleChild = false;
        for (HollowDiffViewRow child : this.children) {
            if (child.isVisible()) {
                if (foundInvisibleChild) {
                    return Action.PARTIAL_UNCOLLAPSE;
                }
                foundVisibleChild = true;
                continue;
            }
            if (foundVisibleChild) {
                return Action.PARTIAL_UNCOLLAPSE;
            }
            foundInvisibleChild = true;
        }
        return foundVisibleChild ? Action.COLLAPSE : Action.UNCOLLAPSE;
    }

    public List<HollowDiffViewRow> getChildren() {
        if (this.children == null) {
            this.children = this.viewGenerator.traverseEffigyToCreateViewRows(this);
        }
        return this.children;
    }

    public boolean hasMoreFromRows(int indentation) {
        if (this.moreFromRowsBits == -1L) {
            this.buildMoreRowsBits();
        }
        return (this.moreFromRowsBits & (long)(1 << indentation)) != 0L;
    }

    public boolean hasMoreToRows(int indentation) {
        if (this.moreToRowsBits == -1L) {
            this.buildMoreRowsBits();
        }
        return (this.moreToRowsBits & (long)(1 << indentation)) != 0L;
    }

    private void buildMoreRowsBits() {
        HollowDiffViewRow ancestor = this.parent;
        this.moreFromRowsBits = 0L;
        this.moreToRowsBits = 0L;
        for (int i = this.rowPath.length; i >= 1; --i) {
            if (this.moreRows(ancestor, this.rowPath[i - 1], true)) {
                this.moreFromRowsBits |= (long)(1 << i);
            }
            if (this.moreRows(ancestor, this.rowPath[i - 1], false)) {
                this.moreToRowsBits |= (long)(1 << i);
            }
            ancestor = ancestor.getParent();
        }
    }

    private boolean moreRows(HollowDiffViewRow parent, int childIdx, boolean from) {
        for (int i = childIdx + 1; i < parent.getChildren().size(); ++i) {
            HollowEffigyFieldPairer.EffigyFieldPair fieldPair = parent.getChildren().get(i).getFieldPair();
            if ((!from || fieldPair.getFrom() == null) && (from || fieldPair.getTo() == null)) continue;
            return true;
        }
        return false;
    }

    public static enum Action {
        COLLAPSE,
        UNCOLLAPSE,
        PARTIAL_UNCOLLAPSE,
        NONE;

    }
}

