/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.jetty;

import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.jetty.OptionalDependencyHelper;
import com.netflix.hollow.tools.history.HollowHistory;

public class HollowHistoryUIServer {
    private static final UIServer.Factory FACTORY = new OptionalDependencyHelper().historyUIServerFactory();
    private final UIServer server;
    private final HollowHistoryUI ui;

    public HollowHistoryUIServer(HollowHistory history, int port) {
        this(new HollowHistoryUI("", history), port);
    }

    public HollowHistoryUIServer(HollowHistoryUI ui, int port) {
        this.server = FACTORY.newServer(ui, port);
        this.ui = ui;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public HollowHistoryUI getUI() {
        return this.ui;
    }

    static interface UIServer {
        public void start() throws Exception;

        public void stop() throws Exception;

        public void join() throws InterruptedException;

        public static interface Factory {
            public UIServer newServer(HollowHistoryUI var1, int var2);
        }
    }
}

