/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class VersionTimestampConverter {
    private static final TimeZone PACIFIC_TIMEZONE = TimeZone.getTimeZone("America/Los_Angeles");
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static long ADD_MILLIS_TO_TIMESTAMP = 0L;

    public static void addMillisToTimestamps(long millis) {
        ADD_MILLIS_TO_TIMESTAMP = millis;
    }

    public static String getTimestamp(long versionLong) {
        String version = String.valueOf(versionLong);
        SimpleDateFormat utcFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        utcFormat.setTimeZone(UTC_TIMEZONE);
        try {
            Date date = utcFormat.parse(version);
            Date adjustedDate = new Date(date.getTime() + ADD_MILLIS_TO_TIMESTAMP);
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
            sdf.setTimeZone(PACIFIC_TIMEZONE);
            return sdf.format(adjustedDate);
        }
        catch (ParseException ignore) {
            return String.valueOf(versionLong);
        }
    }
}

