/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy;

import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import java.util.ArrayList;
import java.util.List;

public class HollowEffigy {
    private final String type;
    private final CollectionType collectionType;
    private final List<Field> fields;

    public HollowEffigy(String objectType) {
        this(objectType, CollectionType.NONE);
    }

    public HollowEffigy(String objectType, CollectionType collectionType) {
        this.type = objectType;
        this.collectionType = collectionType;
        this.fields = new ArrayList<Field>();
    }

    public void add(Field field) {
        this.fields.add(field);
    }

    public String getObjectType() {
        return this.type;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public static enum CollectionType {
        NONE,
        MAP,
        COLLECTION;

    }

    public static class Field {
        private final HollowDiffNodeIdentifier fieldIdentifier;
        private final Object value;
        private final int hashCode;

        public Field(HollowDiffNodeIdentifier fieldIdentifier, Object value) {
            this.fieldIdentifier = fieldIdentifier;
            this.value = value;
            this.hashCode = 31 * fieldIdentifier.hashCode() + (value == null ? 0 : value.hashCode());
        }

        public HollowDiffNodeIdentifier getFieldNodeIndex() {
            return this.fieldIdentifier;
        }

        public String getFieldName() {
            return this.fieldIdentifier.getViaFieldName();
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isLeafNode() {
            return !(this.value instanceof HollowEffigy);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Field) {
                Field otherField = (Field)other;
                if (this.fieldIdentifier.equals((Object)otherField.fieldIdentifier)) {
                    if (this.value == null) {
                        return otherField.value == null;
                    }
                    return this.value.equals(otherField.value);
                }
            }
            return false;
        }
    }
}

