/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.jetty;

import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.jetty.HollowDiffHandler;
import com.netflix.hollow.diff.ui.jetty.HollowDiffUIServer;
import com.netflix.hollow.tools.diff.HollowDiff;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

final class JettyBasedUIServer
implements HollowDiffUIServer.UIServer {
    private final Server server;
    private final HollowDiffHandler handler;

    private JettyBasedUIServer(int port) {
        this.server = new Server(port);
        this.handler = new HollowDiffHandler();
    }

    @Override
    public void start() throws Exception {
        this.server.setHandler((Handler)this.handler);
        this.server.start();
    }

    @Override
    public void stop() throws Exception {
        this.server.stop();
    }

    @Override
    public void join() throws InterruptedException {
        this.server.join();
    }

    @Override
    public HollowDiffUI addDiff(String diffPath, HollowDiff diff, String fromBlobName, String toBlobName) {
        return this.handler.getRouter().addDiff(diffPath, diff, fromBlobName, toBlobName);
    }

    static final class Factory
    implements HollowDiffUIServer.UIServer.Factory {
        Factory() {
        }

        @Override
        public HollowDiffUIServer.UIServer newServer(int port) {
            return new JettyBasedUIServer(port);
        }
    }
}

