/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diff.ui.HollowDiffSession;
import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.HollowObjectView;
import com.netflix.hollow.diffview.HollowObjectViewProvider;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DiffViewOutputGenerator {
    private final HollowObjectViewProvider viewProvider;

    public DiffViewOutputGenerator(HollowObjectViewProvider viewProvider) {
        this.viewProvider = viewProvider;
    }

    public void collapseRow(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HollowDiffSession session = HollowDiffSession.getSession(req, resp);
        HollowObjectView objectView = this.viewProvider.getObjectView(req, session);
        int row = Integer.parseInt(req.getParameter("row"));
        HollowDiffViewRow collapseRow = objectView.getRows().get(row);
        collapseRow.setUnrolled(false);
        resp.getWriter().write(String.valueOf(collapseRow.getRowId() + collapseRow.getNumDescendentRows() + 1));
        resp.getWriter().write("|");
        resp.getWriter().write(String.valueOf(DiffViewOutputGenerator.showUncollapseAllButton(collapseRow, objectView.getRows())));
    }

    public void uncollapseRow(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HollowDiffSession session = HollowDiffSession.getSession(req, resp);
        HollowObjectView objectView = this.viewProvider.getObjectView(req, session);
        boolean uncollapseAll = "true".equals(req.getParameter("all"));
        int row = Integer.parseInt(req.getParameter("row"));
        objectView.getRows().get(row).setUnrolled(true);
        objectView.getRows().get(row).setPartiallyUnrolled(false);
        String data = DiffViewOutputGenerator.getRowDisplayData(objectView, row, uncollapseAll);
        resp.getWriter().write(data);
    }

    public static String getRowDisplayData(HollowObjectView objectView, int row, boolean uncollapseAll) {
        List<HollowDiffViewRow> rows = objectView.getRows();
        StringBuilder data = new StringBuilder();
        int numDescendentRows = rows.get(row).getNumDescendentRows();
        int partialUnrollEnd = -1;
        for (int i = row + 1; i <= row + numDescendentRows; ++i) {
            HollowDiffViewRow currentRow = rows.get(i);
            if (uncollapseAll && !currentRow.getFieldPair().isLeafNode()) {
                currentRow.setUnrolled(true);
                currentRow.setPartiallyUnrolled(false);
            }
            if (currentRow.isPartiallyUnrolled() && i + currentRow.getNumDescendentRows() > partialUnrollEnd) {
                partialUnrollEnd = i + currentRow.getNumDescendentRows() + 1;
            }
            if (i < partialUnrollEnd && !currentRow.isVisibleForPartialUnroll()) continue;
            if (i > row + 1) {
                data.append("|");
            }
            data.append(i).append("|");
            data.append(DiffViewOutputGenerator.showUncollapseButton(currentRow)).append("|");
            data.append(DiffViewOutputGenerator.showUncollapseAllButton(currentRow, rows)).append("|");
            data.append(DiffViewOutputGenerator.showCollapseButton(currentRow)).append("|");
            data.append(DiffViewOutputGenerator.showPartialUnrollButton(currentRow)).append("|");
            data.append(DiffViewOutputGenerator.marginIdx(currentRow.getFieldPair().getFromIdx())).append("|");
            data.append(DiffViewOutputGenerator.fromCellClassname(currentRow)).append("|");
            data.append(DiffViewOutputGenerator.fromContent(currentRow)).append("|");
            data.append(DiffViewOutputGenerator.marginIdx(currentRow.getFieldPair().getToIdx())).append("|");
            data.append(DiffViewOutputGenerator.toCellClassname(currentRow)).append("|");
            data.append(DiffViewOutputGenerator.toContent(currentRow));
            if (currentRow.getFieldPair().isLeafNode() || currentRow.isUnrolled() || currentRow.isPartiallyUnrolled() || uncollapseAll) continue;
            i += currentRow.getNumDescendentRows();
        }
        return data.toString();
    }

    private static String marginIdx(int idx) {
        if (idx == -1) {
            return "";
        }
        return String.valueOf(idx);
    }

    private static boolean showPartialUnrollButton(HollowDiffViewRow currentRow) {
        return currentRow.isPartiallyUnrolled();
    }

    private static boolean showUncollapseButton(HollowDiffViewRow currentRow) {
        return !currentRow.isUnrolled() && !currentRow.isPartiallyUnrolled() && currentRow.getNumDescendentRows() > 0;
    }

    private static boolean showUncollapseAllButton(HollowDiffViewRow currentRow, List<HollowDiffViewRow> allRows) {
        if (DiffViewOutputGenerator.showUncollapseButton(currentRow)) {
            int startRow = currentRow.getRowId() + 1;
            int endRow = startRow + currentRow.getNumDescendentRows();
            for (int i = startRow; i < endRow; ++i) {
                currentRow = allRows.get(i);
                if (!DiffViewOutputGenerator.showUncollapseButton(currentRow) && !DiffViewOutputGenerator.showPartialUnrollButton(currentRow)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean showCollapseButton(HollowDiffViewRow currentRow) {
        return currentRow.isUnrolled() && currentRow.getNumDescendentRows() > 0;
    }

    private static String fromCellClassname(HollowDiffViewRow currentRow) {
        if (currentRow.getFieldPair().getTo() == null) {
            return "delete";
        }
        if (currentRow.getFieldPair().getFrom() == null) {
            return "empty";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() != null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() != null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "equal";
        }
        if (currentRow.getFieldPair().isLeafNode() && !currentRow.getFieldPair().getFrom().getValue().equals(currentRow.getFieldPair().getTo().getValue())) {
            return "replace";
        }
        return "equal";
    }

    private static String toCellClassname(HollowDiffViewRow currentRow) {
        if (currentRow.getFieldPair().getFrom() == null) {
            return "insert";
        }
        if (currentRow.getFieldPair().getTo() == null) {
            return "empty";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() != null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() != null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "equal";
        }
        if (currentRow.getFieldPair().isLeafNode() && !currentRow.getFieldPair().getFrom().getValue().equals(currentRow.getFieldPair().getTo().getValue())) {
            return "replace";
        }
        return "equal";
    }

    private static String fromContent(HollowDiffViewRow row) {
        boolean[] moreRows = new boolean[row.getIndentation() + 1];
        for (int i = 0; i <= row.getIndentation(); ++i) {
            moreRows[i] = row.hasMoreFromRows(i);
        }
        if (row.getFieldPair().getFrom() == null) {
            return DiffViewOutputGenerator.unpopulatedContent(moreRows);
        }
        String fieldName = row.getFieldPair().getFrom().getFieldName();
        String fieldValue = row.getFieldPair().isLeafNode() ? (row.getFieldPair().getFrom().getValue() == null ? "null" : row.getFieldPair().getFrom().getValue().toString().replace("|", "&#x2502")) : "(" + row.getFieldPair().getFrom().getFieldNodeIndex().getNodeName() + ")";
        return DiffViewOutputGenerator.populatedContent(moreRows, row.getIndentation(), row.getFieldPair().isLeafNode(), fieldName, fieldValue);
    }

    private static String toContent(HollowDiffViewRow row) {
        boolean[] moreRows = new boolean[row.getIndentation() + 1];
        for (int i = 0; i <= row.getIndentation(); ++i) {
            moreRows[i] = row.hasMoreToRows(i);
        }
        if (row.getFieldPair().getTo() == null) {
            return DiffViewOutputGenerator.unpopulatedContent(moreRows);
        }
        String fieldName = row.getFieldPair().getTo().getFieldName();
        String fieldValue = row.getFieldPair().isLeafNode() ? (row.getFieldPair().getTo().getValue() == null ? "null" : row.getFieldPair().getTo().getValue().toString().replace("|", "&#x2502")) : "(" + row.getFieldPair().getTo().getFieldNodeIndex().getNodeName() + ")";
        return DiffViewOutputGenerator.populatedContent(moreRows, row.getIndentation(), row.getFieldPair().isLeafNode(), fieldName, fieldValue);
    }

    private static String unpopulatedContent(boolean[] moreRows) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < moreRows.length; ++i) {
            if (moreRows[i]) {
                builder.append(" &#x2502;");
                continue;
            }
            builder.append("  ");
        }
        return builder.toString();
    }

    private static String populatedContent(boolean[] moreRows, int indentation, boolean leafNode, String fieldName, String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indentation; ++i) {
            if (moreRows[i]) {
                builder.append(".&#x2502;");
                continue;
            }
            builder.append("..");
        }
        if (!leafNode) {
            if (moreRows[indentation]) {
                builder.append(".&#x251D;&#x2501;&#x252F;&#x2501;&gt;");
            } else {
                builder.append(".&#x2515;&#x2501;&#x252F;&#x2501;&gt;");
            }
        } else if (moreRows[indentation]) {
            builder.append(".&#x251C;&#x2500;&#x2500;&#x2500;&gt;");
        } else {
            builder.append(".&#x2514;&#x2500;&#x2500;&#x2500;&gt;");
        }
        if (fieldName != null) {
            builder.append(fieldName).append(": ");
        }
        builder.append(value);
        return builder.toString();
    }
}

