/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diffview.DiffViewOutputGenerator;
import com.netflix.hollow.diffview.HollowObjectView;

public class HollowDiffHtmlKickstarter {
    private final String baseURL;

    public HollowDiffHtmlKickstarter(String baseURL) {
        this.baseURL = baseURL;
    }

    public String initialHtmlRows(HollowObjectView objectView) {
        String diffViewOutput = DiffViewOutputGenerator.getRowDisplayData(objectView, 0, false);
        StringBuilder initialHtml = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(diffViewOutput);
        while (tokenizer.hasMoreTokens()) {
            String rowId = tokenizer.nextToken();
            String showUncollapse = tokenizer.nextToken();
            String showUncollapseAll = tokenizer.nextToken();
            String showCollapseToRow = tokenizer.nextToken();
            String showPartialUncollapse = tokenizer.nextToken();
            String origFromIndexValue = tokenizer.nextToken();
            String fromCellClassname = tokenizer.nextToken();
            String fromCellContent = tokenizer.nextToken();
            String origToIndexValue = tokenizer.nextToken();
            String toCellClassname = tokenizer.nextToken();
            String toCellContent = tokenizer.nextToken();
            initialHtml.append("<tr id=\"r").append(rowId).append("\"");
            if ("true".equals(showPartialUncollapse) || "true".equals(showUncollapse)) {
                initialHtml.append(" onclick=\"uncollapseRow(" + rowId + ", false)\"");
            } else if ("true".equals(showCollapseToRow)) {
                initialHtml.append(" onclick=\"collapseRow(" + rowId + ")\"");
            }
            initialHtml.append(">");
            if ("true".equals(showPartialUncollapse)) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/partial_expand.png\"/>").append("</td>");
            } else if ("true".equals(showUncollapse)) {
                initialHtml.append("<td class=\"margin\">");
                if ("true".equals(showUncollapseAll)) {
                    initialHtml.append("<img src=\"" + this.baseURL + "/resource/expandall.png\" onclick=\"uncollapseRow(" + rowId + ", true)\"/>");
                } else {
                    initialHtml.append("<img src=\"" + this.baseURL + "/resource/expand.png\"/>");
                }
                initialHtml.append("</td>");
            } else if ("true".equals(showCollapseToRow)) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/collapse.png\"/>").append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            if (!"".equals(origFromIndexValue)) {
                initialHtml.append("<td class=\"margin\">").append(origFromIndexValue).append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            initialHtml.append("<td class=\"").append(fromCellClassname).append("\">").append(fromCellContent).append("</td>");
            if ("true".equals(showPartialUncollapse)) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/partial_expand.png\"/>").append("</td>");
            } else if ("true".equals(showUncollapse)) {
                initialHtml.append("<td class=\"margin\">");
                if ("true".equals(showUncollapseAll)) {
                    initialHtml.append("<img src=\"" + this.baseURL + "/resource/expandall.png\" onclick=\"uncollapseRow(" + rowId + ", true)\"/>");
                } else {
                    initialHtml.append("<img src=\"" + this.baseURL + "/resource/expand.png\"/>");
                }
                initialHtml.append("</td>");
            } else if ("true".equals(showCollapseToRow)) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/collapse.png\"/>").append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            if (!"".equals(origToIndexValue)) {
                initialHtml.append("<td class=\"margin\">").append(origToIndexValue).append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            initialHtml.append("<td class=\"").append(toCellClassname).append("\">").append(toCellContent).append("</td>");
        }
        return initialHtml.toString();
    }

    private static class StringTokenizer {
        private final String str;
        private int cursor;

        public StringTokenizer(String str) {
            this.str = str;
        }

        public String nextToken() {
            String token;
            int endIdx = this.str.indexOf(124, this.cursor);
            if (endIdx != -1) {
                token = this.str.substring(this.cursor, endIdx);
                this.cursor = endIdx + 1;
            } else {
                token = this.str.substring(this.cursor);
                this.cursor = -1;
            }
            return token;
        }

        public boolean hasMoreTokens() {
            return this.str.length() > 0 && this.cursor >= 0;
        }
    }
}

