/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.effigy.CustomHollowEffigyFactoryProvider;
import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.diffview.effigy.HollowEffigyFactory;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyFieldPairer;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import java.util.ArrayList;
import java.util.List;

public class HollowObjectDiffViewGenerator {
    private final long MAX_TIME_BEFORE_PAIRING_TIMEOUT = 15000L;
    private final HollowDataAccess fromDataAccess;
    private final HollowDataAccess toDataAccess;
    private final CustomHollowEffigyFactoryProvider customEffigyFactoryProvider;
    private final String typeName;
    private final int fromOrdinal;
    private final int toOrdinal;
    private final long deadlineBeforePairingTimeout;

    public HollowObjectDiffViewGenerator(HollowDataAccess fromDataAccess, HollowDataAccess toDataAccess, CustomHollowEffigyFactoryProvider customEffigyFactoryProvider, String typeName, int fromOrdinal, int toOrdinal) {
        this.fromDataAccess = fromDataAccess;
        this.toDataAccess = toDataAccess;
        this.customEffigyFactoryProvider = customEffigyFactoryProvider;
        this.typeName = typeName;
        this.fromOrdinal = fromOrdinal;
        this.toOrdinal = toOrdinal;
        this.deadlineBeforePairingTimeout = System.currentTimeMillis() + 15000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HollowDiffViewRow> getHollowDiffViewRows() {
        HollowEffigy toEffigy;
        HollowEffigy fromEffigy;
        Object effigyFactory;
        if (this.customEffigyFactoryProvider != null && this.customEffigyFactoryProvider.getCustomHollowEffigyFactory(this.typeName) != null) {
            Object object = effigyFactory = this.customEffigyFactoryProvider.getCustomHollowEffigyFactory(this.typeName);
            synchronized (object) {
                effigyFactory.setFromHollowRecord(this.fromDataAccess.getTypeDataAccess(this.typeName), this.fromOrdinal);
                effigyFactory.setToHollowRecord(this.toDataAccess.getTypeDataAccess(this.typeName), this.toOrdinal);
                effigyFactory.generateEffigies();
                fromEffigy = effigyFactory.getFromEffigy();
                toEffigy = effigyFactory.getToEffigy();
            }
        } else {
            effigyFactory = new HollowEffigyFactory();
            fromEffigy = this.fromOrdinal == -1 ? null : ((HollowEffigyFactory)effigyFactory).effigy(this.fromDataAccess, this.typeName, this.fromOrdinal);
            toEffigy = this.toOrdinal == -1 ? null : ((HollowEffigyFactory)effigyFactory).effigy(this.toDataAccess, this.typeName, this.toOrdinal);
        }
        ArrayList<HollowDiffViewRow> rows = new ArrayList<HollowDiffViewRow>();
        this.traverseEffigyToCreateViewRows(rows, fromEffigy, toEffigy, 0, 1, new boolean[64], new boolean[64]);
        this.insertRootRow(rows, fromEffigy, toEffigy);
        return rows;
    }

    private void traverseEffigyToCreateViewRows(List<HollowDiffViewRow> viewRows, HollowEffigy from, HollowEffigy to, int rowId, int indentation, boolean[] moreFromRows, boolean[] moreToRows) {
        List<HollowEffigyFieldPairer.EffigyFieldPair> pairs = HollowEffigyFieldPairer.pair(from, to, this.deadlineBeforePairingTimeout);
        ArrayList<HollowDiffViewRow> directChildren = new ArrayList<HollowDiffViewRow>();
        for (int i = 0; i < pairs.size(); ++i) {
            HollowDiffViewRow newRow;
            HollowEffigyFieldPairer.EffigyFieldPair pair = pairs.get(i);
            moreFromRows[indentation] = this.moreRows(pairs, true, i);
            moreToRows[indentation] = this.moreRows(pairs, false, i);
            if (pair.isLeafNode()) {
                newRow = new HollowDiffViewRow(pair, ++rowId, indentation, 0, moreFromRows, moreToRows);
                viewRows.add(newRow);
            } else {
                ArrayList<HollowDiffViewRow> descendents = new ArrayList<HollowDiffViewRow>();
                this.traverseEffigyToCreateViewRows(descendents, pair, ++rowId, indentation + 1, moreFromRows, moreToRows);
                newRow = new HollowDiffViewRow(pair, rowId, indentation, descendents.size(), moreFromRows, moreToRows);
                rowId += descendents.size();
                viewRows.add(newRow);
                viewRows.addAll(descendents);
            }
            directChildren.add(newRow);
        }
    }

    private boolean moreRows(List<HollowEffigyFieldPairer.EffigyFieldPair> pairs, boolean from, int startIdx) {
        for (int i = startIdx + 1; i < pairs.size(); ++i) {
            if (!(from ? pairs.get(i).getFrom() != null : pairs.get(i).getTo() != null)) continue;
            return true;
        }
        return false;
    }

    private void traverseEffigyToCreateViewRows(List<HollowDiffViewRow> rows, HollowEffigyFieldPairer.EffigyFieldPair fieldPair, int rowId, int indentation, boolean[] moreFromRows, boolean[] moreToRows) {
        HollowEffigy from = fieldPair.getFrom() != null ? (HollowEffigy)fieldPair.getFrom().getValue() : null;
        HollowEffigy to = fieldPair.getTo() != null ? (HollowEffigy)fieldPair.getTo().getValue() : null;
        this.traverseEffigyToCreateViewRows(rows, from, to, rowId, indentation, moreFromRows, moreToRows);
    }

    private void insertRootRow(List<HollowDiffViewRow> rows, HollowEffigy fromEffigy, HollowEffigy toEffigy) {
        HollowDiffNodeIdentifier nodeId = new HollowDiffNodeIdentifier(fromEffigy == null ? toEffigy.getObjectType() : fromEffigy.getObjectType());
        HollowEffigy.Field fromField = fromEffigy == null ? null : new HollowEffigy.Field(nodeId, fromEffigy);
        HollowEffigy.Field toField = toEffigy == null ? null : new HollowEffigy.Field(nodeId, toEffigy);
        HollowEffigyFieldPairer.EffigyFieldPair fieldPair = new HollowEffigyFieldPairer.EffigyFieldPair(fromField, toField, -1, -1);
        boolean[] moreRows = new boolean[]{false};
        rows.add(0, new HollowDiffViewRow(fieldPair, 0, 0, rows.size(), moreRows, moreRows));
    }
}

