/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.DgsDataLoaderCustomizer;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import com.netflix.graphql.dgs.DgsDispatchPredicate;
import com.netflix.graphql.dgs.exceptions.DgsUnnamedDataLoaderOnFieldException;
import com.netflix.graphql.dgs.exceptions.InvalidDataLoaderTypeException;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.UnsupportedSecuredDataLoaderException;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.registries.DispatchPredicate;
import org.dataloader.registries.ScheduledDataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 D2\u00020\u0001:\u0002DEBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J=\u0010\u001f\u001a\u00020\u001d\"\b\b\u0000\u0010 *\u00020\u00012\u0006\u0010!\u001a\u0002H 2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020*J\u001a\u0010+\u001a\u00020*\"\u0004\b\u0000\u0010 2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H 0-JF\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/2\u000e\u00100\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020*2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0002JZ\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/\"\u0004\b\u0000\u0010 2\u000e\u00100\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00172\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\f\u00106\u001a\b\u0012\u0004\u0012\u0002H 0-2\u0006\u00104\u001a\u00020*2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0002JF\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/2\u000e\u00100\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020*2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0002JZ\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/\"\u0004\b\u0000\u0010 2\u000e\u00100\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b2\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\f\u00106\u001a\b\u0012\u0004\u0012\u0002H 0-2\u0006\u00104\u001a\u00020*2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0002J\r\u00107\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b8J6\u00109\u001a\u00020\u001d2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010;\u001a\u00020<2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0002J$\u0010=\u001a\u00020\u00012\u0006\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u0002032\n\u0010@\u001a\u0006\u0012\u0002\b\u00030#H\u0002J4\u0010A\u001a\u0002H \"\u0006\b\u0000\u0010 \u0018\u00012\u0006\u0010B\u001a\u0002H 2\u0006\u0010?\u001a\u0002032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000605H\u0082\b\u00a2\u0006\u0002\u0010CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00170\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "extensionProviders", "", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "customizers", "Lcom/netflix/graphql/dgs/DgsDataLoaderCustomizer;", "dataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduleDuration", "Ljava/time/Duration;", "enableTickerMode", "", "(Lorg/springframework/context/ApplicationContext;Ljava/util/List;Ljava/util/List;Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;Ljava/util/concurrent/ScheduledExecutorService;Ljava/time/Duration;Z)V", "batchLoaders", "", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "Lorg/dataloader/BatchLoader;", "batchLoadersWithContext", "Lorg/dataloader/BatchLoaderWithContext;", "mappedBatchLoaders", "Lorg/dataloader/MappedBatchLoader;", "mappedBatchLoadersWithContext", "Lorg/dataloader/MappedBatchLoaderWithContext;", "addDataLoaderComponents", "", "addDataLoaderFields", "addDataLoaders", "T", "dgsComponent", "targetClass", "Ljava/lang/Class;", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "(Ljava/lang/Object;Ljava/lang/Class;Lcom/netflix/graphql/dgs/DgsDataLoader;Lorg/dataloader/registries/DispatchPredicate;)V", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "contextSupplier", "Ljava/util/function/Supplier;", "createDataLoader", "Lorg/dataloader/DataLoader;", "batchLoader", "dgsDataLoader", "dataLoaderName", "", "dataLoaderRegistry", "", "supplier", "findDataLoaders", "findDataLoaders$graphql_dgs", "registerDataLoader", "holder", "registry", "Lorg/dataloader/registries/ScheduledDataLoaderRegistry;", "runCustomizers", "originalDataLoader", "name", "dgsComponentClass", "wrappedDataLoader", "loader", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Iterable;)Ljava/lang/Object;", "Companion", "LoaderHolder", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataLoaderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataLoaderProvider.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderProvider\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n324#1,5:381\n329#1,22:388\n324#1,5:410\n329#1,22:417\n324#1,5:439\n329#1,22:446\n324#1,5:468\n329#1,22:475\n17#2,5:358\n22#2:371\n1855#3,2:363\n1855#3,2:365\n1855#3,2:367\n1855#3,2:369\n1855#3:372\n1856#3:375\n1855#3:376\n1856#3:378\n1855#3,2:379\n1855#3,2:386\n1855#3,2:415\n1855#3,2:444\n1855#3,2:473\n1855#3,2:497\n1855#3,2:499\n1855#3,2:501\n1855#3,2:503\n1313#4,2:373\n1#5:377\n*S KotlinDebug\n*F\n+ 1 DgsDataLoaderProvider.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderProvider\n*L\n207#1:381,5\n207#1:388,22\n223#1:410,5\n223#1:417,22\n245#1:439,5\n245#1:446,22\n266#1:468,5\n266#1:475,22\n87#1:358,5\n87#1:371\n88#1:363,2\n89#1:365,2\n90#1:367,2\n91#1:369,2\n105#1:372\n105#1:375\n137#1:376\n137#1:378\n180#1:379,2\n207#1:386,2\n223#1:415,2\n245#1:444,2\n266#1:473,2\n328#1:497,2\n333#1:499,2\n338#1:501,2\n343#1:503,2\n111#1:373,2\n*E\n"})
public final class DgsDataLoaderProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final List<DataLoaderInstrumentationExtensionProvider> extensionProviders;
    @NotNull
    private final List<DgsDataLoaderCustomizer> customizers;
    @NotNull
    private final DgsDataLoaderOptionsProvider dataLoaderOptionsProvider;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final Duration scheduleDuration;
    private final boolean enableTickerMode;
    @NotNull
    private final List<LoaderHolder<BatchLoader<?, ?>>> batchLoaders;
    @NotNull
    private final List<LoaderHolder<BatchLoaderWithContext<?, ?>>> batchLoadersWithContext;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoader<?, ?>>> mappedBatchLoaders;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoaderWithContext<?, ?>>> mappedBatchLoadersWithContext;
    @NotNull
    private static final Logger logger;

    public DgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull List<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders, @NotNull List<? extends DgsDataLoaderCustomizer> customizers, @NotNull DgsDataLoaderOptionsProvider dataLoaderOptionsProvider, @NotNull ScheduledExecutorService scheduledExecutorService, @NotNull Duration scheduleDuration, boolean enableTickerMode) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(extensionProviders, (String)"extensionProviders");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        Intrinsics.checkNotNullParameter((Object)dataLoaderOptionsProvider, (String)"dataLoaderOptionsProvider");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        Intrinsics.checkNotNullParameter((Object)scheduleDuration, (String)"scheduleDuration");
        this.applicationContext = applicationContext;
        this.extensionProviders = extensionProviders;
        this.customizers = customizers;
        this.dataLoaderOptionsProvider = dataLoaderOptionsProvider;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduleDuration = scheduleDuration;
        this.enableTickerMode = enableTickerMode;
        this.batchLoaders = new ArrayList();
        this.batchLoadersWithContext = new ArrayList();
        this.mappedBatchLoaders = new ArrayList();
        this.mappedBatchLoadersWithContext = new ArrayList();
    }

    public /* synthetic */ DgsDataLoaderProvider(ApplicationContext applicationContext, List list, List list2, DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider, ScheduledExecutorService scheduledExecutorService, Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            dgsDataLoaderOptionsProvider = new DefaultDataLoaderOptionsProvider();
        }
        if ((n & 0x10) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newSingleThreadScheduledExecutor(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        if ((n & 0x20) != 0) {
            Duration duration2 = Duration.ofMillis(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
            duration = duration2;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(applicationContext, list, list2, dgsDataLoaderOptionsProvider, scheduledExecutorService, duration, bl);
    }

    @NotNull
    public final DataLoaderRegistry buildRegistry() {
        return this.buildRegistryWithContextSupplier(buildRegistry.1.INSTANCE);
    }

    @NotNull
    public final <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        LoaderHolder it;
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        ScheduledDataLoaderRegistry registry = ScheduledDataLoaderRegistry.newScheduledRegistry().scheduledExecutorService(this.scheduledExecutorService).tickerMode(this.enableTickerMode).schedule(this.scheduleDuration).dispatchPredicate(DispatchPredicate.DISPATCH_NEVER).build();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Iterable $this$forEach$iv = this.batchLoaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)registry);
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        $this$forEach$iv = this.batchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)registry);
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        $this$forEach$iv = this.mappedBatchLoaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)registry);
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        $this$forEach$iv = this.mappedBatchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)registry);
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        long totalTime = System.currentTimeMillis() - start$iv;
        logger.debug("Created DGS dataloader registry in {}ms", (Object)totalTime);
        Intrinsics.checkNotNull((Object)registry);
        return (DataLoaderRegistry)registry;
    }

    @PostConstruct
    public final void findDataLoaders$graphql_dgs() {
        this.addDataLoaderComponents();
        this.addDataLoaderFields();
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataLoaderFields() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsComponent.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Field[] fieldArray = javaClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)addDataLoaderFields.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                if (AopUtils.isAopProxy(dgsComponent)) {
                    throw new UnsupportedSecuredDataLoaderException(dgsComponent.getClass());
                }
                DgsDataLoader annotation2 = field.getAnnotation(DgsDataLoader.class);
                ReflectionUtils.makeAccessible((Field)field);
                if (Intrinsics.areEqual((Object)annotation2.name(), (Object)"NETFLIX_DGS_GENERATE_DATALOADER_NAME")) {
                    Intrinsics.checkNotNull((Object)field);
                    throw new DgsUnnamedDataLoaderOnFieldException(field);
                }
                Object object = field.get(dgsComponent);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Object dataLoader = this.runCustomizers(object, annotation2.name(), dgsComponent.getClass());
                if (dataLoader instanceof BatchLoader) {
                    this.batchLoaders.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation2, dataLoader));
                    continue;
                }
                if (dataLoader instanceof BatchLoaderWithContext) {
                    this.batchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation2, dataLoader));
                    continue;
                }
                if (dataLoader instanceof MappedBatchLoader) {
                    this.mappedBatchLoaders.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation2, dataLoader));
                    continue;
                }
                if (dataLoader instanceof MappedBatchLoaderWithContext) {
                    this.mappedBatchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation2, dataLoader));
                    continue;
                }
                throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
            }
        }
    }

    private final void addDataLoaderComponents() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsDataLoader.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            DgsDataLoader annotation2;
            Class javaClass;
            Object dgsComponent;
            block3: {
                Object element$iv;
                dgsComponent = element$iv = iterator.next();
                boolean bl = false;
                javaClass = AopUtils.getTargetClass(dgsComponent);
                annotation2 = javaClass.getAnnotation(DgsDataLoader.class);
                Field[] fieldArray = javaClass.getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
                for (Object object2 : (Object[])fieldArray) {
                    Field it = (Field)object2;
                    boolean bl2 = false;
                    if (!it.isAnnotationPresent(DgsDispatchPredicate.class)) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            Field predicateField = (Field)object;
            if (predicateField != null) {
                ReflectionUtils.makeAccessible((Field)predicateField);
                Object dispatchPredicate = predicateField.get(dgsComponent);
                if (!(dispatchPredicate instanceof DispatchPredicate)) continue;
                Intrinsics.checkNotNull((Object)javaClass);
                Intrinsics.checkNotNull((Object)annotation2);
                this.addDataLoaders(dgsComponent, javaClass, annotation2, (DispatchPredicate)dispatchPredicate);
                continue;
            }
            Intrinsics.checkNotNull((Object)javaClass);
            Intrinsics.checkNotNull((Object)annotation2);
            this.addDataLoaders(dgsComponent, javaClass, annotation2, null);
        }
    }

    private final <T> void addDataLoaders(T dgsComponent, Class<?> targetClass, DgsDataLoader annotation2, DispatchPredicate dispatchPredicate) {
        String name = DataLoaderNameUtil.INSTANCE.getDataLoaderName(targetClass, annotation2);
        Object dataLoader = this.runCustomizers(dgsComponent, name, dgsComponent.getClass());
        if (dataLoader instanceof BatchLoader) {
            this.batchLoaders.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation2, targetClass, dispatchPredicate, dataLoader));
        } else if (dataLoader instanceof BatchLoaderWithContext) {
            this.batchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation2, targetClass, dispatchPredicate, dataLoader));
        } else if (dataLoader instanceof MappedBatchLoader) {
            this.mappedBatchLoaders.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation2, targetClass, dispatchPredicate, dataLoader));
        } else if (dataLoader instanceof MappedBatchLoaderWithContext) {
            this.mappedBatchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation2, targetClass, dispatchPredicate, dataLoader));
        } else {
            throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
        }
    }

    private final Object runCustomizers(Object originalDataLoader, String name, Class<?> dgsComponentClass) {
        Object dataLoader = null;
        dataLoader = originalDataLoader;
        Iterable $this$forEach$iv = this.customizers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            DgsDataLoaderCustomizer it = (DgsDataLoaderCustomizer)element$iv;
            boolean bl = false;
            Object object2 = dataLoader;
            if (object2 instanceof BatchLoader) {
                Object object3 = dataLoader;
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                object = it.provide((BatchLoader)object3, name);
            } else if (object2 instanceof BatchLoaderWithContext) {
                Object object4 = dataLoader;
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                object = it.provide((BatchLoaderWithContext)object4, name);
            } else if (object2 instanceof MappedBatchLoader) {
                Object object5 = dataLoader;
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                object = it.provide((MappedBatchLoader)object5, name);
            } else if (object2 instanceof MappedBatchLoaderWithContext) {
                Object object6 = dataLoader;
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                object = it.provide((MappedBatchLoaderWithContext)object6, name);
            } else {
                throw new InvalidDataLoaderTypeException(dgsComponentClass);
            }
            dataLoader = object;
        }
        return dataLoader;
    }

    private final DataLoader<?, ?> createDataLoader(BatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        BatchLoader<?, ?> batchLoader2;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    BatchLoader<?, ?> wrappedBatchLoader$iv;
                    BatchLoader<?, ?> batchLoader3 = batchLoader;
                    if (batchLoader3 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                        }
                        batchLoader2 = wrappedBatchLoader$iv;
                        if (batchLoader2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        break block14;
                    }
                    if (batchLoader3 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoader<?, ?> batchLoader4 = wrappedBatchLoader$iv;
                        if (batchLoader4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = batchLoader4;
                        break block14;
                    }
                    if (batchLoader3 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoader<?, ?> batchLoader5 = wrappedBatchLoader$iv;
                        if (batchLoader5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = batchLoader5;
                        break block14;
                    }
                    if (!(batchLoader3 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                    }
                    BatchLoader<?, ?> batchLoader6 = wrappedBatchLoader$iv;
                    if (batchLoader6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                    }
                    batchLoader2 = batchLoader6;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            batchLoader2 = batchLoader;
        }
        BatchLoader<?, ?> extendedBatchLoader = batchLoader2;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(...)");
        return dataLoader;
    }

    private final DataLoader<?, ?> createDataLoader(MappedBatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        MappedBatchLoader<?, ?> mappedBatchLoader;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    MappedBatchLoader<?, ?> wrappedBatchLoader$iv;
                    MappedBatchLoader<?, ?> mappedBatchLoader2 = batchLoader;
                    if (mappedBatchLoader2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoader<?, ?> mappedBatchLoader3 = wrappedBatchLoader$iv;
                        if (mappedBatchLoader3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = mappedBatchLoader3;
                        break block14;
                    }
                    if (mappedBatchLoader2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoader<?, ?> mappedBatchLoader4 = wrappedBatchLoader$iv;
                        if (mappedBatchLoader4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = mappedBatchLoader4;
                        break block14;
                    }
                    if (mappedBatchLoader2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                        }
                        mappedBatchLoader = wrappedBatchLoader$iv;
                        if (mappedBatchLoader == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        break block14;
                    }
                    if (!(mappedBatchLoader2 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                    }
                    MappedBatchLoader<?, ?> mappedBatchLoader5 = wrappedBatchLoader$iv;
                    if (mappedBatchLoader5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                    }
                    mappedBatchLoader = mappedBatchLoader5;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            mappedBatchLoader = batchLoader;
        }
        MappedBatchLoader<?, ?> extendedBatchLoader = mappedBatchLoader;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(...)");
        return dataLoader;
    }

    private final <T> DataLoader<?, ?> createDataLoader(BatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        BatchLoaderWithContext<?, ?> batchLoaderWithContext;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    BatchLoaderWithContext<?, ?> wrappedBatchLoader$iv;
                    BatchLoaderWithContext<?, ?> batchLoaderWithContext2 = batchLoader;
                    if (batchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoaderWithContext<?, ?> batchLoaderWithContext3 = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = batchLoaderWithContext3;
                        break block14;
                    }
                    if (batchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                        }
                        batchLoaderWithContext = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        break block14;
                    }
                    if (batchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoaderWithContext<?, ?> batchLoaderWithContext4 = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = batchLoaderWithContext4;
                        break block14;
                    }
                    if (!(batchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                    }
                    BatchLoaderWithContext<?, ?> batchLoaderWithContext5 = wrappedBatchLoader$iv;
                    if (batchLoaderWithContext5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                    }
                    batchLoaderWithContext = batchLoaderWithContext5;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            batchLoaderWithContext = batchLoader;
        }
        BatchLoaderWithContext<?, ?> extendedBatchLoader = batchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(...)");
        return dataLoader;
    }

    private final <T> DataLoader<?, ?> createDataLoader(MappedBatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    MappedBatchLoaderWithContext<?, ?> wrappedBatchLoader$iv;
                    MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext2 = batchLoader;
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext3 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext3;
                        break block14;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext4 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext4;
                        break block14;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext5 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext5;
                        break block14;
                    }
                    if (!(mappedBatchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                    }
                    mappedBatchLoaderWithContext = wrappedBatchLoader$iv;
                    if (mappedBatchLoaderWithContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                    }
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            mappedBatchLoaderWithContext = batchLoader;
        }
        MappedBatchLoaderWithContext<?, ?> extendedBatchLoader = mappedBatchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(...)");
        return dataLoader;
    }

    private final void registerDataLoader(LoaderHolder<?> holder, ScheduledDataLoaderRegistry registry, Supplier<?> contextSupplier, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        DataLoader<?, ?> dataLoader;
        Object obj = holder.getTheLoader();
        if (obj instanceof BatchLoader) {
            dataLoader = this.createDataLoader((BatchLoader)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), (DataLoaderRegistry)registry, extensionProviders);
        } else if (obj instanceof BatchLoaderWithContext) {
            dataLoader = this.createDataLoader((BatchLoaderWithContext)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), contextSupplier, (DataLoaderRegistry)registry, extensionProviders);
        } else if (obj instanceof MappedBatchLoader) {
            dataLoader = this.createDataLoader((MappedBatchLoader)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), (DataLoaderRegistry)registry, extensionProviders);
        } else if (obj instanceof MappedBatchLoaderWithContext) {
            dataLoader = this.createDataLoader((MappedBatchLoaderWithContext)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), contextSupplier, (DataLoaderRegistry)registry, extensionProviders);
        } else {
            throw new IllegalArgumentException("Data loader " + holder.getName() + " has unknown type");
        }
        DataLoader<?, ?> loader = dataLoader;
        if (registry.getKeys().contains(holder.getName())) {
            throw new MultipleDataLoadersDefinedException(holder.getTheLoader().getClass());
        }
        if (holder.getDispatchPredicate() == null) {
            registry.register(holder.getName(), loader, DispatchPredicate.DISPATCH_ALWAYS);
        } else {
            registry.register(holder.getName(), loader, holder.getDispatchPredicate());
        }
    }

    private final /* synthetic */ <T> T wrappedDataLoader(T loader, String name, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        boolean $i$f$wrappedDataLoader = false;
        try {
            T t = loader;
            if (t instanceof BatchLoader) {
                BatchLoader<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (BatchLoader<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((BatchLoader)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof BatchLoaderWithContext) {
                BatchLoaderWithContext<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (BatchLoaderWithContext<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((BatchLoaderWithContext)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof MappedBatchLoader) {
                MappedBatchLoader<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (MappedBatchLoader<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((MappedBatchLoader)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                MappedBatchLoaderWithContext<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (MappedBatchLoaderWithContext<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((MappedBatchLoaderWithContext)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            Object[] objectArray = new Object[]{name, loader, ex};
            logger.debug("Unable to wrap the [{} : {}]", objectArray);
        }
        return loader;
    }

    private static final <T> LoaderHolder<T> addDataLoaderFields$lambda$6$lambda$5$createHolder(DgsDataLoader annotation2, T t) {
        Intrinsics.checkNotNull((Object)annotation2);
        return new LoaderHolder(t, annotation2, annotation2.name(), null, 8, null);
    }

    private static final <T> LoaderHolder<T> addDataLoaders$createHolder$9(DgsDataLoader $annotation, Class<?> $targetClass, DispatchPredicate $dispatchPredicate, T t) {
        return new LoaderHolder<T>(t, $annotation, DataLoaderNameUtil.INSTANCE.getDataLoaderName($targetClass, $annotation), $dispatchPredicate);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DgsDataLoaderProvider.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J>\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "T", "", "theLoader", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "name", "", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)V", "getAnnotation", "()Lcom/netflix/graphql/dgs/DgsDataLoader;", "getDispatchPredicate", "()Lorg/dataloader/registries/DispatchPredicate;", "getName", "()Ljava/lang/String;", "getTheLoader", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs"})
    private static final class LoaderHolder<T> {
        private final T theLoader;
        @NotNull
        private final DgsDataLoader annotation;
        @NotNull
        private final String name;
        @Nullable
        private final DispatchPredicate dispatchPredicate;

        public LoaderHolder(T theLoader, @NotNull DgsDataLoader annotation2, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.theLoader = theLoader;
            this.annotation = annotation2;
            this.name = name;
            this.dispatchPredicate = dispatchPredicate;
        }

        public /* synthetic */ LoaderHolder(Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                dispatchPredicate = null;
            }
            this(object, dgsDataLoader, string, dispatchPredicate);
        }

        public final T getTheLoader() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader getAnnotation() {
            return this.annotation;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate getDispatchPredicate() {
            return this.dispatchPredicate;
        }

        public final T component1() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader component2() {
            return this.annotation;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate component4() {
            return this.dispatchPredicate;
        }

        @NotNull
        public final LoaderHolder<T> copy(T theLoader, @NotNull DgsDataLoader annotation2, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new LoaderHolder<T>(theLoader, annotation2, name, dispatchPredicate);
        }

        public static /* synthetic */ LoaderHolder copy$default(LoaderHolder loaderHolder, Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, Object object2) {
            if ((n & 1) != 0) {
                object = loaderHolder.theLoader;
            }
            if ((n & 2) != 0) {
                dgsDataLoader = loaderHolder.annotation;
            }
            if ((n & 4) != 0) {
                string = loaderHolder.name;
            }
            if ((n & 8) != 0) {
                dispatchPredicate = loaderHolder.dispatchPredicate;
            }
            return loaderHolder.copy(object, dgsDataLoader, string, dispatchPredicate);
        }

        @NotNull
        public String toString() {
            return "LoaderHolder(theLoader=" + this.theLoader + ", annotation=" + this.annotation + ", name=" + this.name + ", dispatchPredicate=" + this.dispatchPredicate + ")";
        }

        public int hashCode() {
            int result = this.theLoader == null ? 0 : this.theLoader.hashCode();
            result = result * 31 + this.annotation.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.dispatchPredicate == null ? 0 : this.dispatchPredicate.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoaderHolder)) {
                return false;
            }
            LoaderHolder loaderHolder = (LoaderHolder)other;
            if (!Intrinsics.areEqual(this.theLoader, loaderHolder.theLoader)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.annotation, (Object)loaderHolder.annotation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)loaderHolder.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dispatchPredicate, (Object)loaderHolder.dispatchPredicate);
        }
    }
}

