/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.EVCacheOperationImpl;
import net.spy.memcached.protocol.ascii.MetaDeleteOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDeleteOperationImpl
extends EVCacheOperationImpl
implements MetaDeleteOperation {
    private static final Logger log = LoggerFactory.getLogger(MetaDeleteOperationImpl.class);
    private static final OperationStatus DELETED = new OperationStatus(true, "HD", StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NF", StatusCode.SUCCESS);
    private static final OperationStatus EXISTS = new OperationStatus(false, "EX", StatusCode.SUCCESS);
    private final MetaDeleteOperation.Callback cb;
    private final MetaDeleteOperation.Builder builder;
    private boolean deleted = false;
    private long returnedCas = 0L;

    public MetaDeleteOperationImpl(MetaDeleteOperation.Builder builder, MetaDeleteOperation.Callback cb) {
        super(cb);
        this.builder = builder;
        this.cb = cb;
    }

    @Override
    public void handleLine(String line) {
        if (log.isDebugEnabled()) {
            log.debug("meta delete of {} returned {}", (Object)this.builder.getKey(), (Object)line);
        }
        if (line.equals("HD")) {
            this.deleted = true;
            this.getCallback().receivedStatus(DELETED);
            this.cb.deleteComplete(this.builder.getKey(), true);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.equals("NF")) {
            this.getCallback().receivedStatus(NOT_FOUND);
            this.cb.deleteComplete(this.builder.getKey(), false);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.equals("EX")) {
            this.getCallback().receivedStatus(EXISTS);
            this.cb.deleteComplete(this.builder.getKey(), false);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.startsWith("HD ") || line.startsWith("NF ") || line.startsWith("EX ")) {
            String[] parts = line.split(" ");
            this.deleted = parts[0].equals("HD");
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].length() <= 0) continue;
                char flag = parts[i].charAt(0);
                String value = parts[i].substring(1);
                if (flag == 'c') {
                    this.returnedCas = Long.parseLong(value);
                }
                this.cb.gotMetaData(this.builder.getKey(), flag, value);
            }
            this.getCallback().receivedStatus(this.deleted ? DELETED : NOT_FOUND);
            this.cb.deleteComplete(this.builder.getKey(), this.deleted);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    @Override
    public void initialize() {
        long recasidToUse;
        ArrayList<String> flags = new ArrayList<String>();
        if (this.builder.getMode() == MetaDeleteOperation.DeleteMode.INVALIDATE) {
            flags.add("I");
        }
        if (this.builder.getCas() > 0L) {
            flags.add("C" + this.builder.getCas());
        }
        if ((recasidToUse = this.builder.getRecasid()) > 0L) {
            flags.add("E" + recasidToUse);
            if (log.isDebugEnabled()) {
                log.debug("Using explicit recasid (E flag) for delete of key {}: {}", (Object)this.builder.getKey(), (Object)recasidToUse);
            }
        }
        if (this.builder.isReturnCas()) {
            flags.add("c");
        }
        if (this.builder.isReturnTtl()) {
            flags.add("t");
        }
        if (this.builder.isReturnSize()) {
            flags.add("s");
        }
        if (this.builder.isQuiet()) {
            flags.add("q");
        }
        byte[] keyBytes = KeyUtil.getKeyBytes((String)this.builder.getKey());
        StringBuilder cmdBuilder = new StringBuilder();
        cmdBuilder.append("md ").append(this.builder.getKey());
        for (String flag : flags) {
            cmdBuilder.append(" ").append(flag);
        }
        cmdBuilder.append("\r\n");
        byte[] cmdBytes = cmdBuilder.toString().getBytes();
        ByteBuffer b = ByteBuffer.allocate(cmdBytes.length);
        b.put(cmdBytes);
        b.flip();
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: md Key: " + this.builder.getKey() + " Mode: " + (Object)((Object)this.builder.getMode());
    }
}

