/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;

public interface MetaDeleteOperation
extends Operation {

    public static class Builder {
        private String key;
        private long cas = 0L;
        private long recasid = 0L;
        private DeleteMode mode = DeleteMode.DELETE;
        private boolean returnCas = false;
        private boolean returnTtl = false;
        private boolean returnSize = false;
        private boolean quiet = false;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        public Builder recasid(long recasid) {
            this.recasid = recasid;
            return this;
        }

        public Builder mode(DeleteMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder returnCas(boolean returnCas) {
            this.returnCas = returnCas;
            return this;
        }

        public Builder returnTtl(boolean returnTtl) {
            this.returnTtl = returnTtl;
            return this;
        }

        public Builder returnSize(boolean returnSize) {
            this.returnSize = returnSize;
            return this;
        }

        public Builder quiet(boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public long getCas() {
            return this.cas;
        }

        public long getRecasid() {
            return this.recasid;
        }

        public DeleteMode getMode() {
            return this.mode;
        }

        public boolean isReturnCas() {
            return this.returnCas;
        }

        public boolean isReturnTtl() {
            return this.returnTtl;
        }

        public boolean isReturnSize() {
            return this.returnSize;
        }

        public boolean isQuiet() {
            return this.quiet;
        }

        public Builder build() {
            return this;
        }
    }

    public static enum DeleteMode {
        DELETE(""),
        INVALIDATE("I");

        private final String flag;

        private DeleteMode(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return this.flag;
        }
    }

    public static interface Callback
    extends OperationCallback {
        public void deleteComplete(String var1, boolean var2);

        public void gotMetaData(String var1, char var2, String var3);
    }
}

