/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public interface NodeLocatorLookup<V> {
    public V wrappingCeilingValue(long var1);

    public static <V> void coalesceMap(TreeMap<Long, V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Long prevKey = null;
        Object prevValue = null;
        ArrayList<Long> keysToRemove = new ArrayList<Long>();
        for (Long key : map.keySet().toArray(new Long[0])) {
            V currentValue = map.get(key);
            if (prevValue != null && prevValue.equals(currentValue)) {
                keysToRemove.add(prevKey);
            }
            prevKey = key;
            prevValue = currentValue;
        }
        for (Long key : keysToRemove) {
            map.remove(key);
        }
    }

    public static class EytzingerNodeLocatorLookup<V>
    implements NodeLocatorLookup<V> {
        private final int[] hashes;
        private final V[] values;
        private final int leftmostNodePosition;

        EytzingerNodeLocatorLookup(TreeMap<Long, V> newNodeMap) {
            TreeMap<Long, V> clone = new TreeMap<Long, V>(newNodeMap);
            NodeLocatorLookup.coalesceMap(clone);
            long[] sortedHashes = clone.keySet().stream().mapToLong(Long::longValue).toArray();
            this.hashes = new int[sortedHashes.length];
            EytzingerNodeLocatorLookup.sortedToEytzinger(sortedHashes, this.hashes, 0, new int[]{0});
            this.values = this.constructValueArray(this.hashes.length);
            for (int i = 0; i < this.hashes.length; ++i) {
                this.values[i] = clone.get((long)this.hashes[i] & 0xFFFFFFFFL);
            }
            int _leftmostNodePosition = 0;
            while (2 * _leftmostNodePosition + 1 < this.hashes.length) {
                _leftmostNodePosition = 2 * _leftmostNodePosition + 1;
            }
            this.leftmostNodePosition = _leftmostNodePosition;
        }

        private V[] constructValueArray(int length) {
            return new Object[length];
        }

        @Override
        public V wrappingCeilingValue(long hash) {
            int pos = this.eytzingerCeilingPosition(hash);
            return this.values[pos];
        }

        private int eytzingerCeilingPosition(long hash) {
            int pos = 0;
            int candidate = -1;
            while (pos < this.hashes.length) {
                long nodeHash = (long)this.hashes[pos] & 0xFFFFFFFFL;
                if (hash <= nodeHash) {
                    candidate = pos;
                    pos = 2 * pos + 1;
                    continue;
                }
                pos = 2 * pos + 2;
            }
            if (candidate == -1) {
                return this.leftmostNodePosition;
            }
            return candidate;
        }

        private static void sortedToEytzinger(long[] sorted, int[] eytzinger, int i, int[] pos) {
            if (i >= eytzinger.length || pos[0] >= sorted.length) {
                return;
            }
            EytzingerNodeLocatorLookup.sortedToEytzinger(sorted, eytzinger, 2 * i + 1, pos);
            eytzinger[i] = (int)sorted[pos[0]];
            pos[0] = pos[0] + 1;
            EytzingerNodeLocatorLookup.sortedToEytzinger(sorted, eytzinger, 2 * i + 2, pos);
        }
    }

    public static class TreeMapNodeLocatorLookup<V>
    implements NodeLocatorLookup<V> {
        private final TreeMap<Long, V> map;

        TreeMapNodeLocatorLookup(TreeMap<Long, V> map) {
            this.map = map;
        }

        @Override
        public V wrappingCeilingValue(long hash) {
            Map.Entry<Long, V> entry = this.map.ceilingEntry(hash);
            if (entry == null) {
                entry = this.map.firstEntry();
            }
            return entry.getValue();
        }
    }
}

