/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.evcache.EVCacheClientPoolConfigurationProperties;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.EVCacheMetaOperations;
import com.netflix.evcache.operation.EVCacheItem;
import com.netflix.evcache.operation.EVCacheItemMetaData;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;

public interface EVCache
extends EVCacheMetaOperations {
    public <T> Future<Boolean>[] set(String var1, T var2) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, int var3) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, Transcoder<T> var3) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, EVCacheLatch.Policy var3) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, int var3, EVCacheLatch.Policy var4) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, Transcoder<T> var3, EVCacheLatch.Policy var4) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, Transcoder<T> var3, int var4, EVCacheLatch.Policy var5) throws EVCacheException;

    public <T> EVCacheLatch replace(String var1, T var2, EVCacheLatch.Policy var3) throws EVCacheException;

    public <T> EVCacheLatch replace(String var1, T var2, Transcoder<T> var3, EVCacheLatch.Policy var4) throws EVCacheException;

    public <T> EVCacheLatch replace(String var1, T var2, Transcoder<T> var3, int var4, EVCacheLatch.Policy var5) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, Transcoder<T> var3, int var4) throws EVCacheException;

    public Future<Boolean>[] delete(String var1) throws EVCacheException;

    public <T> EVCacheLatch delete(String var1, EVCacheLatch.Policy var2) throws EVCacheException;

    public <T> T get(String var1) throws EVCacheException;

    public <T> CompletableFuture<T> getAsync(String var1) throws EVCacheException;

    public <T> Single<T> get(String var1, Scheduler var2);

    public <T> T get(String var1, Transcoder<T> var2) throws EVCacheException;

    public <T> CompletableFuture<T> getAsync(String var1, Transcoder<T> var2) throws EVCacheException;

    default public EVCacheItemMetaData metaDebug(String key) throws EVCacheException {
        throw new EVCacheException("Default implementation. If you are implementing EVCache interface you need to implement this method.");
    }

    default public <T> EVCacheItem<T> metaGet(String key, Transcoder<T> tc) throws EVCacheException {
        throw new EVCacheException("Default implementation. If you are implementing EVCache interface you need to implement this method.");
    }

    public <T> T get(String var1, Transcoder<T> var2, EVCacheLatch.Policy var3) throws EVCacheException;

    public <T> Single<T> get(String var1, Transcoder<T> var2, Scheduler var3);

    public <T> Single<T> getAndTouch(String var1, int var2, Scheduler var3);

    public <T> Single<T> getAndTouch(String var1, int var2, Transcoder<T> var3, Scheduler var4);

    public <T> T getAndTouch(String var1, int var2) throws EVCacheException;

    public <T> T getAndTouch(String var1, int var2, Transcoder<T> var3) throws EVCacheException;

    public <T> Map<String, T> getBulk(String ... var1) throws EVCacheException;

    public <T> CompletableFuture<Map<String, T>> getAsyncBulk(String ... var1);

    public <T> Map<String, T> getBulk(Transcoder<T> var1, String ... var2) throws EVCacheException;

    public <T> CompletableFuture<Map<String, T>> getAsyncBulk(Collection<String> var1, Transcoder<T> var2);

    public <T> Map<String, T> getBulk(Collection<String> var1) throws EVCacheException;

    public <T> Map<String, T> getBulk(Collection<String> var1, Transcoder<T> var2) throws EVCacheException;

    public <T> Map<String, T> getBulkAndTouch(Collection<String> var1, Transcoder<T> var2, int var3) throws EVCacheException;

    public <T> Future<T> getAsynchronous(String var1) throws EVCacheException;

    public <T> Future<T> getAsynchronous(String var1, Transcoder<T> var2) throws EVCacheException;

    public long incr(String var1, long var2, long var4, int var6) throws EVCacheException;

    public long decr(String var1, long var2, long var4, int var6) throws EVCacheException;

    public <T> Future<Boolean>[] append(String var1, T var2, Transcoder<T> var3, int var4) throws EVCacheException;

    public <T> Future<Boolean>[] append(String var1, T var2, int var3) throws EVCacheException;

    public <T> boolean add(String var1, T var2, Transcoder<T> var3, int var4) throws EVCacheException;

    public <T> EVCacheLatch add(String var1, T var2, Transcoder<T> var3, int var4, EVCacheLatch.Policy var5) throws EVCacheException;

    public <T> Future<Boolean>[] touch(String var1, int var2) throws EVCacheException;

    public <T> EVCacheLatch touch(String var1, int var2, EVCacheLatch.Policy var3) throws EVCacheException;

    public <T> Future<Boolean>[] appendOrAdd(String var1, T var2, Transcoder<T> var3, int var4) throws EVCacheException;

    public <T> EVCacheLatch appendOrAdd(String var1, T var2, Transcoder<T> var3, int var4, EVCacheLatch.Policy var5) throws EVCacheException;

    public String getAppName();

    public String getCachePrefix();

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(EVCacheImpl.class);
        private String _appName;
        private String _cachePrefix = null;
        private int _ttl = 900;
        private Transcoder<?> _transcoder = null;
        private boolean _serverGroupRetry = true;
        private boolean _enableExceptionThrowing = false;
        private List<Customizer> _customizers = new ArrayList<Customizer>();
        @Inject
        private EVCacheClientPoolManager _poolManager;

        public static Builder forApp(String appName) {
            return new Builder().setAppName(appName);
        }

        public Builder withConfigurationProperties(EVCacheClientPoolConfigurationProperties configurationProperties) {
            return this.setCachePrefix(configurationProperties.getKeyPrefix()).setDefaultTTL(configurationProperties.getTimeToLive()).setRetry(configurationProperties.getRetryEnabled()).setExceptionThrowing(configurationProperties.getExceptionThrowingEnabled());
        }

        public Builder setAppName(String appName) {
            if (appName == null) {
                throw new IllegalArgumentException("param appName cannot be null.");
            }
            this._appName = appName.toUpperCase(Locale.US);
            if (!this._appName.startsWith("EVCACHE")) {
                logger.warn("Make sure the app you are connecting to is EVCache App");
            }
            return this;
        }

        public Builder setCachePrefix(String cachePrefix) {
            if (this._cachePrefix != null && this._cachePrefix.indexOf(58) != -1) {
                throw new IllegalArgumentException("param cacheName cannot contain ':' character.");
            }
            this._cachePrefix = cachePrefix;
            return this;
        }

        public Builder setCacheName(String cacheName) {
            return this.setCachePrefix(cacheName);
        }

        public Builder setDefaultTTL(int ttl) {
            if (ttl < 0) {
                throw new IllegalArgumentException("Time to Live cannot be less than 0.");
            }
            this._ttl = ttl;
            return this;
        }

        public Builder setDefaultTTL(@Nullable Duration ttl) {
            if (ttl == null) {
                return this;
            }
            return this.setDefaultTTL((int)ttl.getSeconds());
        }

        @VisibleForTesting
        Transcoder<?> getTranscoder() {
            return this._transcoder;
        }

        public <T> Builder setTranscoder(Transcoder<T> transcoder) {
            this._transcoder = transcoder;
            return this;
        }

        public <T> Builder enableZoneFallback() {
            this._serverGroupRetry = true;
            return this;
        }

        public Builder setRetry(boolean enableRetry) {
            this._serverGroupRetry = enableRetry;
            return this;
        }

        public <T> Builder enableRetry() {
            this._serverGroupRetry = true;
            return this;
        }

        public <T> Builder disableRetry() {
            this._serverGroupRetry = false;
            return this;
        }

        public <T> Builder disableZoneFallback() {
            this._serverGroupRetry = false;
            return this;
        }

        public Builder setExceptionThrowing(boolean enableExceptionThrowing) {
            this._enableExceptionThrowing = enableExceptionThrowing;
            return this;
        }

        public <T> Builder enableExceptionPropagation() {
            this._enableExceptionThrowing = true;
            return this;
        }

        public Builder addCustomizers(@Nullable List<Customizer> customizers) {
            this._customizers.addAll(customizers);
            return this;
        }

        public Builder customize() {
            this._customizers.forEach(customizer -> this.customizeWith((Customizer)customizer));
            return this;
        }

        public Builder customizeWith(Customizer customizer) {
            customizer.customize(this._appName, this);
            return this;
        }

        public Builder setPoolManager(EVCacheClientPoolManager poolManager) {
            this._poolManager = poolManager;
            return this;
        }

        protected EVCache newImpl(String appName, String cachePrefix, int ttl, Transcoder<?> transcoder, boolean serverGroupRetry, boolean enableExceptionThrowing, EVCacheClientPoolManager poolManager) {
            return new EVCacheImpl(appName, cachePrefix, ttl, transcoder, serverGroupRetry, enableExceptionThrowing, poolManager);
        }

        public EVCache build() {
            if (this._poolManager == null) {
                this._poolManager = EVCacheClientPoolManager.getInstance();
                if (logger.isDebugEnabled()) {
                    logger.debug("_poolManager - " + this._poolManager + " through getInstance");
                }
            }
            if (this._appName == null) {
                throw new IllegalArgumentException("param appName cannot be null.");
            }
            if (this._cachePrefix != null) {
                for (int i = 0; i < this._cachePrefix.length(); ++i) {
                    if (!Character.isWhitespace(this._cachePrefix.charAt(i))) continue;
                    throw new IllegalArgumentException("Cache Prefix ``" + this._cachePrefix + "`` contains invalid character at position " + i);
                }
            }
            this.customize();
            return this.newImpl(this._appName, this._cachePrefix, this._ttl, this._transcoder, this._serverGroupRetry, this._enableExceptionThrowing, this._poolManager);
        }

        public static class Factory {
            public Builder createInstance(String appName) {
                return Builder.forApp(appName);
            }
        }

        @FunctionalInterface
        public static interface Customizer {
            public void customize(String var1, Builder var2);
        }
    }

    public static enum Call {
        GET,
        GETL,
        GET_AND_TOUCH,
        ASYNC_GET,
        BULK,
        SET,
        DELETE,
        INCR,
        DECR,
        TOUCH,
        APPEND,
        PREPEND,
        REPLACE,
        ADD,
        APPEND_OR_ADD,
        GET_ALL,
        META_GET,
        META_SET,
        META_DEBUG,
        META_GET_BULK,
        META_DELETE,
        COMPLETABLE_FUTURE_GET,
        COMPLETABLE_FUTURE_GET_BULK;

    }
}

