/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.EVCacheOperationImpl;
import net.spy.memcached.protocol.ascii.MetaGetOperation;
import net.spy.memcached.protocol.ascii.OperationReadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaGetOperationImpl
extends EVCacheOperationImpl
implements MetaGetOperation {
    private static final Logger log = LoggerFactory.getLogger(MetaGetOperationImpl.class);
    private static final OperationStatus END = new OperationStatus(true, "EN", StatusCode.SUCCESS);
    private static final int OVERHEAD = 32;
    private final MetaGetOperation.Callback cb;
    private final String key;
    private int currentFlag = -1;
    private byte[] data = null;
    private int readOffset = 0;
    private byte lookingFor = 0;

    public MetaGetOperationImpl(String k, MetaGetOperation.Callback cb) {
        super(cb);
        this.key = k;
        this.cb = cb;
    }

    @Override
    public void handleLine(String line) {
        if (log.isDebugEnabled()) {
            log.debug("meta get of {} returned {}", (Object)this.key, (Object)line);
        }
        if (line.length() == 0 || line.equals("EN")) {
            this.getCallback().receivedStatus(END);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.startsWith("VA")) {
            String[] parts = line.split(" ");
            if (log.isDebugEnabled()) {
                log.debug("Num of parts " + parts.length);
            }
            if (parts.length <= 2) {
                return;
            }
            int size = Integer.parseInt(parts[1]);
            if (log.isDebugEnabled()) {
                log.debug("Size of value in bytes : " + size);
            }
            this.data = new byte[size];
            for (int i = 2; i < parts.length; ++i) {
                char flag = parts[i].charAt(0);
                String val = parts[i].substring(1);
                if (log.isDebugEnabled()) {
                    log.debug("flag=" + flag + "; Val=" + val);
                }
                this.cb.gotMetaData(this.key, flag, val);
                if (flag != 'f') continue;
                this.currentFlag = Integer.parseInt(val);
            }
            this.setReadType(OperationReadType.DATA);
        }
    }

    public void handleRead(ByteBuffer b) {
        if (log.isDebugEnabled()) {
            log.debug("readOffset: {}, length: {}", (Object)this.readOffset, (Object)this.data.length);
        }
        if (this.lookingFor == 0) {
            int toRead = this.data.length - this.readOffset;
            int available = b.remaining();
            toRead = Math.min(toRead, available);
            if (log.isDebugEnabled()) {
                log.debug("Reading {} bytes", (Object)toRead);
            }
            b.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.readOffset == this.data.length && this.lookingFor == 0) {
            OperationCallback cb = this.getCallback();
            if (cb instanceof MetaGetOperation.Callback) {
                MetaGetOperation.Callback mgcb = (MetaGetOperation.Callback)cb;
                mgcb.gotData(this.key, this.currentFlag, this.data);
            }
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && b.hasRemaining()) {
            do {
                byte tmp = b.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && b.hasRemaining());
            if (this.lookingFor == 0) {
                this.data = null;
                this.readOffset = 0;
                this.currentFlag = -1;
                this.getCallback().receivedStatus(END);
                this.transitionState(OperationState.COMPLETE);
                this.getLogger().debug((Object)"Setting read type back to line.");
                this.setReadType(OperationReadType.LINE);
            }
        }
    }

    @Override
    public void initialize() {
        String flags = "s f t h l c v";
        ByteBuffer b = ByteBuffer.allocate(KeyUtil.getKeyBytes((String)this.key).length + "s f t h l c v".length() + 32);
        this.setArguments(b, new Object[]{"mg", this.key, "s f t h l c v"});
        b.flip();
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: me Key: " + this.key;
    }
}

