/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;

public interface HashRingAlgorithm {
    public long hash(CharSequence var1);

    public int getCountHashParts();

    public void getHashPartsInto(CharSequence var1, long[] var2);

    public static class KetamaMd5HashRingAlgorithm
    implements HashRingAlgorithm {
        private static MessageDigest md5Digest = null;

        @Override
        public long hash(CharSequence key) {
            MessageDigest md5;
            long rv = 0L;
            try {
                md5 = (MessageDigest)md5Digest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("clone of MD5 not supported", e);
            }
            md5.update(key.toString().getBytes(StandardCharsets.UTF_8));
            byte[] bKey = md5.digest();
            rv = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
            return rv & 0xFFFFFFFFL;
        }

        @Override
        public int getCountHashParts() {
            return 4;
        }

        @Override
        public void getHashPartsInto(CharSequence key, long[] parts) {
            byte[] digest = DefaultHashAlgorithm.computeMd5((String)key.toString());
            for (int h = 0; h < 4; ++h) {
                parts[h] = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
            }
        }

        static {
            try {
                md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("MD5 not supported", e);
            }
        }
    }

    public static class SimpleHashRingAlgorithm
    implements HashRingAlgorithm {
        HashAlgorithm hashAlgorithm;

        public SimpleHashRingAlgorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        public long hash(CharSequence key) {
            return this.hashAlgorithm.hash(key.toString());
        }

        @Override
        public int getCountHashParts() {
            return 1;
        }

        @Override
        public void getHashPartsInto(CharSequence key, long[] parts) {
            parts[0] = this.hash(key);
        }
    }
}

