/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.util.KeyHasher;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheKey {
    private static final Logger log = LoggerFactory.getLogger(EVCacheKey.class);
    private final String appName;
    private final KeyHasher.HashingAlgorithm hashingAlgorithmAtAppLevel;
    private final Property<Boolean> shouldEncodeHashKeyAtAppLevel;
    private final Property<Integer> maxDigestBytesAtAppLevel;
    private final Property<Integer> maxHashLengthAtAppLevel;
    private final String key;
    private final String canonicalKey;
    private String canonicalKeyForDuet;
    private final Map<String, String> hashedKeysByAlgorithm;
    private final Map<String, String> hashedKeysByAlgorithmForDuet;
    private final String encoder;

    public EVCacheKey(String appName, String key, String canonicalKey, KeyHasher.HashingAlgorithm hashingAlgorithmAtAppLevel, Property<Boolean> shouldEncodeHashKeyAtAppLevel, Property<Integer> maxDigestBytesAtAppLevel, Property<Integer> maxHashLengthAtAppLevel) {
        this(appName, key, canonicalKey, hashingAlgorithmAtAppLevel, shouldEncodeHashKeyAtAppLevel, maxDigestBytesAtAppLevel, maxHashLengthAtAppLevel, null);
    }

    public EVCacheKey(String appName, String key, String canonicalKey, KeyHasher.HashingAlgorithm hashingAlgorithmAtAppLevel, Property<Boolean> shouldEncodeHashKeyAtAppLevel, Property<Integer> maxDigestBytesAtAppLevel, Property<Integer> maxHashLengthAtAppLevel, String encoder) {
        this.appName = appName;
        this.key = key;
        this.canonicalKey = canonicalKey;
        this.hashingAlgorithmAtAppLevel = hashingAlgorithmAtAppLevel;
        this.shouldEncodeHashKeyAtAppLevel = shouldEncodeHashKeyAtAppLevel;
        this.maxDigestBytesAtAppLevel = maxDigestBytesAtAppLevel;
        this.maxHashLengthAtAppLevel = maxHashLengthAtAppLevel;
        this.encoder = encoder;
        this.hashedKeysByAlgorithm = new HashMap<String, String>();
        this.hashedKeysByAlgorithmForDuet = new HashMap<String, String>();
    }

    public String getKey() {
        return this.key;
    }

    @Deprecated
    public String getCanonicalKey() {
        return this.canonicalKey;
    }

    public String getCanonicalKey(boolean isDuet) {
        return isDuet ? this.getCanonicalKeyForDuet() : this.canonicalKey;
    }

    private String getCanonicalKeyForDuet() {
        if (null == this.canonicalKeyForDuet) {
            int duetKeyLength = this.appName.length() + 1 + this.canonicalKey.length();
            this.canonicalKeyForDuet = new StringBuilder(duetKeyLength).append(this.appName).append(':').append(this.canonicalKey).toString();
            if (log.isDebugEnabled()) {
                log.debug("canonicalKeyForDuet : " + this.canonicalKeyForDuet);
            }
        }
        return this.canonicalKeyForDuet;
    }

    @Deprecated
    public String getHashKey() {
        return this.getHashKey(this.hashingAlgorithmAtAppLevel, null == this.shouldEncodeHashKeyAtAppLevel ? null : (Boolean)this.shouldEncodeHashKeyAtAppLevel.get(), null == this.maxDigestBytesAtAppLevel ? null : (Integer)this.maxDigestBytesAtAppLevel.get(), null == this.maxHashLengthAtAppLevel ? null : (Integer)this.maxHashLengthAtAppLevel.get(), this.encoder);
    }

    public String getHashKey(boolean isDuet, KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxDigestBytes, Integer maxHashLength, String baseEnoder) {
        String rKey;
        if (hashingAlgorithm == KeyHasher.HashingAlgorithm.NO_HASHING) {
            return null;
        }
        if (null == hashingAlgorithm) {
            hashingAlgorithm = this.hashingAlgorithmAtAppLevel;
        }
        if (null == shouldEncodeHashKey) {
            shouldEncodeHashKey = (Boolean)this.shouldEncodeHashKeyAtAppLevel.get();
        }
        if (null == maxDigestBytes) {
            maxDigestBytes = (Integer)this.maxDigestBytesAtAppLevel.get();
        }
        if (null == maxHashLength) {
            maxHashLength = (Integer)this.maxHashLengthAtAppLevel.get();
        }
        if (null == baseEnoder) {
            baseEnoder = this.encoder;
        }
        String string = rKey = isDuet ? this.getHashKeyForDuet(hashingAlgorithm, shouldEncodeHashKey, maxDigestBytes, maxHashLength, baseEnoder) : this.getHashKey(hashingAlgorithm, shouldEncodeHashKey, maxDigestBytes, maxHashLength, baseEnoder);
        if (log.isDebugEnabled()) {
            log.debug("Key : " + rKey);
        }
        return rKey;
    }

    public String getDerivedKey(boolean isDuet, KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxDigestBytes, Integer maxHashLength, String baseEnoder) {
        String derivedKey;
        if (null == hashingAlgorithm) {
            hashingAlgorithm = this.hashingAlgorithmAtAppLevel;
        }
        String string = derivedKey = null == hashingAlgorithm || hashingAlgorithm == KeyHasher.HashingAlgorithm.NO_HASHING ? this.getCanonicalKey(isDuet) : this.getHashKey(isDuet, hashingAlgorithm, shouldEncodeHashKey, maxDigestBytes, maxHashLength, baseEnoder);
        if (log.isDebugEnabled()) {
            log.debug("derivedKey : " + derivedKey);
        }
        return derivedKey;
    }

    private String getHashKey(KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxDigestBytes, Integer maxHashLength, String encoder) {
        if (null == hashingAlgorithm) {
            return null;
        }
        String key = hashingAlgorithm.toString() + maxDigestBytes != null ? maxDigestBytes.toString() : ("-" + maxHashLength != null ? maxHashLength.toString() : ("-" + encoder != null ? encoder : "-"));
        String val = this.hashedKeysByAlgorithm.get(key);
        if (val == null) {
            val = KeyHasher.getHashedKeyEncoded(this.getCanonicalKey(false), hashingAlgorithm, maxDigestBytes, maxHashLength, encoder);
            this.hashedKeysByAlgorithm.put(key, val);
        }
        if (log.isDebugEnabled()) {
            log.debug("getHashKey : " + val);
        }
        return val;
    }

    private String getHashKeyForDuet(KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxDigestBytes, Integer maxHashLength, String encoder) {
        if (null == hashingAlgorithm) {
            return null;
        }
        String key = hashingAlgorithm.toString() + maxDigestBytes != null ? maxDigestBytes.toString() : ("-" + maxHashLength != null ? maxHashLength.toString() : ("-" + encoder != null ? encoder : "-"));
        String val = this.hashedKeysByAlgorithmForDuet.get(key);
        if (val == null) {
            val = KeyHasher.getHashedKeyEncoded(this.getCanonicalKeyForDuet(), hashingAlgorithm, maxDigestBytes, maxHashLength, encoder);
            this.hashedKeysByAlgorithmForDuet.put(key, val);
        }
        if (log.isDebugEnabled()) {
            log.debug("getHashKeyForDuet : " + val);
        }
        return val;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalKey == null ? 0 : this.canonicalKey.hashCode());
        result = 31 * result + (this.canonicalKeyForDuet == null ? 0 : this.canonicalKeyForDuet.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EVCacheKey other = (EVCacheKey)obj;
        if (this.canonicalKey == null ? other.canonicalKey != null : !this.canonicalKey.equals(other.canonicalKey)) {
            return false;
        }
        if (this.canonicalKeyForDuet == null ? other.canonicalKeyForDuet != null : !this.canonicalKeyForDuet.equals(other.canonicalKeyForDuet)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return "EVCacheKey [key=" + this.key + ", canonicalKey=" + this.canonicalKey + ", canonicalKeyForDuet=" + this.canonicalKeyForDuet + (this.hashedKeysByAlgorithm.size() > 0 ? ", hashedKeysByAlgorithm=" + this.hashedKeysByAlgorithm.toString() : "") + (this.hashedKeysByAlgorithmForDuet.size() > 0 ? ", hashedKeysByAlgorithmForDuet=" + this.hashedKeysByAlgorithmForDuet.toString() + "]" : "]");
    }
}

