package com.netflix.evcache.pool;

import java.io.IOException;
import java.net.UnknownServiceException;
import java.util.Map;

public interface EVCacheNodeList {

    /**
     * Discover memcached instances suitable for our use from the Discovery
     * Service.
     * 
     * 
     * @param appName The EVCache app for which we need instances
     * @throws UnknownServiceException
     *             if no suitable instances can be found
     * @throws IllegalStateException
     *             if an error occurred in the Discovery service
     *
     *  TODO : Add a fallback to get the list say from PersistedProperties
     */
    public abstract Map<ServerGroup, EVCacheServerGroupConfig> discoverInstances(String appName) throws IOException;

}