/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.HashRingAlgorithm;
import com.netflix.evcache.pool.NodeLocatorLookup;
import com.netflix.evcache.util.EVCacheConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.EVCacheMemcachedNodeROImpl;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheNodeLocator
implements NodeLocator {
    private static final Logger log = LoggerFactory.getLogger(EVCacheNodeLocator.class);
    private TreeMap<Long, MemcachedNode> ketamaNodesTreeMap;
    private NodeLocatorLookup<MemcachedNode> ketamaNodes;
    protected final EVCacheClient client;
    private final Function<TreeMap<Long, MemcachedNode>, NodeLocatorLookup<MemcachedNode>> lookupFactory;
    private final Property<Boolean> partialStringHash;
    private final Property<String> hashDelimiter;
    private final Collection<MemcachedNode> allNodes;
    private final HashRingAlgorithm hashRingAlgorithm;
    private final KetamaNodeLocatorConfiguration config;

    public EVCacheNodeLocator(EVCacheClient client, List<MemcachedNode> nodes, HashRingAlgorithm hashRingAlgorithm, KetamaNodeLocatorConfiguration conf, Function<TreeMap<Long, MemcachedNode>, NodeLocatorLookup<MemcachedNode>> lookupFactory) {
        this.allNodes = nodes;
        this.hashRingAlgorithm = hashRingAlgorithm;
        this.config = conf;
        this.client = client;
        this.lookupFactory = lookupFactory;
        this.partialStringHash = EVCacheConfig.getInstance().getPropertyRepository().get(client.getAppName() + "." + client.getServerGroupName() + ".hash.on.partial.key", Boolean.class).orElseGet(client.getAppName() + ".hash.on.partial.key").orElse((Object)false);
        this.hashDelimiter = EVCacheConfig.getInstance().getPropertyRepository().get(client.getAppName() + "." + client.getServerGroupName() + ".hash.delimiter", String.class).orElseGet(client.getAppName() + ".hash.delimiter").orElse((Object)":");
        this.setKetamaNodes(nodes);
    }

    public EVCacheNodeLocator(EVCacheClient client, List<MemcachedNode> nodes, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this(client, nodes, alg == DefaultHashAlgorithm.KETAMA_HASH ? new HashRingAlgorithm.KetamaMd5HashRingAlgorithm() : new HashRingAlgorithm.SimpleHashRingAlgorithm(alg), conf, NodeLocatorLookup.EytzingerNodeLocatorLookup::new);
    }

    private EVCacheNodeLocator(EVCacheClient client, TreeMap<Long, MemcachedNode> smn, Collection<MemcachedNode> an, HashRingAlgorithm hashRingAlgorithm, KetamaNodeLocatorConfiguration conf, Function<TreeMap<Long, MemcachedNode>, NodeLocatorLookup<MemcachedNode>> lookupFactory) {
        this.ketamaNodes = lookupFactory.apply(smn);
        this.lookupFactory = lookupFactory;
        this.ketamaNodesTreeMap = smn;
        this.allNodes = an;
        this.hashRingAlgorithm = hashRingAlgorithm;
        this.config = conf;
        this.client = client;
        this.partialStringHash = EVCacheConfig.getInstance().getPropertyRepository().get(client.getAppName() + "." + client.getServerGroupName() + ".hash.on.partial.key", Boolean.class).orElseGet(client.getAppName() + ".hash.on.partial.key").orElse((Object)false);
        this.hashDelimiter = EVCacheConfig.getInstance().getPropertyRepository().get(client.getAppName() + "." + client.getServerGroupName() + ".hash.delimiter", String.class).orElseGet(client.getAppName() + ".hash.delimiter").orElse((Object)":");
    }

    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    public MemcachedNode getPrimary(String k) {
        int index;
        CharSequence key = k;
        if (((Boolean)this.partialStringHash.get()).booleanValue() && (index = k.indexOf((String)this.hashDelimiter.get())) > 0) {
            key = k.subSequence(0, index);
        }
        long hash = this.hashRingAlgorithm.hash(key);
        return this.ketamaNodes.wrappingCeilingValue(hash);
    }

    public long getMaxKey() {
        return this.getKetamaNodes().lastKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcachedNode getNodeForKey(long _hash) {
        long start = log.isDebugEnabled() ? System.nanoTime() : 0L;
        try {
            MemcachedNode memcachedNode = this.ketamaNodes.wrappingCeilingValue(_hash);
            return memcachedNode;
        }
        finally {
            if (log.isDebugEnabled()) {
                long end = System.nanoTime();
                log.debug("getNodeForKey : \t" + (end - start) / 1000L);
            }
        }
    }

    public Iterator<MemcachedNode> getSequence(String k) {
        ArrayList<MemcachedNode> allKetamaNodes = new ArrayList<MemcachedNode>(this.getKetamaNodes().values());
        Collections.shuffle(allKetamaNodes);
        return allKetamaNodes.iterator();
    }

    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, MemcachedNode> ketamaNaodes = new TreeMap<Long, MemcachedNode>((SortedMap<Long, MemcachedNode>)this.getKetamaNodes());
        ArrayList<MemcachedNode> aNodes = new ArrayList<MemcachedNode>(this.allNodes.size());
        for (Map.Entry<Long, MemcachedNode> me : ketamaNaodes.entrySet()) {
            me.setValue(new EVCacheMemcachedNodeROImpl(me.getValue()));
        }
        for (MemcachedNode n : this.allNodes) {
            aNodes.add(new EVCacheMemcachedNodeROImpl(n));
        }
        return new EVCacheNodeLocator(this.client, ketamaNaodes, aNodes, this.hashRingAlgorithm, this.config, this.lookupFactory);
    }

    protected TreeMap<Long, MemcachedNode> getKetamaNodes() {
        return this.ketamaNodesTreeMap;
    }

    public Map<Long, MemcachedNode> getKetamaNodeMap() {
        return Collections.unmodifiableMap(this.ketamaNodesTreeMap);
    }

    protected final void setKetamaNodes(List<MemcachedNode> nodes) {
        TreeMap<Long, MemcachedNode> newNodeMap = new TreeMap<Long, MemcachedNode>();
        int numReps = this.config.getNodeRepetitions();
        long[] parts = new long[this.hashRingAlgorithm.getCountHashParts()];
        for (MemcachedNode node : nodes) {
            for (int i = 0; i < numReps / 4; ++i) {
                String hashString = this.config.getKeyForNode(node, i);
                this.hashRingAlgorithm.getHashPartsInto(hashString, parts);
                for (int h = 0; h < parts.length; ++h) {
                    newNodeMap.put(parts[h], node);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("NewNodeMapSize : " + newNodeMap.size() + "; MapSize : " + numReps * nodes.size());
        }
        if (log.isTraceEnabled()) {
            for (Long key : newNodeMap.keySet()) {
                log.trace("Hash : " + key + "; Node : " + newNodeMap.get(key));
            }
        }
        this.ketamaNodes = this.lookupFactory.apply(newNodeMap);
        this.ketamaNodesTreeMap = newNodeMap;
    }

    public void updateLocator(List<MemcachedNode> nodes) {
        this.setKetamaNodes(nodes);
    }

    public String toString() {
        return "EVCacheNodeLocator [ketamaNodes=" + this.ketamaNodes + ", EVCacheClient=" + this.client + ", partialStringHash=" + this.partialStringHash + ", hashDelimiter=" + this.hashDelimiter + ", allNodes=" + this.allNodes + ", hashRingAlgorithm=" + this.hashRingAlgorithm + ", config=" + this.config + "]";
    }
}

