/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.EVCacheOperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaArithmeticOperationImpl
extends EVCacheOperationImpl
implements MutatorOperation {
    private static final Logger log = LoggerFactory.getLogger(MetaArithmeticOperationImpl.class);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private static final String META_ARITHMETIC_OP = "ma";
    private static final String AUTO_CREATE = "N%d";
    private static final String MUTATOR_MODE = "M%c";
    private static final char INCR = '+';
    private static final char DECR = '-';
    private static final String DEFAULT = "J%d";
    private static final String DELTA = "D%d";
    private static final char FLAG_VALUE = 'v';
    private static final String VALUE_RETURN = "VA";
    private final Mutator mutator;
    private final String key;
    private final long amount;
    private final long def;
    private final int exp;
    private boolean readingValue;
    public static final int OVERHEAD = 32;

    public MetaArithmeticOperationImpl(Mutator m, String k, long amt, long defaultVal, int expiry, OperationCallback c) {
        super(c);
        this.mutator = m;
        this.key = k;
        this.amount = amt;
        this.def = defaultVal;
        this.exp = expiry;
        this.readingValue = false;
    }

    @Override
    public void handleLine(String line) {
        log.debug("Result:  %s", (Object)line);
        OperationStatus found = null;
        if (line.startsWith(VALUE_RETURN)) {
            this.readingValue = true;
            this.setReadType(OperationReadType.LINE);
            return;
        }
        found = this.readingValue ? new OperationStatus(true, line, StatusCode.SUCCESS) : NOT_FOUND;
        this.getCallback().receivedStatus(found);
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        int size = KeyUtil.getKeyBytes((String)this.key).length + 32;
        ByteBuffer b = ByteBuffer.allocate(size);
        this.setArguments(b, new Object[]{META_ARITHMETIC_OP, this.key, String.format(AUTO_CREATE, this.exp), String.format(MUTATOR_MODE, Character.valueOf(this.mutator == Mutator.incr ? (char)'+' : '-')), String.format(DEFAULT, this.def), String.format(DELTA, this.amount), Character.valueOf('v')});
        b.flip();
        this.setBuffer(b);
    }

    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    public long getBy() {
        return this.amount;
    }

    public long getDefault() {
        return this.def;
    }

    public int getExpiration() {
        return this.exp;
    }

    public Mutator getType() {
        return this.mutator;
    }

    public String toString() {
        return "Cmd: " + this.mutator.name() + " Key: " + this.key + " Amount: " + this.amount + " Default: " + this.def + " Expiry: " + this.exp;
    }
}

