/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.ExecCmdOperation;
import net.spy.memcached.protocol.ascii.OperationImpl;

public class ExecCmdOperationImpl
extends OperationImpl
implements ExecCmdOperation {
    private static final OperationStatus OK = new OperationStatus(true, "OK", StatusCode.SUCCESS);
    private static final OperationStatus ERROR = new OperationStatus(true, "ERROR", StatusCode.ERR_INTERNAL);
    private final byte[] cmd;

    public ExecCmdOperationImpl(String arg, ExecCmdOperation.Callback c) {
        super((OperationCallback)c);
        this.cmd = (arg + "\r\n").getBytes();
    }

    public void initialize() {
        this.setBuffer(ByteBuffer.wrap(this.cmd));
    }

    public void handleLine(String line) {
        if (line.equals("OK")) {
            this.callback.receivedStatus(OK);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.equals("ERROR")) {
            this.callback.receivedStatus(ERROR);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    protected void wasCancelled() {
        this.callback.receivedStatus(CANCELLED);
    }

    public String toString() {
        return "Cmd: " + Arrays.toString(this.cmd);
    }
}

