/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.BulkGetFuture;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;

public class EVCacheBulkGetFuture<T>
extends BulkGetFuture<T> {
    private static final Logger log = LoggerFactory.getLogger(EVCacheBulkGetFuture.class);
    private final Map<String, Future<T>> rvMap;
    private final Collection<Operation> ops;
    private final CountDownLatch latch;
    private final long start;
    private final EVCacheClient client;
    private AtomicReferenceArray<SingleOperationState> operationStates;

    public EVCacheBulkGetFuture(Map<String, Future<T>> m, Collection<Operation> getOps, CountDownLatch l, ExecutorService service, EVCacheClient client) {
        super(m, getOps, l, service);
        this.rvMap = m;
        this.ops = getOps;
        this.latch = l;
        this.start = System.currentTimeMillis();
        this.client = client;
        this.operationStates = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, T> getSome(long to, TimeUnit unit, boolean throwException, boolean hasZF) throws InterruptedException, ExecutionException {
        HashMap<String, T> hashMap;
        block21: {
            assert (this.operationStates != null);
            boolean allCompleted = this.latch.await(to, unit);
            if (log.isDebugEnabled()) {
                log.debug("Took " + (System.currentTimeMillis() - this.start) + " to fetch " + this.rvMap.size() + " keys from " + this.client);
            }
            long pauseDuration = -1L;
            ArrayList<Tag> tagList = null;
            String statusString = "success";
            try {
                int i;
                if (!allCompleted) {
                    boolean gcPause = false;
                    tagList = new ArrayList<Tag>(7);
                    tagList.addAll(this.client.getTagList());
                    tagList.add((Tag)new BasicTag("evc.call", "BULK"));
                    RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
                    long vmStartTime = runtimeBean.getStartTime();
                    List<java.lang.management.GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
                    for (java.lang.management.GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                        long gcStartTime;
                        GcInfo lastGcInfo;
                        if (!(gcMXBean instanceof GarbageCollectorMXBean) || (lastGcInfo = ((GarbageCollectorMXBean)gcMXBean).getLastGcInfo()) == null || (gcStartTime = lastGcInfo.getStartTime() + vmStartTime) <= this.start) continue;
                        gcPause = true;
                        if (!log.isDebugEnabled()) break;
                        log.debug("Total duration due to gc event = " + lastGcInfo.getDuration() + " msec.");
                        break;
                    }
                    if (gcPause) {
                        allCompleted = this.latch.await(to, unit);
                        tagList.add((Tag)new BasicTag("evc.pause.reason", "gc"));
                        if (log.isDebugEnabled()) {
                            log.debug("Retry status : " + allCompleted);
                        }
                        if (allCompleted) {
                            tagList.add((Tag)new BasicTag("evc.fetch.after.pause", "yes"));
                        } else {
                            tagList.add((Tag)new BasicTag("evc.fetch.after.pause", "no"));
                        }
                    } else {
                        tagList.add((Tag)new BasicTag("evc.pause.reason", "Scheduling"));
                    }
                    pauseDuration = System.currentTimeMillis() - this.start;
                    if (log.isDebugEnabled()) {
                        log.debug("Total duration due to gc event = " + (System.currentTimeMillis() - this.start) + " msec.");
                    }
                }
                boolean hadTimedoutOp = false;
                for (i = 0; i < this.operationStates.length(); ++i) {
                    SingleOperationState state = this.operationStates.get(i);
                    if (!state.completed && !allCompleted) {
                        MemcachedConnection.opTimedOut((Operation)state.op);
                        hadTimedoutOp = true;
                        continue;
                    }
                    MemcachedConnection.opSucceeded((Operation)state.op);
                }
                if (!allCompleted && !hasZF && hadTimedoutOp) {
                    statusString = "timeout";
                }
                for (i = 0; i < this.operationStates.length(); ++i) {
                    SingleOperationState state = this.operationStates.get(i);
                    if (state.cancelled) {
                        if (hasZF) {
                            statusString = "cancelled";
                        }
                        if (throwException) {
                            throw new ExecutionException(new CancellationException("Cancelled"));
                        }
                    }
                    if (!state.errored || !throwException) continue;
                    throw new ExecutionException((Throwable)state.op.getException());
                }
                HashMap<String, T> m = new HashMap<String, T>();
                for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
                    m.put(me.getKey(), me.getValue().get());
                }
                hashMap = m;
                if (pauseDuration <= 0L) break block21;
                tagList.add((Tag)new BasicTag("evc.operation.status", statusString));
            }
            catch (Throwable throwable) {
                if (pauseDuration > 0L) {
                    tagList.add((Tag)new BasicTag("evc.operation.status", statusString));
                    EVCacheMetricsFactory.getInstance().getPercentileTimer("internal.evc.client.pause", tagList, Duration.ofMillis(((Integer)EVCacheConfig.getInstance().getPropertyRepository().get(this.getApp() + ".max.read.duration.metric", Integer.class).orElseGet("evcache.max.read.duration.metric").orElse((Object)20).get()).intValue())).record(pauseDuration, TimeUnit.MILLISECONDS);
                }
                throw throwable;
            }
            EVCacheMetricsFactory.getInstance().getPercentileTimer("internal.evc.client.pause", tagList, Duration.ofMillis(((Integer)EVCacheConfig.getInstance().getPropertyRepository().get(this.getApp() + ".max.read.duration.metric", Integer.class).orElseGet("evcache.max.read.duration.metric").orElse((Object)20).get()).intValue())).record(pauseDuration, TimeUnit.MILLISECONDS);
        }
        return hashMap;
    }

    public void setExpectedCount(int size) {
        assert (this.operationStates == null);
        this.operationStates = new AtomicReferenceArray(size);
    }

    public CompletableFuture<Map<String, T>> getSomeCompletableFuture(long to, TimeUnit unit, boolean throwException, boolean hasZF) {
        CompletableFuture<Map<String, Map<String, T>>> completableFuture = new CompletableFuture<Map<String, Map<String, T>>>();
        try {
            Map<String, T> value = this.getSome(to, unit, throwException, hasZF);
            completableFuture.complete(value);
        }
        catch (Exception e) {
            completableFuture.completeExceptionally(e);
        }
        return completableFuture;
    }

    public Single<Map<String, T>> observe() {
        return Single.create(subscriber -> this.addListener(future -> {
            try {
                subscriber.onSuccess((Object)this.get());
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }));
    }

    public <U> CompletableFuture<U> makeFutureWithTimeout(long timeout, TimeUnit units) {
        CompletableFuture future = new CompletableFuture();
        return EVCacheOperationFuture.withTimeout(future, timeout, units);
    }

    public CompletableFuture<Map<String, T>> getAsyncSome(long timeout, TimeUnit units) {
        CompletableFuture<Map<String, T>> future = this.makeFutureWithTimeout(timeout, units);
        this.doAsyncGetSome(future);
        return future.handle((data, ex) -> {
            if (ex != null) {
                this.handleBulkException();
            }
            return data;
        });
    }

    public void handleBulkException() {
        ExecutionException t = null;
        for (int i = 0; i < this.operationStates.length(); ++i) {
            SingleOperationState state = this.operationStates.get(i);
            if (!state.completed) {
                if (state.cancelled) {
                    throw new RuntimeException(new ExecutionException(new CancellationException("Cancelled")));
                }
                if (state.errored) {
                    throw new RuntimeException(new ExecutionException((Throwable)state.op.getException()));
                }
                state.op.timeOut();
                MemcachedConnection.opTimedOut((Operation)state.op);
                t = new ExecutionException((Throwable)new CheckedOperationTimeoutException("Checked Operation timed out.", state.op));
                continue;
            }
            MemcachedConnection.opSucceeded((Operation)state.op);
        }
        throw new RuntimeException(t);
    }

    public void doAsyncGetSome(CompletableFuture<Map<String, T>> promise) {
        this.addListener(future -> {
            try {
                HashMap m = new HashMap();
                Map result = future.get();
                for (Map.Entry me : result.entrySet()) {
                    m.put(me.getKey(), me.getValue());
                }
                promise.complete(m);
            }
            catch (Exception t) {
                promise.completeExceptionally(t);
            }
        });
    }

    public Single<Map<String, T>> getSome(long to, TimeUnit units, boolean throwException, boolean hasZF, Scheduler scheduler) {
        return this.observe().timeout(to, units, Single.create(subscriber -> {
            try {
                SingleOperationState state;
                int i;
                for (i = 0; i < this.operationStates.length(); ++i) {
                    state = this.operationStates.get(i);
                    if (!state.completed) {
                        MemcachedConnection.opTimedOut((Operation)state.op);
                        continue;
                    }
                    MemcachedConnection.opSucceeded((Operation)state.op);
                }
                for (i = 0; i < this.operationStates.length(); ++i) {
                    state = this.operationStates.get(i);
                    if (state.cancelled && throwException) {
                        throw new ExecutionException(new CancellationException("Cancelled"));
                    }
                    if (!state.errored || !throwException) continue;
                    throw new ExecutionException((Throwable)state.op.getException());
                }
                HashMap<String, T> m = new HashMap<String, T>();
                for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
                    m.put(me.getKey(), me.getValue().get());
                }
                subscriber.onSuccess(m);
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }), scheduler);
    }

    public String getZone() {
        return this.client.getServerGroupName();
    }

    public ServerGroup getServerGroup() {
        return this.client.getServerGroup();
    }

    public String getApp() {
        return this.client.getAppName();
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.rvMap.keySet());
    }

    public void signalComplete() {
        super.signalComplete();
    }

    public void signalSingleOpComplete(int sequenceNo, GetOperation op) {
        this.operationStates.set(sequenceNo, new SingleOperationState((Operation)op));
    }

    public boolean cancel(boolean ign) {
        if (log.isDebugEnabled()) {
            log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return super.cancel(ign);
    }

    public long getStartTime() {
        return this.start;
    }

    static class SingleOperationState {
        final Operation op;
        final boolean completed;
        final boolean cancelled;
        final boolean errored;
        final boolean timedOut;

        public SingleOperationState(Operation op) {
            this.op = op;
            this.completed = op.getState() == OperationState.COMPLETE;
            this.cancelled = op.isCancelled();
            this.errored = op.hasErrored();
            this.timedOut = op.isTimedOut();
        }
    }
}

