/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.BulkGetFuture;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;

public class EVCacheBulkGetFuture<T>
extends BulkGetFuture<T> {
    private static final Logger log = LoggerFactory.getLogger(EVCacheBulkGetFuture.class);
    private final Map<String, Future<T>> rvMap;
    private final Collection<Operation> ops;
    private final CountDownLatch latch;
    private final long start;
    private final EVCacheClient client;

    public EVCacheBulkGetFuture(Map<String, Future<T>> m, Collection<Operation> getOps, CountDownLatch l, ExecutorService service, EVCacheClient client) {
        super(m, getOps, l, service);
        this.rvMap = m;
        this.ops = getOps;
        this.latch = l;
        this.start = System.currentTimeMillis();
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, T> getSome(long to, TimeUnit unit, boolean throwException, boolean hasZF) throws InterruptedException, ExecutionException {
        HashMap<String, T> hashMap;
        block22: {
            boolean status = this.latch.await(to, unit);
            if (log.isDebugEnabled()) {
                log.debug("Took " + (System.currentTimeMillis() - this.start) + " to fetch " + this.rvMap.size() + " keys from " + this.client);
            }
            long pauseDuration = -1L;
            ArrayList<Tag> tagList = null;
            HashSet<Operation> timedoutOps = null;
            String statusString = "success";
            try {
                if (!status) {
                    boolean gcPause = false;
                    tagList = new ArrayList<Tag>(7);
                    tagList.addAll(this.client.getTagList());
                    tagList.add((Tag)new BasicTag("evc.call", "BULK"));
                    RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
                    long vmStartTime = runtimeBean.getStartTime();
                    List<java.lang.management.GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
                    for (java.lang.management.GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                        long gcStartTime;
                        GcInfo lastGcInfo;
                        if (!(gcMXBean instanceof GarbageCollectorMXBean) || (lastGcInfo = ((GarbageCollectorMXBean)gcMXBean).getLastGcInfo()) == null || (gcStartTime = lastGcInfo.getStartTime() + vmStartTime) <= this.start) continue;
                        gcPause = true;
                        if (!log.isDebugEnabled()) break;
                        log.debug("Total duration due to gc event = " + lastGcInfo.getDuration() + " msec.");
                        break;
                    }
                    if (gcPause) {
                        status = this.latch.await(to, unit);
                        tagList.add((Tag)new BasicTag("evc.pause.reason", "gc"));
                        if (log.isDebugEnabled()) {
                            log.debug("Retry status : " + status);
                        }
                        if (status) {
                            tagList.add((Tag)new BasicTag("evc.fetch.after.pause", "yes"));
                        } else {
                            tagList.add((Tag)new BasicTag("evc.fetch.after.pause", "no"));
                        }
                    } else {
                        tagList.add((Tag)new BasicTag("evc.pause.reason", "Scheduling"));
                    }
                    pauseDuration = System.currentTimeMillis() - this.start;
                    if (log.isDebugEnabled()) {
                        log.debug("Total duration due to gc event = " + (System.currentTimeMillis() - this.start) + " msec.");
                    }
                }
                for (Operation op : this.ops) {
                    if (op.getState() != OperationState.COMPLETE) {
                        if (!status) {
                            MemcachedConnection.opTimedOut((Operation)op);
                            if (timedoutOps == null) {
                                timedoutOps = new HashSet<Operation>();
                            }
                            timedoutOps.add(op);
                            continue;
                        }
                        MemcachedConnection.opSucceeded((Operation)op);
                        continue;
                    }
                    MemcachedConnection.opSucceeded((Operation)op);
                }
                if (!status && !hasZF && timedoutOps != null && timedoutOps.size() > 0) {
                    statusString = "timeout";
                }
                for (Operation op : this.ops) {
                    if (op.isCancelled()) {
                        if (hasZF) {
                            statusString = "cancelled";
                        }
                        if (throwException) {
                            throw new ExecutionException(new CancellationException("Cancelled"));
                        }
                    }
                    if (!op.hasErrored() || !throwException) continue;
                    throw new ExecutionException((Throwable)op.getException());
                }
                HashMap<String, T> m = new HashMap<String, T>();
                for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
                    m.put(me.getKey(), me.getValue().get());
                }
                hashMap = m;
                if (pauseDuration <= 0L) break block22;
                tagList.add((Tag)new BasicTag("evc.operation.status", statusString));
            }
            catch (Throwable throwable) {
                if (pauseDuration > 0L) {
                    tagList.add((Tag)new BasicTag("evc.operation.status", statusString));
                    EVCacheMetricsFactory.getInstance().getPercentileTimer("internal.evc.client.pause", tagList, Duration.ofMillis(((Integer)EVCacheConfig.getInstance().getPropertyRepository().get(this.getApp() + ".max.read.duration.metric", Integer.class).orElseGet("evcache.max.read.duration.metric").orElse((Object)20).get()).intValue())).record(pauseDuration, TimeUnit.MILLISECONDS);
                }
                throw throwable;
            }
            EVCacheMetricsFactory.getInstance().getPercentileTimer("internal.evc.client.pause", tagList, Duration.ofMillis(((Integer)EVCacheConfig.getInstance().getPropertyRepository().get(this.getApp() + ".max.read.duration.metric", Integer.class).orElseGet("evcache.max.read.duration.metric").orElse((Object)20).get()).intValue())).record(pauseDuration, TimeUnit.MILLISECONDS);
        }
        return hashMap;
    }

    public CompletableFuture<Map<String, T>> getSomeCompletableFuture(long to, TimeUnit unit, boolean throwException, boolean hasZF) {
        CompletableFuture<Map<String, Map<String, T>>> completableFuture = new CompletableFuture<Map<String, Map<String, T>>>();
        try {
            Map<String, T> value = this.getSome(to, unit, throwException, hasZF);
            completableFuture.complete(value);
        }
        catch (Exception e) {
            completableFuture.completeExceptionally(e);
        }
        return completableFuture;
    }

    public Single<Map<String, T>> observe() {
        return Single.create(subscriber -> this.addListener(future -> {
            try {
                subscriber.onSuccess((Object)this.get());
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }));
    }

    public <U> CompletableFuture<U> makeFutureWithTimeout(long timeout, TimeUnit units) {
        CompletableFuture future = new CompletableFuture();
        return EVCacheOperationFuture.withTimeout(future, timeout, units);
    }

    public CompletableFuture<Map<String, T>> getAsyncSome(long timeout, TimeUnit units) {
        CompletableFuture<Map<String, T>> future = this.makeFutureWithTimeout(timeout, units);
        this.doAsyncGetSome(future);
        return future;
    }

    public void doAsyncGetSome(CompletableFuture<Map<String, T>> promise) {
        this.addListener(future -> {
            try {
                HashMap m = new HashMap();
                Map result = future.get();
                for (Map.Entry me : result.entrySet()) {
                    m.put(me.getKey(), me.getValue());
                }
                promise.complete(m);
            }
            catch (Exception t) {
                promise.completeExceptionally(t);
            }
        });
    }

    public Single<Map<String, T>> getSome(long to, TimeUnit units, boolean throwException, boolean hasZF, Scheduler scheduler) {
        return this.observe().timeout(to, units, Single.create(subscriber -> {
            try {
                HashSet<Operation> timedoutOps = new HashSet<Operation>();
                for (Operation op : this.ops) {
                    if (op.getState() != OperationState.COMPLETE) {
                        MemcachedConnection.opTimedOut((Operation)op);
                        timedoutOps.add(op);
                        continue;
                    }
                    MemcachedConnection.opSucceeded((Operation)op);
                }
                for (Operation op : this.ops) {
                    if (op.isCancelled() && throwException) {
                        throw new ExecutionException(new CancellationException("Cancelled"));
                    }
                    if (!op.hasErrored() || !throwException) continue;
                    throw new ExecutionException((Throwable)op.getException());
                }
                HashMap<String, T> m = new HashMap<String, T>();
                for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
                    m.put(me.getKey(), me.getValue().get());
                }
                subscriber.onSuccess(m);
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }), scheduler);
    }

    public String getZone() {
        return this.client.getServerGroupName();
    }

    public ServerGroup getServerGroup() {
        return this.client.getServerGroup();
    }

    public String getApp() {
        return this.client.getAppName();
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.rvMap.keySet());
    }

    public void signalComplete() {
        super.signalComplete();
    }

    public boolean cancel(boolean ign) {
        if (log.isDebugEnabled()) {
            log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return super.cancel(ign);
    }

    public long getStartTime() {
        return this.start;
    }
}

