/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.config;

import com.netflix.archaius.api.config.PollingStrategy;
import com.netflix.archaius.config.PollingDynamicConfig;
import com.netflix.archaius.config.polling.FixedPollingStrategy;
import com.netflix.archaius.persisted2.DefaultPersisted2ClientConfig;
import com.netflix.archaius.persisted2.JsonPersistedV2Reader;
import com.netflix.archaius.persisted2.Persisted2ClientConfig;
import com.netflix.archaius.persisted2.ScopePredicates;
import com.netflix.archaius.persisted2.loader.HTTPStreamLoader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCachePersistedProperties {
    private static Logger log = LoggerFactory.getLogger(EVCachePersistedProperties.class);
    private static final String SCOPE_CLUSTER = "cluster";
    private static final String SCOPE_AMI = "ami";
    private static final String SCOPE_ZONE = "zone";
    private static final String SCOPE_ASG = "asg";
    private static final String SCOPE_SERVER_ID = "serverId";
    private static final String SCOPE_REGION = "region";
    private static final String SCOPE_STACK = "stack";
    private static final String SCOPE_ENV = "env";
    private static final String SCOPE_APP_ID = "appId";
    private PollingDynamicConfig config;

    private Persisted2ClientConfig getConfig() {
        String region = System.getProperty("netflix.region", this.getSystemEnvValue("NETFLIX_REGION", "us-east-1"));
        String env = System.getProperty("netflix.environment", this.getSystemEnvValue("NETFLIX_ENVIRONMENT", "test"));
        String url = System.getProperty("platformserviceurl", "http://platformservice." + region + ".dyn" + env + ".netflix.net:7001/platformservice/REST/v2/properties/jsonFilterprops");
        return new DefaultPersisted2ClientConfig().setEnabled(true).withServiceUrl(url).withQueryScope(SCOPE_APP_ID, new String[]{System.getProperty("netflix.appId", this.getSystemEnvValue("NETFLIX_APP", "")), ""}).withQueryScope(SCOPE_ENV, new String[]{env, ""}).withQueryScope(SCOPE_STACK, new String[]{System.getProperty("netflix.stack", this.getSystemEnvValue("NETFLIX_STACK", "")), ""}).withQueryScope(SCOPE_REGION, new String[]{region, ""}).withScope(SCOPE_APP_ID, System.getProperty("netflix.appId", this.getSystemEnvValue("NETFLIX_APP", ""))).withScope(SCOPE_ENV, env).withScope(SCOPE_STACK, System.getProperty("netflix.stack", this.getSystemEnvValue("NETFLIX_STACK", ""))).withScope(SCOPE_REGION, region).withScope(SCOPE_SERVER_ID, System.getProperty("netflix.serverId", this.getSystemEnvValue("NETFLIX_INSTANCE_ID", ""))).withScope(SCOPE_ASG, System.getProperty("netflix.appinfo.asgName", this.getSystemEnvValue("NETFLIX_AUTO_SCALE_GROUP", ""))).withScope(SCOPE_ZONE, this.getSystemEnvValue("EC2_AVAILABILITY_ZONE", "")).withScope(SCOPE_AMI, this.getSystemEnvValue("EC2_AMI_ID", "")).withScope(SCOPE_CLUSTER, this.getSystemEnvValue("NETFLIX_CLUSTER", "")).withPrioritizedScopes(new String[]{SCOPE_SERVER_ID, SCOPE_ASG, SCOPE_AMI, SCOPE_CLUSTER, SCOPE_APP_ID, SCOPE_ENV, SCOPE_STACK, SCOPE_ZONE, SCOPE_REGION});
    }

    private String getSystemEnvValue(String key, String def) {
        String val = System.getenv(key);
        return val == null ? def : val;
    }

    private String getFilterString(Map<String, Set<String>> scopes) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<String>> scope : scopes.entrySet()) {
            if (scope.getValue().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append("(");
            boolean first = true;
            for (String value : scope.getValue()) {
                if (!first) {
                    sb.append(" or ");
                } else {
                    first = false;
                }
                sb.append(scope.getKey());
                if (null == value) {
                    sb.append(" is null");
                    continue;
                }
                if (value.isEmpty()) {
                    sb.append("=''");
                    continue;
                }
                sb.append("='").append(value).append("'");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public PollingDynamicConfig getPollingDynamicConfig() {
        try {
            Persisted2ClientConfig clientConfig = this.getConfig();
            log.info("Remote config : " + clientConfig);
            String url = clientConfig.getServiceUrl() + "?skipPropsWithExtraScopes=" + clientConfig.getSkipPropsWithExtraScopes() + "&filter=" + URLEncoder.encode(this.getFilterString(clientConfig.getQueryScopes()), "UTF-8");
            if (clientConfig.isEnabled()) {
                JsonPersistedV2Reader reader = JsonPersistedV2Reader.builder((Callable)new HTTPStreamLoader(new URL(url))).withPath("propertiesList").withScopes(clientConfig.getPrioritizedScopes()).withPredicate(ScopePredicates.fromMap((Map)clientConfig.getScopes())).build();
                this.config = new PollingDynamicConfig((Callable)reader, (PollingStrategy)new FixedPollingStrategy((long)clientConfig.getRefreshRate(), TimeUnit.SECONDS));
                return this.config;
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return null;
    }
}

