/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.EVCacheNode;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ops.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheConnection
extends MemcachedConnection {
    private static final Logger log = LoggerFactory.getLogger(EVCacheConnection.class);

    public EVCacheConnection(String name, int bufSize, ConnectionFactory f, List<InetSocketAddress> a, Collection<ConnectionObserver> obs, FailureMode fm, OperationFactory opfactory) throws IOException {
        super(bufSize, f, a, obs, fm, opfactory);
        this.setName(name);
    }

    public void shutdown() throws IOException {
        try {
            super.shutdown();
            for (MemcachedNode qa : this.getLocator().getAll()) {
                if (!(qa instanceof EVCacheNode)) continue;
                ((EVCacheNode)qa).shutdown();
            }
        }
        finally {
            if (this.running) {
                this.running = false;
                if (log.isWarnEnabled()) {
                    log.warn("Forceful shutdown by interrupting the thread.", (Throwable)new Exception());
                }
                this.interrupt();
            }
        }
    }

    public void run() {
        while (this.running) {
            try {
                this.handleIO();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (CancelledKeyException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (ClosedSelectorException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (IllegalStateException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (ConcurrentModificationException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                log.error("SEVERE EVCACHE ISSUE.", e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(this.toString() + " : Shutdown");
        }
    }

    public String toString() {
        return super.toString();
    }

    protected void addOperation(MemcachedNode node, Operation o) {
        super.addOperation(node, o);
        ((EVCacheNode)node).incrOps();
    }

    public void addOperations(Map<MemcachedNode, Operation> ops) {
        super.addOperations(ops);
        for (MemcachedNode node : ops.keySet()) {
            ((EVCacheNode)node).incrOps();
        }
    }

    public void enqueueOperation(String key, Operation o) {
        this.checkState();
        this.addOperation(key, o);
    }

    public CountDownLatch broadcastOperation(BroadcastOpFactory of, Collection<MemcachedNode> nodes) {
        for (MemcachedNode node : nodes) {
            ((EVCacheNode)node).incrOps();
        }
        return super.broadcastOperation(of, nodes);
    }
}

