/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.net.InetAddresses;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNodeListProvider
implements EVCacheNodeList {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientPool.class);
    private static final String EUREKA_TIMEOUT = "evcache.eureka.timeout";
    private String currentNodeList = "";
    private final int timeout;
    private String region = null;
    private String env = null;

    public SimpleNodeListProvider() {
        String timeoutStr = System.getProperty(EUREKA_TIMEOUT);
        this.timeout = timeoutStr != null ? Integer.parseInt(timeoutStr) : 5000;
        String sysEnv = System.getenv("NETFLIX_ENVIRONMENT");
        if (sysEnv != null) {
            this.env = sysEnv;
        } else {
            String propEnv = null;
            if (propEnv == null) {
                propEnv = System.getProperty("@environment");
            }
            if (propEnv == null) {
                propEnv = System.getProperty("eureka.environment");
            }
            if (propEnv == null) {
                propEnv = System.getProperty("netflix.environment");
            }
            this.env = propEnv;
        }
        String sysRegion = System.getenv("EC2_REGION");
        if (sysRegion != null) {
            this.region = sysRegion;
        } else {
            String propRegion = null;
            if (propRegion == null) {
                propRegion = System.getProperty("@region");
            }
            if (propRegion == null) {
                propRegion = System.getProperty("eureka.region");
            }
            if (propRegion == null) {
                propRegion = System.getProperty("netflix.region");
            }
            this.region = propRegion;
        }
    }

    @Override
    public Map<ServerGroup, EVCacheServerGroupConfig> discoverInstances(String appName) throws IOException {
        String propertyName = appName + "-NODES";
        String nodeListString = (String)EVCacheConfig.getInstance().getPropertyRepository().get(propertyName, String.class).orElse((Object)"").get();
        if (log.isDebugEnabled()) {
            log.debug("List of Nodes = " + nodeListString);
        }
        if (nodeListString != null && nodeListString.length() > 0) {
            return this.bootstrapFromSystemProperty(nodeListString);
        }
        if (this.env != null && this.region != null) {
            return this.bootstrapFromEureka(appName);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ServerGroup, EVCacheServerGroupConfig> bootstrapFromEureka(String appName) throws IOException {
        if (this.env == null || this.region == null) {
            return Collections.emptyMap();
        }
        String url = "http://discoveryreadonly." + this.region + ".dyn" + this.env + ".netflix.net:7001/v2/apps/" + appName;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        long start = System.currentTimeMillis();
        PropertyRepository props = EVCacheConfig.getInstance().getPropertyRepository();
        CloseableHttpResponse httpResponse = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeout).setConnectTimeout(this.timeout).build();
            HttpGet httpGet = new HttpGet(url);
            httpGet.addHeader("Accept", "application/json");
            httpGet.setConfig(requestConfig);
            httpResponse = httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                log.error("Status Code : " + statusCode + " for url " + url);
                Map<ServerGroup, EVCacheServerGroupConfig> map = Collections.emptyMap();
                return map;
            }
            InputStreamReader in = new InputStreamReader(httpResponse.getEntity().getContent(), Charset.defaultCharset());
            JSONTokener js = new JSONTokener((Reader)in);
            JSONObject jsonObj = new JSONObject(js);
            JSONObject application = jsonObj.getJSONObject("application");
            JSONArray instances = application.getJSONArray("instance");
            HashMap<ServerGroup, EVCacheServerGroupConfig> serverGroupMap = new HashMap<ServerGroup, EVCacheServerGroupConfig>();
            Property useBatchPort = props.get(appName + ".use.batch.port", Boolean.class).orElseGet("evcache.use.batch.port").orElse((Object)false);
            int securePort = Integer.parseInt((String)props.get("evcache.secure.port", String.class).orElse((Object)"11443").get());
            for (int i = 0; i < instances.length(); ++i) {
                JSONObject instanceObj = instances.getJSONObject(i);
                JSONObject metadataObj = instanceObj.getJSONObject("dataCenterInfo").getJSONObject("metadata");
                String asgName = instanceObj.getString("asgName");
                Property asgEnabled = props.get(asgName + ".enabled", Boolean.class).orElse((Object)true);
                boolean isSecure = (Boolean)props.get(asgName + ".use.secure", Boolean.class).orElseGet(appName + ".use.secure").orElseGet("evcache.use.secure").orElse((Object)false).get();
                if (!((Boolean)asgEnabled.get()).booleanValue()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("ASG " + asgName + " is disabled so ignoring it");
                    continue;
                }
                String zone = metadataObj.getString("availability-zone");
                ServerGroup rSet = new ServerGroup(zone, asgName);
                String localIp = metadataObj.getString("local-ipv4");
                JSONObject instanceMetadataObj = instanceObj.getJSONObject("metadata");
                String evcachePortString = instanceMetadataObj.optString("evcache.port", "11211");
                String rendPortString = instanceMetadataObj.optString("rend.port", "0");
                String rendBatchPortString = instanceMetadataObj.optString("rend.batch.port", "0");
                int rendPort = Integer.parseInt(rendPortString);
                int rendBatchPort = Integer.parseInt(rendBatchPortString);
                String rendMemcachedPortString = instanceMetadataObj.optString("rend.memcached.port", "0");
                String rendMementoPortString = instanceMetadataObj.optString("rend.memento.port", "0");
                int evcachePort = Integer.parseInt(evcachePortString);
                int port = isSecure ? securePort : (rendPort == 0 ? evcachePort : ((Boolean)useBatchPort.get() != false ? rendBatchPort : rendPort));
                EVCacheServerGroupConfig config = (EVCacheServerGroupConfig)serverGroupMap.get(rSet);
                if (config == null) {
                    config = new EVCacheServerGroupConfig(rSet, new HashSet<InetSocketAddress>(), Integer.parseInt(rendPortString), Integer.parseInt(rendMemcachedPortString), Integer.parseInt(rendMementoPortString));
                    serverGroupMap.put(rSet, config);
                }
                InetAddress add = InetAddresses.forString((String)localIp);
                InetAddress inetAddress = InetAddress.getByAddress(localIp, add.getAddress());
                InetSocketAddress address = new InetSocketAddress(inetAddress, port);
                config.getInetSocketAddress().add(address);
            }
            if (log.isDebugEnabled()) {
                log.debug("Returning : " + serverGroupMap);
            }
            HashMap<ServerGroup, EVCacheServerGroupConfig> hashMap = serverGroupMap;
            return hashMap;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("URL : " + url + "; Timeout " + this.timeout, (Throwable)e);
            }
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException iOException) {}
            }
            if (log.isDebugEnabled()) {
                log.debug("Total Time to execute " + url + " " + (System.currentTimeMillis() - start) + " msec.");
            }
        }
        return Collections.emptyMap();
    }

    private Map<ServerGroup, EVCacheServerGroupConfig> bootstrapFromSystemProperty(String nodeListString) throws IOException {
        HashMap<ServerGroup, EVCacheServerGroupConfig> instancesSpecific = new HashMap<ServerGroup, EVCacheServerGroupConfig>();
        StringTokenizer setTokenizer = new StringTokenizer(nodeListString, ";");
        while (setTokenizer.hasMoreTokens()) {
            String token = setTokenizer.nextToken();
            StringTokenizer replicaSetTokenizer = new StringTokenizer(token, "=");
            while (replicaSetTokenizer.hasMoreTokens()) {
                String replicaSetToken = replicaSetTokenizer.nextToken();
                String instanceToken = replicaSetTokenizer.nextToken();
                StringTokenizer instanceTokenizer = new StringTokenizer(instanceToken, ",");
                HashSet<InetSocketAddress> instanceList = new HashSet<InetSocketAddress>();
                ServerGroup rSet = new ServerGroup(replicaSetToken, replicaSetToken);
                EVCacheServerGroupConfig config = new EVCacheServerGroupConfig(rSet, instanceList, 0, 0, 0);
                instancesSpecific.put(rSet, config);
                while (instanceTokenizer.hasMoreTokens()) {
                    String instance = instanceTokenizer.nextToken();
                    int index = instance.indexOf(58);
                    String host = instance.substring(0, index);
                    String port = instance.substring(index + 1);
                    int ind = host.indexOf(47);
                    if (ind == -1) {
                        InetAddress add = InetAddress.getByName(host);
                        instanceList.add(new InetSocketAddress(add, Integer.parseInt(port)));
                        continue;
                    }
                    String hostName = host.substring(0, ind);
                    String localIp = host.substring(ind + 1);
                    InetAddress add = InetAddresses.forString((String)localIp);
                    InetAddress inetAddress = InetAddress.getByAddress(hostName, add.getAddress());
                    instanceList.add(new InetSocketAddress(inetAddress, Integer.parseInt(port)));
                }
            }
        }
        this.currentNodeList = nodeListString;
        if (log.isDebugEnabled()) {
            log.debug("List by Servergroup" + instancesSpecific);
        }
        return instancesSpecific;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"Current Node List\":\"");
        builder.append(this.currentNodeList);
        builder.append("\"");
        builder.append("\"}");
        return builder.toString();
    }
}

