/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;
import rx.functions.Action0;

@SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED"})
public class EVCacheOperationFuture<T>
extends OperationFuture<T> {
    private static final Logger log = LoggerFactory.getLogger(EVCacheOperationFuture.class);
    private final CountDownLatch latch;
    private final AtomicReference<T> objRef;
    private Operation op;
    private final String key;
    private final long start;
    private final EVCacheClient client;

    public EVCacheOperationFuture(String k, CountDownLatch l, AtomicReference<T> oref, long opTimeout, ExecutorService service, EVCacheClient client) {
        super(k, l, oref, opTimeout, service);
        this.latch = l;
        this.objRef = oref;
        this.key = k;
        this.client = client;
        this.start = System.currentTimeMillis();
    }

    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation to) {
        this.op = to;
        super.setOperation(to);
    }

    public String getApp() {
        return this.client.getAppName();
    }

    public String getKey() {
        return this.key;
    }

    public String getZone() {
        return this.client.getZone();
    }

    public ServerGroup getServerGroup() {
        return this.client.getServerGroup();
    }

    public EVCacheClient getEVCacheClient() {
        return this.client;
    }

    public EVCacheOperationFuture<T> addListener(EVCacheGetOperationListener<T> listener) {
        super.addToListeners(listener);
        return this;
    }

    public EVCacheOperationFuture<T> removeListener(EVCacheGetOperationListener<T> listener) {
        super.removeFromListeners(listener);
        return this;
    }

    public T get(long duration, TimeUnit units, boolean throwException, boolean hasZF) throws InterruptedException, TimeoutException, ExecutionException {
        boolean status = this.latch.await(duration, units);
        if (!status) {
            status = this.handleGCPauseForGet(duration, units, throwException, hasZF);
        }
        if (status) {
            MemcachedConnection.opSucceeded((Operation)this.op);
        }
        return this.objRef.get();
    }

    private boolean handleGCPauseForGet(long duration, TimeUnit units, boolean throwException, boolean hasZF) throws InterruptedException, ExecutionException {
        boolean gcPause = false;
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        long vmStartTime = runtimeBean.getStartTime();
        List<java.lang.management.GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (java.lang.management.GarbageCollectorMXBean gcMXBean : gcMXBeans) {
            long gcStartTime;
            GcInfo lastGcInfo;
            if (!(gcMXBean instanceof GarbageCollectorMXBean) || (lastGcInfo = ((GarbageCollectorMXBean)gcMXBean).getLastGcInfo()) == null || (gcStartTime = lastGcInfo.getStartTime() + vmStartTime) <= this.start) continue;
            gcPause = true;
            long gcDuration = lastGcInfo.getDuration();
            long pauseDuration = System.currentTimeMillis() - gcStartTime;
            if (!log.isDebugEnabled()) break;
            log.debug("Event Start Time = " + this.start + "; Last GC Start Time = " + gcStartTime + "; " + (gcStartTime - this.start) + " msec ago.\n\nTotal pause duration due for this event = " + pauseDuration + " msec.\nTotal GC duration = " + gcDuration + " msec.");
            break;
        }
        if (!gcPause && log.isDebugEnabled()) {
            log.debug("Total pause duration due to NON-GC event = " + (System.currentTimeMillis() - this.start) + " msec.");
        }
        boolean status = this.latch.await(duration, units);
        if (log.isDebugEnabled()) {
            log.debug("re-await status : " + status);
        }
        String statusString = "success";
        long pauseDuration = System.currentTimeMillis() - this.start;
        if (this.op != null && !status) {
            MemcachedConnection.opTimedOut((Operation)this.op);
            this.op.timeOut();
            ExecutionException t = null;
            if (throwException && !hasZF) {
                if (this.op.isTimedOut()) {
                    t = new ExecutionException(new CheckedOperationTimeoutException("Checked Operation timed out.", this.op));
                    statusString = "CheckedOperationTimeout";
                } else if (this.op.isCancelled() && throwException) {
                    t = new ExecutionException(new CancellationException("Cancelled"));
                    statusString = "cancelled";
                } else if (this.op.hasErrored()) {
                    t = new ExecutionException((Throwable)this.op.getException());
                    statusString = "error";
                }
            }
            if (t != null) {
                throw t;
            }
        }
        ArrayList<Tag> tagList = new ArrayList<Tag>(this.client.getTagList().size() + 4);
        tagList.addAll(this.client.getTagList());
        tagList.add((Tag)new BasicTag("evc.call", "GET"));
        tagList.add((Tag)new BasicTag("evc.pause.reason", gcPause ? "gc" : "Scheduling"));
        tagList.add((Tag)new BasicTag("evc.fetch.after.pause", status ? "yes" : "no"));
        tagList.add((Tag)new BasicTag("evc.operation.status", statusString));
        EVCacheMetricsFactory.getInstance().getPercentileTimer("internal.evc.client.pause", tagList, Duration.ofMillis(((Integer)EVCacheConfig.getInstance().getPropertyRepository().get(this.getApp() + ".max.write.duration.metric", Integer.class).orElseGet("evcache.max.write.duration.metric").orElse((Object)50).get()).intValue())).record(pauseDuration, TimeUnit.MILLISECONDS);
        return status;
    }

    public Single<T> observe() {
        return Single.create(subscriber -> this.addListener(future -> {
            try {
                subscriber.onSuccess(this.get());
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }));
    }

    static <T> CompletableFuture<T> withTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        int timeoutSlots = EVCacheOperationFuture.getTimeoutSlots((int)timeout);
        long splitTimeout = Math.max(1L, timeout / (long)timeoutSlots);
        CompletionStage<Object> chain = CompletableFuture.completedFuture(null);
        int i = 0;
        while (i < timeoutSlots) {
            int j = i++;
            chain = chain.thenCompose(unused -> EVCacheOperationFuture.getNext(future, j, timeout, splitTimeout, unit, timeoutSlots));
        }
        return future;
    }

    private static int getTimeoutSlots(int timeout) {
        int val;
        if (log.isDebugEnabled()) {
            log.debug("Timeout is {}", (Object)timeout);
        }
        int timeoutSlots = (val = timeout / 10) == 0 ? 1 : (val >= 1 && val < 5 ? val : 5);
        if (log.isDebugEnabled()) {
            log.debug("timeoutSlots is {}", (Object)timeoutSlots);
        }
        return timeoutSlots;
    }

    private static <T> CompletableFuture<Void> getNext(CompletableFuture<T> future, int j, long timeout, long splitTimeout, TimeUnit unit, int timeoutSlots) {
        CompletableFuture<Void> next = new CompletableFuture<Void>();
        if (future.isDone()) {
            next.complete(null);
        } else {
            ScheduledFuture<?> scheduledTimeout = j < timeoutSlots - 1 ? LazySharedExecutor.executor.schedule(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("Completing now for loop {} and timeout slot {}", (Object)j, (Object)timeoutSlots);
                }
                next.complete(null);
            }, splitTimeout, TimeUnit.MILLISECONDS) : LazySharedExecutor.executor.schedule(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("Throwing timeout exception after {} {} with timeout slot {}", new Object[]{timeout, unit, timeoutSlots});
                }
                future.completeExceptionally(new TimeoutException("Timeout after " + timeout));
            }, splitTimeout, unit);
            future.whenComplete((r, exp) -> {
                if (exp == null) {
                    scheduledTimeout.cancel(false);
                    if (log.isDebugEnabled()) {
                        log.debug("completing the future");
                    }
                    next.complete(null);
                }
            });
        }
        return next;
    }

    public <U> CompletableFuture<U> makeFutureWithTimeout(long timeout, TimeUnit units) {
        CompletableFuture future = new CompletableFuture();
        return EVCacheOperationFuture.withTimeout(future, timeout, units);
    }

    private void handleTimeoutException() {
        if (log.isDebugEnabled()) {
            log.debug("handling the timeout in handleTimeoutException");
        }
        MemcachedConnection.opTimedOut((Operation)this.op);
        if (this.op != null) {
            this.op.timeOut();
        }
        ExecutionException t = null;
        if (this.op.isTimedOut()) {
            if (log.isDebugEnabled()) {
                log.debug("Checked Operation timed out with operation {}.", (Object)this.op);
            }
            t = new ExecutionException(new CheckedOperationTimeoutException("Checked Operation timed out.", this.op));
        } else if (this.op.isCancelled()) {
            if (log.isDebugEnabled()) {
                log.debug("Cancelled with operation {}.", (Object)this.op);
            }
            t = new ExecutionException(new CancellationException("Cancelled"));
        } else if (this.op.hasErrored()) {
            if (log.isDebugEnabled()) {
                log.debug("Other exception with operation {}.", (Object)this.op);
            }
            t = new ExecutionException((Throwable)this.op.getException());
        }
        throw new RuntimeException(t);
    }

    public CompletableFuture<T> getAsync(long timeout, TimeUnit units) {
        CompletableFuture future = this.makeFutureWithTimeout(timeout, units);
        this.doAsyncGet(future);
        return future.handle((data, ex) -> {
            if (ex != null) {
                this.handleTimeoutException();
            }
            return data;
        });
    }

    private void doAsyncGet(CompletableFuture<T> cf) {
        EVCacheGetOperationListener listener = future -> {
            try {
                Object result = future.get();
                cf.complete(result);
            }
            catch (Exception t) {
                cf.completeExceptionally(t);
            }
        };
        this.addListener(listener);
    }

    public Single<T> get(long duration, TimeUnit units, boolean throwException, boolean hasZF, Scheduler scheduler) {
        return this.observe().timeout(duration, units, Single.create(subscriber -> {
            MemcachedConnection.opTimedOut((Operation)this.op);
            if (this.op != null) {
                this.op.timeOut();
            }
            if (throwException) {
                subscriber.onError((Throwable)new CheckedOperationTimeoutException("Timed out waiting for operation", this.op));
            } else {
                if (this.isCancelled()) {
                    // empty if block
                }
                subscriber.onSuccess(this.objRef.get());
            }
        }), scheduler).doAfterTerminate(new Action0(){

            public void call() {
            }
        });
    }

    public void signalComplete() {
        super.signalComplete();
    }

    public boolean cancel(boolean ign) {
        if (log.isDebugEnabled()) {
            log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return super.cancel(ign);
    }

    public boolean cancel() {
        if (log.isDebugEnabled()) {
            log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return super.cancel();
    }

    public long getStartTime() {
        return this.start;
    }

    private static final class LazySharedExecutor {
        private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("evcache-timeout-%s").setUncaughtExceptionHandler((t, e) -> log.error("{} timeout operation failed with exception: {}", (Object)t.getName(), (Object)e)).build());

        private LazySharedExecutor() {
        }

        static {
            executor.setRemoveOnCancelPolicy(true);
        }
    }
}

