/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.EVCacheOperationImpl;
import net.spy.memcached.protocol.ascii.MetaDebugOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDebugOperationImpl
extends EVCacheOperationImpl
implements MetaDebugOperation {
    private static final Logger log = LoggerFactory.getLogger(MetaDebugOperationImpl.class);
    private static final OperationStatus END = new OperationStatus(true, "EN", StatusCode.SUCCESS);
    private static final int OVERHEAD = 32;
    private final MetaDebugOperation.Callback cb;
    private final String key;

    public MetaDebugOperationImpl(String k, MetaDebugOperation.Callback cb) {
        super(cb);
        this.key = k;
        this.cb = cb;
    }

    @Override
    public void handleLine(String line) {
        if (log.isDebugEnabled()) {
            log.debug("meta debug of {} returned {}", (Object)this.key, (Object)line);
        }
        if (line.equals("EN")) {
            this.getCallback().receivedStatus(END);
            this.transitionState(OperationState.COMPLETE);
        } else {
            String[] kvPairs;
            String[] parts = line.split(" ", 3);
            if (log.isDebugEnabled()) {
                log.debug("Num of parts " + parts.length);
            }
            if (parts.length <= 2) {
                return;
            }
            for (String kv : kvPairs = parts[2].split(" ")) {
                if (log.isDebugEnabled()) {
                    log.debug("kv " + kv);
                }
                String[] tuple = kv.split("=", 2);
                if (log.isDebugEnabled()) {
                    log.debug("{} = {}", (Object)tuple[0], (Object)tuple[1]);
                }
                this.cb.debugInfo(tuple[0], tuple[1]);
            }
        }
        this.getCallback().receivedStatus(this.matchStatus(line, new OperationStatus[]{END}));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = ByteBuffer.allocate(KeyUtil.getKeyBytes((String)this.key).length + 32);
        this.setArguments(b, new Object[]{"me", this.key});
        b.flip();
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: me Key: " + this.key;
    }
}

