/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import com.netflix.evcache.EVCache;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Tag;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.EVCacheNode;
import net.spy.memcached.EVCacheNodeMBean;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.protocol.ProxyCallback;
import net.spy.memcached.protocol.TCPMemcachedNodeImpl;
import net.spy.memcached.protocol.ascii.GetOperationImpl;
import net.spy.memcached.protocol.ascii.OptimizedGetImpl;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheAsciiNodeImpl
extends TCPMemcachedNodeImpl
implements EVCacheNodeMBean,
EVCacheNode {
    private static final Logger log = LoggerFactory.getLogger(EVCacheAsciiNodeImpl.class);
    protected long stTime;
    protected final String hostName;
    protected final BlockingQueue<Operation> readQ;
    protected final BlockingQueue<Operation> inputQueue;
    protected final EVCacheClient client;
    private final AtomicInteger numOps = new AtomicInteger(0);
    private long timeoutStartTime;
    protected final Counter operationsCounter;

    public EVCacheAsciiNodeImpl(SocketAddress sa, SocketChannel c, int bufSize, BlockingQueue<Operation> rq, BlockingQueue<Operation> wq, BlockingQueue<Operation> iq, long opQueueMaxBlockTimeMillis, boolean waitForAuth, long dt, long at, ConnectionFactory fa, EVCacheClient client, long stTime) {
        super(sa, c, bufSize, rq, wq, iq, opQueueMaxBlockTimeMillis, false, dt, at, fa);
        this.client = client;
        String appName = client.getAppName();
        this.readQ = rq;
        this.inputQueue = iq;
        this.hostName = ((InetSocketAddress)this.getSocketAddress()).getHostName();
        this.operationsCounter = client.getOperationCounter();
        this.setConnectTime(stTime);
        this.setupMonitoring(appName);
    }

    protected void optimize() {
        if (this.writeQ.peek() instanceof GetOperation) {
            this.optimizedOp = (Operation)this.writeQ.remove();
            if (this.writeQ.peek() instanceof GetOperation) {
                OptimizedGetImpl og = new OptimizedGetImpl((GetOperation)this.optimizedOp);
                this.optimizedOp = og;
                while (this.writeQ.peek() instanceof GetOperation) {
                    GetOperationImpl o = (GetOperationImpl)this.writeQ.remove();
                    if (o.isCancelled()) continue;
                    og.addOperation((GetOperation)o);
                }
                this.optimizedOp.initialize();
                assert (this.optimizedOp.getState() == OperationState.WRITE_QUEUED);
                ProxyCallback pcb = (ProxyCallback)og.getCallback();
                this.getLogger().debug("Set up %s with %s keys and %s callbacks", new Object[]{this, pcb.numKeys(), pcb.numCallbacks()});
            }
        }
    }

    private String getMonitorName(String appName) {
        return "com.netflix.evcache:Group=" + appName + ",SubGroup=pool,SubSubGroup=" + this.client.getServerGroupName() + ",SubSubSubGroup=" + this.client.getId() + ",SubSubSubSubGroup=" + this.hostName + "_" + this.stTime;
    }

    private void setupMonitoring(String appName) {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance(this.getMonitorName(appName));
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception while setting up the monitoring.", (Throwable)e);
            }
        }
    }

    @Override
    public void registerMonitors() {
    }

    @Override
    public boolean isAvailable(EVCache.Call call) {
        return this.isActive();
    }

    @Override
    public int getWriteQueueSize() {
        return this.writeQ.size();
    }

    @Override
    public int getReadQueueSize() {
        return this.readQ.size();
    }

    @Override
    public int getInputQueueSize() {
        return this.inputQueue.size();
    }

    @Override
    public long incrOps() {
        this.operationsCounter.increment();
        return this.numOps.incrementAndGet();
    }

    @Override
    public long getNumOfOps() {
        return this.numOps.get();
    }

    @Override
    public void flushInputQueue() {
        this.inputQueue.clear();
    }

    @Override
    public long getStartTime() {
        return this.stTime;
    }

    @Override
    public long getTimeoutStartTime() {
        return this.timeoutStartTime;
    }

    @Override
    public void removeMonitoring() {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance(this.getMonitorName(this.client.getAppName()));
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception while setting up the monitoring.", (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        this.removeMonitoring();
        this.writeQ.clear();
        this.readQ.clear();
        this.inputQueue.clear();
    }

    @Override
    public long getCreateTime() {
        return this.stTime;
    }

    @Override
    public void setConnectTime(long cTime) {
        this.stTime = cTime;
    }

    @Override
    public String getAppName() {
        return this.client.getAppName();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public ServerGroup getServerGroup() {
        return this.client.getServerGroup();
    }

    @Override
    public int getId() {
        return this.client.getId();
    }

    @Override
    public List<Tag> getTags() {
        return this.client.getTagList();
    }

    @Override
    public int getTotalReconnectCount() {
        return this.getReconnectCount();
    }

    @Override
    public String getSocketChannelLocalAddress() {
        try {
            if (this.getChannel() != null) {
                return this.getChannel().getLocalAddress().toString();
            }
        }
        catch (IOException e) {
            log.error("Exception", (Throwable)e);
        }
        return "NULL";
    }

    @Override
    public String getSocketChannelRemoteAddress() {
        try {
            if (this.getChannel() != null) {
                return this.getChannel().getRemoteAddress().toString();
            }
        }
        catch (IOException e) {
            log.error("Exception", (Throwable)e);
        }
        return "NULL";
    }

    @Override
    public String getConnectTime() {
        return ISODateTimeFormat.dateTime().print(this.stTime);
    }
}

