/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheInMemoryCache;
import com.netflix.evcache.connection.ConnectionFactoryBuilder;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheExecutor;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheScheduledExecutor;
import com.netflix.evcache.pool.SimpleNodeListProvider;
import com.netflix.evcache.util.EVCacheConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "DM_CONVERT_CASE", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public class EVCacheClientPoolManager {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientPoolManager.class);
    private static volatile EVCacheClientPoolManager instance;
    private final Property<Integer> defaultReadTimeout;
    private final Property<String> logEnabledApps;
    private final Property<Integer> defaultRefreshInterval;
    private final Map<String, EVCacheClientPool> poolMap = new ConcurrentHashMap<String, EVCacheClientPool>();
    private final Map<EVCacheClientPool, ScheduledFuture<?>> scheduledTaskMap = new HashMap();
    private final EVCacheScheduledExecutor asyncExecutor;
    private final EVCacheExecutor syncExecutor;
    private final List<EVCacheEventListener> evcacheEventListenerList;
    private final IConnectionBuilder connectionFactoryProvider;
    private final EVCacheNodeList evcacheNodeList;
    private final EVCacheConfig evcConfig;
    private ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
    private final Map<String, EVCacheInMemoryCache<?>> inMemoryMap = new ConcurrentHashMap();

    @Inject
    public EVCacheClientPoolManager(IConnectionBuilder connectionFactoryprovider, EVCacheNodeList evcacheNodeList, EVCacheConfig evcConfig) {
        instance = this;
        this.connectionFactoryProvider = connectionFactoryprovider;
        this.evcacheNodeList = evcacheNodeList;
        this.evcConfig = evcConfig;
        this.evcacheEventListenerList = new CopyOnWriteArrayList<EVCacheEventListener>();
        String clientCurrentInstanceId = null;
        if (clientCurrentInstanceId == null) {
            clientCurrentInstanceId = System.getenv("EC2_INSTANCE_ID");
        }
        if (clientCurrentInstanceId == null) {
            clientCurrentInstanceId = System.getenv("NETFLIX_INSTANCE_ID");
        }
        if (log.isInfoEnabled()) {
            log.info("\nClient Current InstanceId from env = " + clientCurrentInstanceId);
        }
        if (clientCurrentInstanceId == null && EVCacheConfig.getInstance().getPropertyRepository() != null) {
            clientCurrentInstanceId = (String)EVCacheConfig.getInstance().getPropertyRepository().get("EC2_INSTANCE_ID", String.class).orElse(null).get();
        }
        if (clientCurrentInstanceId == null && EVCacheConfig.getInstance().getPropertyRepository() != null) {
            clientCurrentInstanceId = (String)EVCacheConfig.getInstance().getPropertyRepository().get("NETFLIX_INSTANCE_ID", String.class).orElse(null).get();
        }
        if (clientCurrentInstanceId != null && !clientCurrentInstanceId.equalsIgnoreCase("localhost")) {
            this.defaultReadTimeout = EVCacheConfig.getInstance().getPropertyRepository().get("default.read.timeout", Integer.class).orElse((Object)20);
            if (log.isInfoEnabled()) {
                log.info("\nClient Current InstanceId = " + clientCurrentInstanceId + " which is probably a cloud location. The default.read.timeout = " + this.defaultReadTimeout);
            }
        } else {
            this.defaultReadTimeout = EVCacheConfig.getInstance().getPropertyRepository().get("default.read.timeout", Integer.class).orElse((Object)750);
            if (log.isInfoEnabled()) {
                log.info("\n\nClient Current InstanceId = " + clientCurrentInstanceId + ". Probably a non-cloud instance. The default.read.timeout = " + this.defaultReadTimeout + "\n\n");
            }
        }
        this.logEnabledApps = EVCacheConfig.getInstance().getPropertyRepository().get("EVCacheClientPoolManager.log.apps", String.class).orElse((Object)"*");
        this.defaultRefreshInterval = EVCacheConfig.getInstance().getPropertyRepository().get("EVCacheClientPoolManager.refresh.interval", Integer.class).orElse((Object)60);
        this.asyncExecutor = new EVCacheScheduledExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, new ThreadPoolExecutor.CallerRunsPolicy(), "scheduled");
        this.asyncExecutor.prestartAllCoreThreads();
        this.syncExecutor = new EVCacheExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, new ThreadPoolExecutor.CallerRunsPolicy(), "pool");
        this.syncExecutor.prestartAllCoreThreads();
        this.initAtStartup();
    }

    public IConnectionBuilder getConnectionFactoryProvider() {
        return this.connectionFactoryProvider;
    }

    public void addEVCacheEventListener(EVCacheEventListener listener) {
        this.evcacheEventListenerList.add(listener);
    }

    public void addEVCacheEventListener(EVCacheEventListener listener, int index) {
        if (index < this.evcacheEventListenerList.size()) {
            this.evcacheEventListenerList.add(index, listener);
        } else {
            this.evcacheEventListenerList.add(listener);
        }
    }

    public void removeEVCacheEventListener(EVCacheEventListener listener) {
        this.evcacheEventListenerList.remove(listener);
    }

    public List<EVCacheEventListener> getEVCacheEventListeners() {
        return this.evcacheEventListenerList;
    }

    public EVCacheConfig getEVCacheConfig() {
        return this.evcConfig;
    }

    @Deprecated
    public static EVCacheClientPoolManager getInstance() {
        if (instance == null) {
            new EVCacheClientPoolManager(new ConnectionFactoryBuilder(), new SimpleNodeListProvider(), EVCacheConfig.getInstance());
            if (!((Boolean)EVCacheConfig.getInstance().getPropertyRepository().get("evcache.use.simple.node.list.provider", Boolean.class).orElse((Object)false).get()).booleanValue() && log.isDebugEnabled()) {
                log.debug("Please make sure EVCacheClientPoolManager is injected first. This is not the appropriate way to init EVCacheClientPoolManager. If you are using simple node list provider please set evcache.use.simple.node.list.provider property to true.", (Throwable)new Exception());
            }
        }
        return instance;
    }

    public void initAtStartup() {
        String appsToInit = (String)EVCacheConfig.getInstance().getPropertyRepository().get("evcache.appsToInit", String.class).orElse((Object)"").get();
        if (appsToInit != null && appsToInit.length() > 0) {
            StringTokenizer apps = new StringTokenizer(appsToInit, ",");
            while (apps.hasMoreTokens()) {
                String app = this.getAppName(apps.nextToken());
                if (log.isDebugEnabled()) {
                    log.debug("Initializing EVCache - " + app);
                }
                this.initEVCache(app);
            }
        }
    }

    public final synchronized EVCacheClientPool initEVCache(String app) {
        return this.initEVCache(app, false);
    }

    public final synchronized EVCacheClientPool initEVCache(String app, boolean isDuet) {
        if (app == null || (app = app.trim()).length() == 0) {
            throw new IllegalArgumentException("param app name null or space");
        }
        String APP = this.getAppName(app);
        if (this.poolMap.containsKey(APP)) {
            return this.poolMap.get(APP);
        }
        EVCacheClientPool pool = new EVCacheClientPool(APP, this.evcacheNodeList, this.asyncExecutor, this, isDuet);
        this.scheduleRefresh(pool);
        this.poolMap.put(APP, pool);
        return pool;
    }

    private void scheduleRefresh(EVCacheClientPool pool) {
        ScheduledFuture<?> task = this.asyncExecutor.scheduleWithFixedDelay(pool, 30L, ((Integer)this.defaultRefreshInterval.get()).intValue(), TimeUnit.SECONDS);
        this.scheduledTaskMap.put(pool, task);
    }

    public EVCacheClientPool getEVCacheClientPool(String _app) {
        String app = this.getAppName(_app);
        EVCacheClientPool evcacheClientPool = this.poolMap.get(app);
        if (evcacheClientPool != null) {
            return evcacheClientPool;
        }
        this.initEVCache(app);
        return this.poolMap.get(app);
    }

    public Map<String, EVCacheClientPool> getAllEVCacheClientPool() {
        return new HashMap<String, EVCacheClientPool>(this.poolMap);
    }

    @PreDestroy
    public void shutdown() {
        this.asyncExecutor.shutdown();
        this.syncExecutor.shutdown();
        for (EVCacheClientPool pool : this.poolMap.values()) {
            pool.shutdown();
        }
    }

    public boolean shouldLog(String appName) {
        if ("*".equals(this.logEnabledApps.get())) {
            return true;
        }
        return ((String)this.logEnabledApps.get()).indexOf(appName) != -1;
    }

    public Property<Integer> getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    public Property<Integer> getDefaultRefreshInterval() {
        return this.defaultRefreshInterval;
    }

    public EVCacheScheduledExecutor getEVCacheScheduledExecutor() {
        return this.asyncExecutor;
    }

    public EVCacheExecutor getEVCacheExecutor() {
        return this.syncExecutor;
    }

    private String getAppName(String _app) {
        _app = _app.toUpperCase();
        String app = ((String)EVCacheConfig.getInstance().getPropertyRepository().get("EVCacheClientPoolManager." + _app + ".alias", String.class).orElse((Object)_app).get()).toUpperCase();
        if (log.isDebugEnabled()) {
            log.debug("Original App Name : " + _app + "; Alias App Name : " + app);
        }
        if (app != null && app.length() > 0) {
            return app.toUpperCase();
        }
        return _app;
    }

    public <T> EVCacheInMemoryCache<T> createInMemoryCache(Transcoder<T> tc, EVCacheImpl impl) {
        String name = impl.getCachePrefix() == null ? impl.getAppName() : impl.getAppName() + impl.getCachePrefix();
        EVCacheInMemoryCache<Object> cache = this.inMemoryMap.get(name);
        if (cache == null) {
            this.writeLock.lock();
            cache = this.getInMemoryCache(name);
            if (cache == null) {
                cache = new EVCacheInMemoryCache<T>(impl.getAppName(), tc, impl);
                this.inMemoryMap.put(name, cache);
            }
            this.writeLock.unlock();
        }
        return cache;
    }

    public <T> EVCacheInMemoryCache<T> getInMemoryCache(String appName) {
        return this.inMemoryMap.get(appName);
    }
}

