/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.connection.BaseAsciiConnectionFactory;
import com.netflix.evcache.connection.BaseConnectionFactory;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import net.spy.memcached.ConnectionFactory;

public class ConnectionFactoryBuilder
implements IConnectionBuilder {
    @Override
    public ConnectionFactory getConnectionFactory(EVCacheClient client) {
        String appName = client.getAppName();
        int maxQueueSize = (Integer)EVCacheConfig.getInstance().getPropertyRepository().get(appName + ".max.queue.length", Integer.class).orElse((Object)16384).get();
        Property operationTimeout = EVCacheConfig.getInstance().getPropertyRepository().get(appName + ".operation.timeout", Integer.class).orElse((Object)2500);
        int opQueueMaxBlockTime = (Integer)EVCacheConfig.getInstance().getPropertyRepository().get(appName + ".operation.QueueMaxBlockTime", Integer.class).orElse((Object)10).get();
        boolean useBinary = (Boolean)EVCacheConfig.getInstance().getPropertyRepository().get("evcache.use.binary.protocol", Boolean.class).orElse((Object)true).get();
        if (useBinary) {
            return new BaseConnectionFactory(client, maxQueueSize, (Property<Integer>)operationTimeout, opQueueMaxBlockTime);
        }
        return new BaseAsciiConnectionFactory(client, maxQueueSize, (Property<Integer>)operationTimeout, opQueueMaxBlockTime);
    }
}

