/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.util.KeyHasher;
import java.util.HashMap;
import java.util.Map;

public class EVCacheKey {
    private final String appName;
    private final KeyHasher.HashingAlgorithm hashingAlgorithmAtAppLevel;
    private final Property<Boolean> shouldEncodeHashKeyAtAppLevel;
    private final Property<Integer> maxHashingBytesAtAppLevel;
    private final String key;
    private final String canonicalKey;
    private String canonicalKeyForDuet;
    private final Map<KeyHasher.HashingAlgorithm, String> hashedKeysByAlgorithm;
    private final Map<KeyHasher.HashingAlgorithm, String> hashedKeysByAlgorithmForDuet;

    public EVCacheKey(String appName, String key, String canonicalKey, KeyHasher.HashingAlgorithm hashingAlgorithmAtAppLevel, Property<Boolean> shouldEncodeHashKeyAtAppLevel, Property<Integer> maxHashingBytesAtAppLevel) {
        this.appName = appName;
        this.key = key;
        this.canonicalKey = canonicalKey;
        this.hashingAlgorithmAtAppLevel = hashingAlgorithmAtAppLevel;
        this.shouldEncodeHashKeyAtAppLevel = shouldEncodeHashKeyAtAppLevel;
        this.maxHashingBytesAtAppLevel = maxHashingBytesAtAppLevel;
        this.hashedKeysByAlgorithm = new HashMap<KeyHasher.HashingAlgorithm, String>();
        this.hashedKeysByAlgorithmForDuet = new HashMap<KeyHasher.HashingAlgorithm, String>();
    }

    public String getKey() {
        return this.key;
    }

    @Deprecated
    public String getCanonicalKey() {
        return this.canonicalKey;
    }

    public String getCanonicalKey(boolean isDuet) {
        return isDuet ? this.getCanonicalKeyForDuet() : this.canonicalKey;
    }

    private String getCanonicalKeyForDuet() {
        if (null == this.canonicalKeyForDuet) {
            int duetKeyLength = this.appName.length() + 1 + this.canonicalKey.length();
            this.canonicalKeyForDuet = new StringBuilder(duetKeyLength).append(this.appName).append(':').append(this.canonicalKey).toString();
        }
        return this.canonicalKeyForDuet;
    }

    @Deprecated
    public String getHashKey() {
        return this.getHashKey(this.hashingAlgorithmAtAppLevel, null == this.shouldEncodeHashKeyAtAppLevel ? null : (Boolean)this.shouldEncodeHashKeyAtAppLevel.get(), null == this.maxHashingBytesAtAppLevel ? null : (Integer)this.maxHashingBytesAtAppLevel.get());
    }

    public String getHashKey(boolean isDuet, KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxHashingBytes) {
        if (null == hashingAlgorithm) {
            hashingAlgorithm = this.hashingAlgorithmAtAppLevel;
        }
        if (null == shouldEncodeHashKey) {
            shouldEncodeHashKey = (Boolean)this.shouldEncodeHashKeyAtAppLevel.get();
        }
        if (null == maxHashingBytes) {
            maxHashingBytes = (Integer)this.maxHashingBytesAtAppLevel.get();
        }
        return isDuet ? this.getHashKeyForDuet(hashingAlgorithm, shouldEncodeHashKey, maxHashingBytes) : this.getHashKey(hashingAlgorithm, shouldEncodeHashKey, maxHashingBytes);
    }

    public String getDerivedKey(boolean isDuet, KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxHashingBytes) {
        if (null == hashingAlgorithm) {
            hashingAlgorithm = this.hashingAlgorithmAtAppLevel;
        }
        return null == hashingAlgorithm ? this.getCanonicalKey(isDuet) : this.getHashKey(isDuet, hashingAlgorithm, shouldEncodeHashKey, maxHashingBytes);
    }

    private String getHashKey(KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxHashingBytes) {
        if (null == hashingAlgorithm) {
            return null;
        }
        return this.hashedKeysByAlgorithm.computeIfAbsent(hashingAlgorithm, ha -> KeyHasher.getHashedKeyEncoded(this.canonicalKey, ha, maxHashingBytes));
    }

    private String getHashKeyForDuet(KeyHasher.HashingAlgorithm hashingAlgorithm, Boolean shouldEncodeHashKey, Integer maxHashingBytes) {
        if (null == hashingAlgorithm) {
            return null;
        }
        return this.hashedKeysByAlgorithmForDuet.computeIfAbsent(hashingAlgorithm, ha -> KeyHasher.getHashedKeyEncoded(this.getCanonicalKeyForDuet(), ha, maxHashingBytes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalKey == null ? 0 : this.canonicalKey.hashCode());
        result = 31 * result + (this.canonicalKeyForDuet == null ? 0 : this.canonicalKeyForDuet.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EVCacheKey other = (EVCacheKey)obj;
        if (this.canonicalKey == null ? other.canonicalKey != null : !this.canonicalKey.equals(other.canonicalKey)) {
            return false;
        }
        if (this.canonicalKeyForDuet == null ? other.canonicalKeyForDuet != null : !this.canonicalKeyForDuet.equals(other.canonicalKeyForDuet)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return "EVCacheKey [key=" + this.key + ", canonicalKey=" + this.canonicalKey + ", canonicalKeyForDuet=" + this.canonicalKeyForDuet + (this.hashedKeysByAlgorithm.size() > 0 ? ", hashedKeysByAlgorithm=" + this.hashedKeysByAlgorithm.toString() : "") + (this.hashedKeysByAlgorithmForDuet.size() > 0 ? ", hashedKeysByAlgorithmForDuet=" + this.hashedKeysByAlgorithmForDuet.toString() + "]" : "]");
    }
}

