/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.evcache.EVCacheKey;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.pool.ChunkTranscoder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheValue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheClientUtil {
    private static Logger log = LoggerFactory.getLogger(EVCacheClientUtil.class);
    private final ChunkTranscoder ct = new ChunkTranscoder();
    private final String _appName;
    private final EVCacheClientPool _pool;

    public EVCacheClientUtil(EVCacheClientPool pool) {
        this._pool = pool;
        this._appName = pool.getAppName();
    }

    public EVCacheLatch add(EVCacheKey evcKey, CachedData cd, boolean shouldHashKey, Transcoder evcacheValueTranscoder, int timeToLive, EVCacheLatch.Policy policy) throws Exception {
        if (cd == null) {
            return null;
        }
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        Boolean firstStatus = null;
        for (EVCacheClient client : clients) {
            boolean status;
            String key = evcKey.getDerivedKey(client.isDuetClient());
            if (shouldHashKey) {
                EVCacheValue val = new EVCacheValue(evcKey.getCanonicalKey(client.isDuetClient()), cd.getData(), cd.getFlags(), timeToLive, System.currentTimeMillis());
                cd = evcacheValueTranscoder.encode((Object)val);
            }
            Future<Boolean> f = client.add(key, timeToLive, cd, latch);
            if (log.isDebugEnabled()) {
                log.debug("ADD : Op Submitted : APP " + this._appName + ", key " + key + "; future : " + f + "; client : " + client);
            }
            if (!(status = f.get().booleanValue())) {
                if (firstStatus == null) {
                    for (int i = 0; i < clients.length; ++i) {
                        latch.countDown();
                    }
                    return latch;
                }
                return this.fixup(client, clients, evcKey, timeToLive, policy);
            }
            if (firstStatus != null) continue;
            firstStatus = status;
        }
        return latch;
    }

    private EVCacheLatch fixup(EVCacheClient sourceClient, EVCacheClient[] destClients, EVCacheKey evcKey, int timeToLive, EVCacheLatch.Policy policy) {
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, destClients.length, this._appName);
        try {
            CachedData readData = sourceClient.get(evcKey.getDerivedKey(sourceClient.isDuetClient()), this.ct, false, false);
            if (readData != null) {
                sourceClient.touch(evcKey.getDerivedKey(sourceClient.isDuetClient()), timeToLive);
                for (EVCacheClient destClient : destClients) {
                    destClient.set(evcKey.getDerivedKey(destClient.isDuetClient()), readData, timeToLive, (EVCacheLatch)latch);
                }
            }
            latch.await(((Integer)this._pool.getOperationTimeout().get()).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("Error reading the data", (Throwable)e);
        }
        return latch;
    }
}

