/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyHasher {
    private static final Logger log = LoggerFactory.getLogger(KeyHasher.class);
    private static final Base64.Encoder encoder = Base64.getEncoder().withoutPadding();

    public static String getHashedKey(String key, String hashingAlgorithm) {
        long start = System.nanoTime();
        HashFunction hf = null;
        switch (hashingAlgorithm.toLowerCase()) {
            case "murmur3": {
                hf = Hashing.murmur3_128();
                break;
            }
            case "adler32": {
                hf = Hashing.adler32();
                break;
            }
            case "crc32": {
                hf = Hashing.crc32();
                break;
            }
            case "sha1": {
                hf = Hashing.sha1();
                break;
            }
            case "sha256": {
                hf = Hashing.sha256();
                break;
            }
            case "siphash24": {
                hf = Hashing.sipHash24();
                break;
            }
            case "goodfasthash": {
                hf = Hashing.goodFastHash((int)128);
                break;
            }
            default: {
                hf = Hashing.md5();
            }
        }
        HashCode hc = hf.newHasher().putString((CharSequence)key, Charsets.UTF_8).hash();
        byte[] digest = hc.asBytes();
        if (log.isDebugEnabled()) {
            log.debug("Key : " + key + "; digest length : " + digest.length + "; byte Array contents : " + Arrays.toString(digest));
        }
        String hKey = encoder.encodeToString(digest);
        if (log.isDebugEnabled()) {
            log.debug("Key : " + key + "; Hashed & encoded key : " + hKey + "; Took " + (System.nanoTime() - start) + " nanos");
        }
        return hKey;
    }
}

