/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import com.netflix.evcache.pool.ServerGroup;
import java.util.Iterator;
import java.util.Set;

public class ServerGroupCircularIterator {
    private Entry<ServerGroup> entry;
    private int size = 0;

    public ServerGroupCircularIterator(Set<ServerGroup> allReplicaSets) {
        if (allReplicaSets == null || allReplicaSets.isEmpty()) {
            return;
        }
        Entry<ServerGroup> pEntry = null;
        Iterator<ServerGroup> itr = allReplicaSets.iterator();
        while (itr.hasNext()) {
            ++this.size;
            ServerGroup rSet = itr.next();
            Entry<ServerGroup> newEntry = new Entry<ServerGroup>(rSet, pEntry);
            if (this.entry == null) {
                this.entry = newEntry;
            }
            pEntry = newEntry;
        }
        if (pEntry != null) {
            ((Entry)this.entry).next = (Entry)pEntry;
        }
    }

    public ServerGroup next() {
        if (this.entry == null) {
            return null;
        }
        this.entry = ((Entry)this.entry).next;
        return (ServerGroup)((Entry)this.entry).element;
    }

    public ServerGroup next(ServerGroup ignoreReplicaSet) {
        if (this.entry == null) {
            return null;
        }
        this.entry = ((Entry)this.entry).next;
        if (((ServerGroup)((Entry)this.entry).element).equals(ignoreReplicaSet)) {
            return (ServerGroup)((Entry)this.entry).next.element;
        }
        return (ServerGroup)((Entry)this.entry).element;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder current = new StringBuilder();
        if (this.entry != null) {
            Entry<ServerGroup> startEntry = this.entry;
            current.append(((Entry)startEntry).element);
            while (!((Entry)this.entry).next.equals(startEntry)) {
                current.append(",").append(((Entry)this.entry).next.element);
                this.entry = ((Entry)this.entry).next;
            }
        }
        return "Server Group Iterator : { size=" + this.getSize() + "; Server Group=" + current.toString() + "}";
    }

    static class Entry<E> {
        private E element;
        private Entry<E> next;

        Entry(E element, Entry<E> next) {
            this.element = element;
            this.next = next;
        }
    }
}

