/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.EVCacheTranscoder;
import com.netflix.evcache.operation.EVCacheAsciiOperationFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.EVCacheKetamaNodeLocatorConfiguration;
import com.netflix.evcache.pool.EVCacheNodeLocator;
import com.netflix.evcache.util.EVCacheConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.EVCacheConnection;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.protocol.ascii.EVCacheAsciiNodeImpl;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;

public class BaseAsciiConnectionFactory
extends DefaultConnectionFactory {
    protected final String name;
    protected final String appName;
    protected final Property<Integer> operationTimeout;
    protected final long opMaxBlockTime;
    protected EVCacheNodeLocator locator;
    protected final long startTime;
    protected final EVCacheClient client;
    protected final Property<String> failureMode;

    BaseAsciiConnectionFactory(EVCacheClient client, int len, Property<Integer> _operationTimeout, long opMaxBlockTime) {
        super(len, 16384, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH);
        this.opMaxBlockTime = opMaxBlockTime;
        this.operationTimeout = _operationTimeout;
        this.client = client;
        this.startTime = System.currentTimeMillis();
        this.appName = client.getAppName();
        this.failureMode = client.getPool().getEVCacheClientPoolManager().getEVCacheConfig().getPropertyRepository().get(this.client.getServerGroupName() + ".failure.mode", String.class).orElseGet(this.appName + ".failure.mode").orElse((Object)"Retry");
        this.name = this.appName + "-" + client.getServerGroupName() + "-" + client.getId();
    }

    public NodeLocator createLocator(List<MemcachedNode> list) {
        this.locator = new EVCacheNodeLocator(this.client, list, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH, (KetamaNodeLocatorConfiguration)new EVCacheKetamaNodeLocatorConfiguration(this.client));
        return this.locator;
    }

    public EVCacheNodeLocator getEVCacheNodeLocator() {
        return this.locator;
    }

    public long getMaxReconnectDelay() {
        return super.getMaxReconnectDelay();
    }

    public int getOpQueueLen() {
        return super.getOpQueueLen();
    }

    public int getReadBufSize() {
        return super.getReadBufSize();
    }

    public BlockingQueue<Operation> createOperationQueue() {
        return new ArrayBlockingQueue<Operation>(this.getOpQueueLen());
    }

    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        return new EVCacheConnection(this.name, this.getReadBufSize(), (ConnectionFactory)this, addrs, this.getInitialObservers(), this.getFailureMode(), (OperationFactory)this.getOperationFactory());
    }

    public EVCacheAsciiOperationFactory getOperationFactory() {
        return new EVCacheAsciiOperationFactory();
    }

    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        boolean doAuth = false;
        EVCacheAsciiNodeImpl node = new EVCacheAsciiNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), this.opMaxBlockTime, doAuth, this.getOperationTimeout(), this.getAuthWaitTime(), (ConnectionFactory)this, this.client, this.startTime);
        node.registerMonitors();
        return node;
    }

    public long getOperationTimeout() {
        return ((Integer)this.operationTimeout.get()).intValue();
    }

    public BlockingQueue<Operation> createReadOperationQueue() {
        return super.createReadOperationQueue();
    }

    public BlockingQueue<Operation> createWriteOperationQueue() {
        return super.createWriteOperationQueue();
    }

    public Transcoder<Object> getDefaultTranscoder() {
        return new EVCacheTranscoder();
    }

    public FailureMode getFailureMode() {
        try {
            return FailureMode.valueOf((String)((String)this.failureMode.get()));
        }
        catch (IllegalArgumentException ex) {
            return FailureMode.Cancel;
        }
    }

    public HashAlgorithm getHashAlg() {
        return super.getHashAlg();
    }

    public Collection<ConnectionObserver> getInitialObservers() {
        return super.getInitialObservers();
    }

    public boolean isDaemon() {
        return (Boolean)EVCacheConfig.getInstance().getPropertyRepository().get("evcache.thread.daemon", Boolean.class).orElse((Object)super.isDaemon()).get();
    }

    public boolean shouldOptimize() {
        return true;
    }

    public boolean isDefaultExecutorService() {
        return false;
    }

    public ExecutorService getListenerExecutorService() {
        return this.client.getPool().getEVCacheClientPoolManager().getEVCacheExecutor();
    }

    public int getId() {
        return this.client.getId();
    }

    public String getZone() {
        return this.client.getServerGroup().getZone();
    }

    public String getServerGroupName() {
        return this.client.getServerGroup().getName();
    }

    public String getReplicaSetName() {
        return this.client.getServerGroup().getName();
    }

    public String getAppName() {
        return this.appName;
    }

    public String toString() {
        return this.name;
    }

    public EVCacheClientPoolManager getEVCacheClientPoolManager() {
        return this.client.getPool().getEVCacheClientPoolManager();
    }

    public EVCacheClientPool getEVCacheClientPool() {
        return this.client.getPool();
    }

    public EVCacheClient getEVCacheClient() {
        return this.client;
    }
}

