/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

public class EVCacheKey {
    private final String key;
    private final String canonicalKey;
    private final String canonicalKeyForDuet;
    private final String hashKey;
    private final String hashKeyForDuet;

    public EVCacheKey(String key, String canonicalKey, String canonicalKeyForDuet, String hashKey, String hashKeyForDuet) {
        this.key = key;
        this.canonicalKey = canonicalKey;
        this.canonicalKeyForDuet = canonicalKeyForDuet;
        this.hashKey = hashKey;
        this.hashKeyForDuet = hashKeyForDuet;
    }

    public String getKey() {
        return this.key;
    }

    @Deprecated
    public String getCanonicalKey() {
        return this.canonicalKey;
    }

    public String getCanonicalKey(boolean isDuet) {
        return isDuet ? this.canonicalKeyForDuet : this.canonicalKey;
    }

    @Deprecated
    public String getHashKey() {
        return this.hashKey;
    }

    public String getHashKey(boolean isDuet) {
        return isDuet ? this.hashKeyForDuet : this.hashKey;
    }

    public String getDerivedKey(boolean isDuet) {
        if (isDuet) {
            return null == this.hashKeyForDuet ? this.canonicalKeyForDuet : this.hashKeyForDuet;
        }
        return null == this.hashKey ? this.canonicalKey : this.hashKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalKey == null ? 0 : this.canonicalKey.hashCode());
        result = 31 * result + (this.canonicalKeyForDuet == null ? 0 : this.canonicalKeyForDuet.hashCode());
        result = 31 * result + (this.hashKey == null ? 0 : this.hashKey.hashCode());
        result = 31 * result + (this.hashKeyForDuet == null ? 0 : this.hashKeyForDuet.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EVCacheKey other = (EVCacheKey)obj;
        if (this.canonicalKey == null ? other.canonicalKey != null : !this.canonicalKey.equals(other.canonicalKey)) {
            return false;
        }
        if (this.canonicalKeyForDuet == null ? other.canonicalKeyForDuet != null : !this.canonicalKeyForDuet.equals(other.canonicalKeyForDuet)) {
            return false;
        }
        if (this.hashKey == null ? other.hashKey != null : !this.hashKey.equals(other.hashKey)) {
            return false;
        }
        if (this.hashKeyForDuet == null ? other.hashKeyForDuet != null : !this.hashKeyForDuet.equals(other.hashKeyForDuet)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return "EVCacheKey [key=" + this.key + ", canonicalKey=" + this.canonicalKey + ", canonicalKeyForDuet=" + this.canonicalKeyForDuet + (this.hashKey != null ? ", hashKey=" + this.hashKey : "") + (this.hashKeyForDuet != null ? ", hashKeyForDuet=" + this.hashKeyForDuet + "]" : "]");
    }
}

