/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SystemConfig;
import javax.inject.Inject;

public class EVCacheConfig {
    private static EVCacheConfig INSTANCE;
    private static PropertyRepository propertyRepository;

    @Inject
    public EVCacheConfig(PropertyRepository repository) {
        String userLocation;
        if (repository == null) {
            try {
                DefaultCompositeConfig applicationConfig = new DefaultCompositeConfig();
                applicationConfig.addConfig("SYSTEM", (Config)SystemConfig.INSTANCE);
                applicationConfig.addConfig("ENVIRONMENT", (Config)EnvironmentConfig.INSTANCE);
                propertyRepository = new DefaultPropertyFactory((Config)applicationConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                propertyRepository = new DefaultPropertyFactory((Config)new DefaultCompositeConfig());
            }
        } else {
            propertyRepository = repository;
        }
        if ((userLocation = null) == null) {
            userLocation = System.getenv("EC2_INSTANCE_ID");
        }
        if (userLocation == null) {
            userLocation = System.getenv("NETFLIX_INSTANCE_ID");
        }
        if (userLocation == null) {
            userLocation = System.getProperty("EC2_INSTANCE_ID");
        }
        if (userLocation == null) {
            userLocation = System.getProperty("NETFLIX_INSTANCE_ID");
        }
        if (userLocation == null && propertyRepository != null) {
            userLocation = (String)propertyRepository.get("EC2_INSTANCE_ID", String.class).orElse(null).get();
        }
        if (userLocation == null && propertyRepository != null) {
            userLocation = (String)propertyRepository.get("NETFLIX_INSTANCE_ID", String.class).orElse(null).get();
        }
        if (userLocation == null) {
            System.setProperty("default.read.timeout", "750");
            System.setProperty("default.bulk.timeout", "750");
        }
        INSTANCE = this;
    }

    private EVCacheConfig() {
        this(null);
    }

    public static EVCacheConfig getInstance() {
        if (INSTANCE == null) {
            new EVCacheConfig();
        }
        return INSTANCE;
    }

    public PropertyRepository getPropertyRepository() {
        return propertyRepository;
    }

    public static void setPropertyRepository(PropertyRepository repository) {
        propertyRepository = repository;
    }
}

