/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheInMemoryCache;
import com.netflix.evcache.connection.ConnectionFactoryBuilder;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheExecutor;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheScheduledExecutor;
import com.netflix.evcache.pool.SimpleNodeListProvider;
import com.netflix.evcache.util.EVCacheConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "DM_CONVERT_CASE", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public class EVCacheClientPoolManager {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientPoolManager.class);
    private static final DynamicIntProperty defaultReadTimeout = EVCacheConfig.getInstance().getDynamicIntProperty("default.read.timeout", 20);
    private static final DynamicStringProperty logEnabledApps = EVCacheConfig.getInstance().getDynamicStringProperty("EVCacheClientPoolManager.log.apps", "*");
    private final DynamicIntProperty defaultRefreshInterval = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheClientPoolManager.refresh.interval", 60);
    private static volatile EVCacheClientPoolManager instance;
    private final Map<String, EVCacheClientPool> poolMap = new ConcurrentHashMap<String, EVCacheClientPool>();
    private final Map<EVCacheClientPool, ScheduledFuture<?>> scheduledTaskMap = new HashMap();
    private final EVCacheScheduledExecutor asyncExecutor;
    private final EVCacheExecutor syncExecutor;
    private final List<EVCacheEventListener> evcacheEventListenerList;
    private final IConnectionBuilder connectionFactoryProvider;
    private final EVCacheNodeList evcacheNodeList;
    private ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
    private final Map<String, EVCacheInMemoryCache<?>> inMemoryMap = new ConcurrentHashMap();

    @Inject
    public EVCacheClientPoolManager(IConnectionBuilder connectionFactoryprovider, EVCacheNodeList evcacheNodeList) {
        instance = this;
        this.connectionFactoryProvider = connectionFactoryprovider;
        this.evcacheNodeList = evcacheNodeList;
        this.evcacheEventListenerList = new CopyOnWriteArrayList<EVCacheEventListener>();
        this.asyncExecutor = new EVCacheScheduledExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, new ThreadPoolExecutor.CallerRunsPolicy(), "scheduled");
        this.asyncExecutor.prestartAllCoreThreads();
        this.syncExecutor = new EVCacheExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, new ThreadPoolExecutor.CallerRunsPolicy(), "pool");
        this.syncExecutor.prestartAllCoreThreads();
        this.initAtStartup();
    }

    public IConnectionBuilder getConnectionFactoryProvider() {
        return this.connectionFactoryProvider;
    }

    public void addEVCacheEventListener(EVCacheEventListener listener) {
        this.evcacheEventListenerList.add(listener);
    }

    public void addEVCacheEventListener(EVCacheEventListener listener, int index) {
        if (index < this.evcacheEventListenerList.size()) {
            this.evcacheEventListenerList.add(index, listener);
        } else {
            this.evcacheEventListenerList.add(listener);
        }
    }

    public void removeEVCacheEventListener(EVCacheEventListener listener) {
        this.evcacheEventListenerList.remove(listener);
    }

    public List<EVCacheEventListener> getEVCacheEventListeners() {
        return this.evcacheEventListenerList;
    }

    @Deprecated
    public static EVCacheClientPoolManager getInstance() {
        if (instance == null) {
            try {
                ConfigurationManager.loadCascadedPropertiesFromResources((String)"evcache");
            }
            catch (IOException e) {
                log.info("Default evcache configuration not loaded", (Throwable)e);
            }
            new EVCacheClientPoolManager(new ConnectionFactoryBuilder(), new SimpleNodeListProvider());
            if (!EVCacheConfig.getInstance().getDynamicBooleanProperty("evcache.use.simple.node.list.provider", false).get() && log.isDebugEnabled()) {
                log.debug("Please make sure EVCacheClientPoolManager is injected first. This is not the appropriate way to init EVCacheClientPoolManager. If you are using simple node list provider please set evcache.use.simple.node.list.provider property to true.", (Throwable)new Exception());
            }
        }
        return instance;
    }

    public void initAtStartup() {
        String appsToInit = EVCacheConfig.getInstance().getDynamicStringProperty("evcache.appsToInit", "").get();
        if (appsToInit != null && appsToInit.length() > 0) {
            StringTokenizer apps = new StringTokenizer(appsToInit, ",");
            while (apps.hasMoreTokens()) {
                String app = this.getAppName(apps.nextToken());
                if (log.isDebugEnabled()) {
                    log.debug("Initializing EVCache - " + app);
                }
                this.initEVCache(app);
            }
        }
    }

    public final synchronized void initEVCache(String app) {
        if (app == null || (app = app.trim()).length() == 0) {
            throw new IllegalArgumentException("param app name null or space");
        }
        String APP = this.getAppName(app);
        if (this.poolMap.containsKey(APP)) {
            return;
        }
        EVCacheClientPool pool = new EVCacheClientPool(APP, this.evcacheNodeList, this.asyncExecutor, this);
        this.scheduleRefresh(pool);
        this.poolMap.put(APP, pool);
    }

    private void scheduleRefresh(EVCacheClientPool pool) {
        ScheduledFuture<?> task = this.asyncExecutor.scheduleWithFixedDelay(pool, 30L, this.defaultRefreshInterval.get(), TimeUnit.SECONDS);
        this.scheduledTaskMap.put(pool, task);
    }

    public EVCacheClientPool getEVCacheClientPool(String _app) {
        String app = this.getAppName(_app);
        EVCacheClientPool evcacheClientPool = this.poolMap.get(app);
        if (evcacheClientPool != null) {
            return evcacheClientPool;
        }
        this.initEVCache(app);
        return this.poolMap.get(app);
    }

    public Map<String, EVCacheClientPool> getAllEVCacheClientPool() {
        return new HashMap<String, EVCacheClientPool>(this.poolMap);
    }

    @PreDestroy
    public void shutdown() {
        this.asyncExecutor.shutdown();
        this.syncExecutor.shutdown();
        for (EVCacheClientPool pool : this.poolMap.values()) {
            pool.shutdown();
        }
    }

    public boolean shouldLog(String appName) {
        if ("*".equals(logEnabledApps.get())) {
            return true;
        }
        return logEnabledApps.get().indexOf(appName) != -1;
    }

    public static DynamicIntProperty getDefaultReadTimeout() {
        return defaultReadTimeout;
    }

    public DynamicIntProperty getDefaultRefreshInterval() {
        return this.defaultRefreshInterval;
    }

    public EVCacheScheduledExecutor getEVCacheScheduledExecutor() {
        return this.asyncExecutor;
    }

    public EVCacheExecutor getEVCacheExecutor() {
        return this.syncExecutor;
    }

    private String getAppName(String _app) {
        _app = _app.toUpperCase();
        String app = EVCacheConfig.getInstance().getDynamicStringProperty("EVCacheClientPoolManager." + _app + ".alias", _app).get();
        if (log.isDebugEnabled()) {
            log.debug("Original App Name : " + _app + "; Alias App Name : " + app);
        }
        if (app != null && app.length() > 0) {
            return app.toUpperCase();
        }
        return _app;
    }

    public <T> EVCacheInMemoryCache<T> createInMemoryCache(String appName, Transcoder<T> tc, EVCacheImpl impl) {
        EVCacheInMemoryCache<Object> cache = this.inMemoryMap.get(appName);
        if (cache == null) {
            this.writeLock.lock();
            cache = this.getInMemoryCache(appName);
            if (cache == null) {
                cache = new EVCacheInMemoryCache<T>(appName, tc, impl);
                this.inMemoryMap.put(appName, cache);
            }
            this.writeLock.unlock();
        }
        return cache;
    }

    public <T> EVCacheInMemoryCache<T> getInMemoryCache(String appName) {
        return this.inMemoryMap.get(appName);
    }
}

