/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.metrics;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileTimer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@SuppressFBWarnings(value={"NF_LOCAL_FAST_PROPERTY", "PMB_POSSIBLE_MEMORY_BLOAT"}, justification="Creates only when needed")
public final class EVCacheMetricsFactory {
    private final Map<String, Number> monitorMap = new ConcurrentHashMap<String, Number>();
    private final Map<String, Counter> counterMap = new ConcurrentHashMap<String, Counter>();
    private final Map<String, DistributionSummary> distributionSummaryMap = new ConcurrentHashMap<String, DistributionSummary>();
    private final Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private final Map<String, Timer> timerMap = new HashMap<String, Timer>();
    private static final EVCacheMetricsFactory INSTANCE = new EVCacheMetricsFactory();
    public static final String CALL = "evcache.client.call";
    public static final String FAST_FAIL = "evcache.client.fastfail";
    public static final String CONFIG = "evcache.client.config";
    public static final String DATA_SIZE = "evcache.client.datasize";
    public static final String MISC = "evcache.client.misc";
    public static final String IN_MEMORY = "evcache.client.inmemorycache";
    public static final String INTERNAL_CONFIG = "internal.evcache.client.config";
    public static final String INTERNAL_OPERATION = "internal.evcache.client.operation";
    public static final String INTERNAL_NODE_OPERATION = "internal.evcache.client.node.operations";
    public static final String INTERNAL_PAUSE = "internal.evcache.client.pause";
    public static final String INTERNAL_LATCH_CALLBACK = "internal.evcache.client.latch.callback";
    public static final String INTERNAL_LATCH_VERIFY = "internal.evcache.client.latch.verify";
    public static final String INTERNAL_READ_Q_FULL = "internal.evcache.client.call.readQueueFull";
    public static final String INTERNAL_INACTIVE_NODE = "internal.evcache.client.call.inactiveNode";
    public static final String INTERNAL_DATA_SIZE = "internal.evcache.client.dataSize";
    public static final String INTERNAL_INCORRECT_CHUNKS = "internal.evcache.client.chunking.incorrectNumOfChunks";
    public static final String INTERNAL_INVALID_CHUNK_SIZE = "internal.evcache.client.chunking.invalidChunkSize";
    public static final String INTERNAL_CHECK_SUM_ERROR = "internal.evcache.client.chunking.checkSumError";
    public static final String INTERNAL_NUM_CHUNK_SIZE = "internal.evcache.client.chunking.numOfChunks";
    public static final String INTERNAL_CHUNK_DATA_SIZE = "internal.evcache.client.chunking.dataSize";
    public static final String INTERNAL_POOL_REFRESH = "internal.evcache.client.pool.refresh";
    public static final String INTERNAL_POOL_SIZE = "internal.evcache.client.pool.size";
    public static final String INTERNAL_POOL_ACTIVE = "internal.evcache.client.pool.activeConnections";
    public static final String INTERNAL_POOL_INACTIVE = "internal.evcache.client.pool.inActiveConnections";
    public static final String INTERNAL_POOL_IN_DISCOVERY = "internal.evcache.client.pool.inDiscovery";
    public static final String INTERNAL_POOL_IN_HASHING = "internal.evcache.client.pool.inHashing";
    public static final String INTERNAL_POOL_READ_INSTANCES = "internal.evcache.client.pool.readInstances";
    public static final String INTERNAL_POOL_WRITE_INSTANCES = "internal.evcache.client.pool.writeInstances";
    public static final String INTERNAL_POOL_RECONCILE = "internal.evcache.client.pool.reconcile";
    public static final String INTERNAL_POOL_CHANGED = "internal.evcache.client.pool.serverGroupChanged";
    public static final String INTERNAL_POOL_SERVERGROUP_STATUS = "internal.evcache.client.pool.serverGroup.status";
    public static final String INTERNAL_POOL_INIT_ERROR = "internal.evcache.client.pool.init.error";
    public static final String INTERNAL_POOL_READ_Q_SIZE = "internal.evcache.client.pool.readQueue";
    public static final String INTERNAL_POOL_WRITE_Q_SIZE = "internal.evcache.client.pool.writeQueue";
    public static final String INTERNAL_POOL_REFRESH_ON_QUEUE_FULL = "internal.evcache.client.pool.refresh.on.queue.full";
    public static final String INTERNAL_POOL_REFRESH_ASYNC = "internal.evcache.client.pool.refresh.async";
    public static final String INTERNAL_ADD_CALL_FIXUP = "internal.evcache.client.addCall.fixUp";
    public static final String CACHE = "cache";
    public static final String CAUSE = "cause";
    public static final String SERVERGROUP = "serverGroup";
    public static final String FAIL_COUNT = "failCount";
    public static final String COMPLETE_COUNT = "completeCount";
    public static final String RECONNECT_COUNT = "reconnectCount";
    public static final String STATUS = "status";
    public static final String PAUSE_REASON = "pauseReason";
    public static final String FETCH_AFTER_PAUSE = "fetchAfterPause";
    public static final String FAILED_SERVERGROUP = "failedServerGroup";
    public static final String CONFIG_NAME = "configName";
    public static final String HOST = "host";
    public static final String CACHE_HIT = "cacheHit";
    public static final String OPERATION = "operation";
    public static final String OPERATION_TYPE = "operationType";
    public static final String NUMBER_OF_ATTEMPTS = "numberOfAttempts";
    public static final String PORT = "port";
    public static final String CONNECT = "connect";
    public static final String DISCONNECT = "disconnect";
    public static final String SUCCESS = "success";
    public static final String TIMEOUT = "timeout";
    public static final String CANCELLED = "cancelled";
    public static final String THROTTLED = "throttled";
    public static final String ERROR = "error";
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String PARTIAL = "partial";
    public static final String UNKNOWN = "unknown";
    public static final String GC = "gc";
    public static final String NULL_CLIENT = "nullClient";
    public static final String NULL_ZONE = "nullZone";
    public static final String NULL_SERVERGROUP = "nullServerGroup";

    private EVCacheMetricsFactory() {
    }

    public static EVCacheMetricsFactory getInstance() {
        return INSTANCE;
    }

    public Map<String, Counter> getAllCounters() {
        return this.counterMap;
    }

    public Map<String, Timer> getAllTimers() {
        return this.timerMap;
    }

    public Map<String, Number> getAllMonitor() {
        return this.monitorMap;
    }

    public Map<String, DistributionSummary> getAllDistributionSummaryMap() {
        return this.distributionSummaryMap;
    }

    public Registry getRegistry() {
        return Spectator.globalRegistry();
    }

    public AtomicLong getLongGauge(String name) {
        return this.getLongGauge(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicLong getLongGauge(String cName, Collection<Tag> tags) {
        String name = tags != null ? cName + tags.toString() : cName;
        AtomicLong gauge = (AtomicLong)this.monitorMap.get(name);
        if (gauge == null) {
            this.writeLock.lock();
            try {
                if (this.monitorMap.containsKey(name)) {
                    gauge = (AtomicLong)this.monitorMap.get(name);
                } else {
                    gauge = tags != null ? (AtomicLong)this.getRegistry().gauge(cName, tags, (Number)new AtomicLong()) : (AtomicLong)this.getRegistry().gauge(cName, (Number)new AtomicLong());
                    this.monitorMap.put(name, gauge);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return gauge;
    }

    public Id getId(String name, List<Tag> tags) {
        tags.add((Tag)new BasicTag("owner", "evcache"));
        return this.getRegistry().createId(name, tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter getCounter(String cName, List<Tag> tags) {
        String name = tags != null ? cName + tags.toString() : cName;
        Counter counter = this.counterMap.get(name);
        if (counter == null) {
            this.writeLock.lock();
            try {
                if (this.counterMap.containsKey(name)) {
                    counter = this.counterMap.get(name);
                } else {
                    if (tags == null) {
                        tags = new ArrayList<Tag>(1);
                    }
                    tags.add((Tag)new BasicTag("owner", "evcache"));
                    counter = this.getRegistry().counter(cName, tags);
                    this.counterMap.put(name, counter);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return counter;
    }

    public Counter getCounter(String name) {
        return this.getCounter(name, null);
    }

    public void increment(String name) {
        Counter counter = this.getCounter(name);
        counter.increment();
    }

    public void increment(String cName, List<Tag> tags) {
        Counter counter = this.getCounter(cName, tags);
        counter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getPercentileTimer(String metric, Collection<Tag> tags) {
        String name = tags != null ? metric + tags.toString() : metric;
        Timer duration = this.timerMap.get(name);
        if (duration != null) {
            return duration;
        }
        this.writeLock.lock();
        try {
            if (this.timerMap.containsKey(name)) {
                Timer timer = this.timerMap.get(name);
                return timer;
            }
            Id id = this.getRegistry().createId(metric);
            if (tags != null) {
                id = id.withTags(tags);
            }
            PercentileTimer _duration = PercentileTimer.get((Registry)this.getRegistry(), (Id)id);
            this.timerMap.put(name, (Timer)_duration);
            PercentileTimer percentileTimer = _duration;
            return percentileTimer;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public DistributionSummary getDistributionSummary(String name, Collection<Tag> tags) {
        String metricName = tags != null ? name + tags.toString() : name;
        DistributionSummary _ds = this.distributionSummaryMap.get(metricName);
        if (_ds != null) {
            return _ds;
        }
        CompositeRegistry registry = Spectator.globalRegistry();
        if (registry != null) {
            Id id = registry.createId(name);
            if (tags != null) {
                id = id.withTags(tags);
            }
            DistributionSummary ds = registry.distributionSummary(id);
            this.distributionSummaryMap.put(metricName, ds);
            return ds;
        }
        return null;
    }
}

