/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPoolMBean;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.pool.observer.EVCacheConnectionObserver;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.evcache.util.ServerGroupCircularIterator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.protocol.binary.EVCacheNodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "REC_CATCH_EXCEPTION", "MDM_THREAD_YIELD"})
public class EVCacheClientPool
implements Runnable,
EVCacheClientPoolMBean {
    private static Logger log = LoggerFactory.getLogger(EVCacheClientPool.class);
    private final String _appName;
    private final String _zone;
    private final EVCacheClientPoolManager manager;
    private ServerGroupCircularIterator localServerGroupIterator = null;
    private final DynamicIntProperty _poolSize;
    private final ChainedDynamicProperty.IntProperty _readTimeout;
    private final ChainedDynamicProperty.IntProperty _bulkReadTimeout;
    public static final String DEFAULT_PORT = "11211";
    private final DynamicBooleanProperty _retryAcrossAllReplicas;
    private long lastReconcileTime = 0L;
    private final DynamicIntProperty logOperations;
    private final DynamicStringSetProperty logOperationCalls;
    private final DynamicStringSetProperty cloneWrite;
    private final DynamicIntProperty _opQueueMaxBlockTime;
    private final DynamicIntProperty _operationTimeout;
    private final DynamicIntProperty _maxReadQueueSize;
    private final DynamicIntProperty reconcileInterval;
    private final DynamicIntProperty _maxRetries;
    private final ChainedDynamicProperty.BooleanProperty _pingServers;
    private final ChainedDynamicProperty.BooleanProperty refreshConnectionOnReadQueueFull;
    private final ChainedDynamicProperty.IntProperty refreshConnectionOnReadQueueFullSize;
    private final ThreadPoolExecutor asyncRefreshExecutor;
    private final DynamicBooleanProperty _disableAsyncRefresh;
    private final Map<ServerGroup, ChainedDynamicProperty.BooleanProperty> writeOnlyFastPropertyMap = new ConcurrentHashMap<ServerGroup, ChainedDynamicProperty.BooleanProperty>(){

        @Override
        public ChainedDynamicProperty.BooleanProperty get(Object _serverGroup) {
            ServerGroup serverGroup = (ServerGroup)ServerGroup.class.cast(_serverGroup);
            ChainedDynamicProperty.BooleanProperty isServerGroupInWriteOnlyMode = (ChainedDynamicProperty.BooleanProperty)super.get(serverGroup);
            if (isServerGroupInWriteOnlyMode != null) {
                return isServerGroupInWriteOnlyMode;
            }
            isServerGroupInWriteOnlyMode = EVCacheConfig.getInstance().getChainedBooleanProperty(EVCacheClientPool.this._appName + "." + serverGroup.getName() + ".EVCacheClientPool.writeOnly", EVCacheClientPool.this._appName + "." + serverGroup.getZone() + ".EVCacheClientPool.writeOnly", Boolean.FALSE, null);
            this.put(serverGroup, isServerGroupInWriteOnlyMode);
            return isServerGroupInWriteOnlyMode;
        }
    };
    private final AtomicLong numberOfModOps = new AtomicLong(0L);
    private boolean _shutdown = false;
    private Map<ServerGroup, List<EVCacheClient>> memcachedInstancesByServerGroup = new ConcurrentHashMap<ServerGroup, List<EVCacheClient>>();
    private Map<ServerGroup, List<EVCacheClient>> memcachedReadInstancesByServerGroup = new ConcurrentHashMap<ServerGroup, List<EVCacheClient>>();
    private Map<ServerGroup, List<EVCacheClient>> memcachedWriteInstancesByServerGroup = Collections.synchronizedSortedMap(new TreeMap());
    private final Map<InetSocketAddress, Long> evCacheDiscoveryConnectionLostSet = new ConcurrentHashMap<InetSocketAddress, Long>();
    private Map<String, ServerGroupCircularIterator> readServerGroupByZone = new ConcurrentHashMap<String, ServerGroupCircularIterator>();
    private ServerGroupCircularIterator memcachedFallbackReadInstances = new ServerGroupCircularIterator(Collections.emptySet());
    private final EVCacheNodeList provider;

    EVCacheClientPool(String appName, EVCacheNodeList provider, ThreadPoolExecutor asyncRefreshExecutor, EVCacheClientPoolManager manager) {
        this._appName = appName;
        this.provider = provider;
        this.asyncRefreshExecutor = asyncRefreshExecutor;
        this.manager = manager;
        String ec2Zone = System.getenv("EC2_AVAILABILITY_ZONE");
        if (ec2Zone == null) {
            ec2Zone = System.getProperty("EC2_AVAILABILITY_ZONE");
        }
        this._zone = ec2Zone == null ? "GLOBAL" : ec2Zone;
        EVCacheConfig config = EVCacheConfig.getInstance();
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                EVCacheClientPool.this.clearState();
                EVCacheClientPool.this.refreshPool(true, true);
            }
        };
        this._poolSize = config.getDynamicIntProperty(appName + ".EVCacheClientPool.poolSize", 1);
        this._poolSize.addCallback(callback);
        this._readTimeout = new ChainedDynamicProperty.IntProperty(appName + ".EVCacheClientPool.readTimeout", EVCacheClientPoolManager.getDefaultReadTimeout());
        this._readTimeout.addCallback(callback);
        this._bulkReadTimeout = new ChainedDynamicProperty.IntProperty(appName + ".EVCacheClientPool.bulkReadTimeout", this._readTimeout);
        this._bulkReadTimeout.addCallback(callback);
        this.refreshConnectionOnReadQueueFull = config.getChainedBooleanProperty(appName + ".EVCacheClientPool.refresh.connection.on.readQueueFull", "EVCacheClientPool.refresh.connection.on.readQueueFull", Boolean.FALSE, null);
        this.refreshConnectionOnReadQueueFullSize = config.getChainedIntProperty(appName + ".EVCacheClientPool.refresh.connection.on.readQueueFull.size", "EVCacheClientPool.refresh.connection.on.readQueueFull.size", 100, null);
        this._opQueueMaxBlockTime = config.getDynamicIntProperty(appName + ".operation.QueueMaxBlockTime", 10);
        this._opQueueMaxBlockTime.addCallback(callback);
        this._operationTimeout = config.getDynamicIntProperty(appName + ".operation.timeout", 2500);
        this._operationTimeout.addCallback(callback);
        this._maxReadQueueSize = config.getDynamicIntProperty(appName + ".max.read.queue.length", 5);
        this._retryAcrossAllReplicas = config.getDynamicBooleanProperty(this._appName + ".retry.all.copies", Boolean.FALSE);
        this._disableAsyncRefresh = config.getDynamicBooleanProperty(this._appName + ".disable.async.refresh", Boolean.FALSE);
        this._maxRetries = config.getDynamicIntProperty(this._appName + ".max.retry.count", 1);
        this.logOperations = config.getDynamicIntProperty(appName + ".log.operation", 0);
        this.logOperationCalls = new DynamicStringSetProperty(appName + ".log.operation.calls", "SET,DELETE,GMISS,TMISS,BMISS_ALL,TOUCH,REPLACE");
        this.reconcileInterval = config.getDynamicIntProperty(appName + ".reconcile.interval", 600000);
        this.cloneWrite = new DynamicStringSetProperty(appName + ".clone.writes.to", "");
        this.cloneWrite.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheClientPool.this.setupClones();
            }
        });
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("APP", this._appName);
        this._pingServers = config.getChainedBooleanProperty(appName + ".ping.servers", "evcache.ping.servers", Boolean.FALSE, null);
        this.setupMonitoring();
        this.refreshPool(false, true);
        if (log.isInfoEnabled()) {
            log.info(this.toString());
        }
    }

    private void setupClones() {
        for (String cloneApp : this.cloneWrite.get()) {
            this.manager.initEVCache(cloneApp);
        }
    }

    private void clearState() {
        this.cleanupMemcachedInstances(true);
        this.memcachedInstancesByServerGroup.clear();
        this.memcachedReadInstancesByServerGroup.clear();
        this.memcachedWriteInstancesByServerGroup.clear();
        this.readServerGroupByZone.clear();
        this.memcachedFallbackReadInstances = new ServerGroupCircularIterator(Collections.emptySet());
    }

    public EVCacheClient getEVCacheClientForRead() {
        if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("memcachedReadInstancesByServerGroup : " + this.memcachedReadInstancesByServerGroup);
            }
            if (this.asyncRefreshExecutor.getQueue().isEmpty()) {
                this.refreshPool(true, true);
            }
            return null;
        }
        try {
            List<EVCacheClient> clients = null;
            if (this.localServerGroupIterator != null) {
                clients = this.memcachedReadInstancesByServerGroup.get(this.localServerGroupIterator.next());
            }
            if (clients == null) {
                ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next();
                if (fallbackServerGroup == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("fallbackServerGroup is null.");
                    }
                    return null;
                }
                clients = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
            }
            return this.selectClient(clients);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone " + this._zone, t);
            return null;
        }
    }

    private EVCacheClient selectClient(List<EVCacheClient> clients) {
        if (clients == null) {
            if (log.isDebugEnabled()) {
                log.debug("clients is null returning null!!!");
            }
            return null;
        }
        if (clients.size() == 1) {
            return clients.get(0);
        }
        long currentVal = this.numberOfModOps.incrementAndGet();
        int index = Math.abs((int)(currentVal % (long)clients.size()));
        return clients.get(index);
    }

    public EVCacheClient getEVCacheClientForReadExclude(ServerGroup rsetUsed) {
        if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
            return null;
        }
        try {
            ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next(rsetUsed);
            if (fallbackServerGroup == null || fallbackServerGroup.equals(rsetUsed)) {
                return null;
            }
            List<EVCacheClient> clients = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
            return this.selectClient(clients);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone " + rsetUsed, t);
            return null;
        }
    }

    public EVCacheClient getEVCacheClient(ServerGroup serverGroup) {
        if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
            return null;
        }
        try {
            List<EVCacheClient> clients = this.memcachedReadInstancesByServerGroup.get(serverGroup);
            if (clients == null) {
                ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next();
                if (fallbackServerGroup == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("fallbackServerGroup is null.");
                    }
                    return null;
                }
                clients = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
            }
            return this.selectClient(clients);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for ServerGroup " + serverGroup, t);
            return null;
        }
    }

    public List<EVCacheClient> getEVCacheClientsForReadExcluding(ServerGroup serverGroupToExclude) {
        block9: {
            if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
                return Collections.emptyList();
            }
            try {
                if (this._retryAcrossAllReplicas.get()) {
                    ArrayList<EVCacheClient> clients = new ArrayList<EVCacheClient>(this.memcachedReadInstancesByServerGroup.size() - 1);
                    for (ServerGroup serverGroup : this.memcachedReadInstancesByServerGroup.keySet()) {
                        List<EVCacheClient> clientList;
                        EVCacheClient client;
                        if (serverGroup.equals(serverGroupToExclude) || (client = this.selectClient(clientList = this.memcachedReadInstancesByServerGroup.get(serverGroup))) == null) continue;
                        clients.add(client);
                    }
                    return clients;
                }
                if (this._maxRetries.get() == 1) {
                    EVCacheClient client = this.getEVCacheClientForReadExclude(serverGroupToExclude);
                    if (client != null) {
                        return Collections.singletonList(client);
                    }
                    break block9;
                }
                ArrayList<EVCacheClient> clients = new ArrayList<EVCacheClient>(this._maxRetries.get());
                for (int i = 0; i < this._maxRetries.get(); ++i) {
                    ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next(serverGroupToExclude);
                    if (fallbackServerGroup == null) {
                        return clients;
                    }
                    List<EVCacheClient> clientList = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
                    EVCacheClient client = this.selectClient(clientList);
                    if (client == null) continue;
                    clients.add(client);
                }
                return clients;
            }
            catch (Throwable t) {
                log.error("Exception trying to get an readable EVCache Instances for zone " + serverGroupToExclude, t);
            }
        }
        return Collections.emptyList();
    }

    public boolean isInWriteOnly(ServerGroup serverGroup) {
        if (this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) {
            return false;
        }
        return this.memcachedWriteInstancesByServerGroup.containsKey(serverGroup);
    }

    public EVCacheClient[] getWriteOnlyEVCacheClients() {
        try {
            int size = this.memcachedWriteInstancesByServerGroup.size() - this.memcachedReadInstancesByServerGroup.size();
            if (size == 0) {
                return new EVCacheClient[0];
            }
            EVCacheClient[] clientArr = new EVCacheClient[size];
            for (ServerGroup serverGroup : this.memcachedWriteInstancesByServerGroup.keySet()) {
                if (this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) continue;
                List<EVCacheClient> clients = this.memcachedWriteInstancesByServerGroup.get(serverGroup);
                if (clients.size() == 1) {
                    clientArr[--size] = clients.get(0);
                    continue;
                }
                long currentVal = this.numberOfModOps.incrementAndGet();
                int index = (int)(currentVal % (long)clients.size());
                clientArr[--size] = index < 0 ? clients.get(0) : clients.get(index);
            }
            return clientArr;
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return new EVCacheClient[0];
        }
    }

    EVCacheClient[] getAllWriteClients() {
        try {
            EVCacheClient[] clientArr = new EVCacheClient[this.memcachedWriteInstancesByServerGroup.size()];
            int i = 0;
            for (ServerGroup serverGroup : this.memcachedWriteInstancesByServerGroup.keySet()) {
                List<EVCacheClient> clients = this.memcachedWriteInstancesByServerGroup.get(serverGroup);
                if (clients.size() == 1) {
                    clientArr[i++] = clients.get(0);
                    continue;
                }
                long currentVal = this.numberOfModOps.incrementAndGet();
                int index = (int)(currentVal % (long)clients.size());
                clientArr[i++] = index < 0 ? clients.get(0) : clients.get(index);
            }
            return clientArr;
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return new EVCacheClient[0];
        }
    }

    public EVCacheClient[] getEVCacheClientForWrite() {
        try {
            if (this.cloneWrite.get().size() == 0) {
                return this.getAllWriteClients();
            }
            ArrayList<EVCacheClient> evcacheClientList = new ArrayList<EVCacheClient>();
            EVCacheClient[] clientArr = this.getAllWriteClients();
            for (EVCacheClient client : clientArr) {
                evcacheClientList.add(client);
            }
            for (String cloneApp : this.cloneWrite.get()) {
                EVCacheClient[] cloneWriteArray = this.manager.getEVCacheClientPool(cloneApp).getAllWriteClients();
                for (int j = 0; j < cloneWriteArray.length; ++j) {
                    evcacheClientList.add(cloneWriteArray[j]);
                }
            }
            return evcacheClientList.toArray(new EVCacheClient[0]);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return new EVCacheClient[0];
        }
    }

    private void refresh() throws IOException {
        this.refresh(false);
    }

    protected boolean haveInstancesInServerGroupChanged(ServerGroup serverGroup, Set<InetSocketAddress> discoveredHostsInServerGroup) {
        List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.get(serverGroup);
        if (clients == null) {
            return true;
        }
        for (int i = 0; i < clients.size(); ++i) {
            boolean hashingSizeDiff;
            int size = clients.size();
            EVCacheClient client = clients.get(i);
            EVCacheConnectionObserver connectionObserver = client.getConnectionObserver();
            int activeServerCount = connectionObserver.getActiveServerCount();
            int inActiveServerCount = connectionObserver.getInActiveServerCount();
            int sizeInDiscovery = discoveredHostsInServerGroup.size();
            int sizeInHashing = client.getNodeLocator().getAll().size();
            List<Tag> tags = client.getTagList();
            if (i == 0) {
                List<EVCacheClient> writeClients;
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-PoolSize", tags).set(size);
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-ActiveConnections", tags).set(activeServerCount * size);
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-InactiveConnections", tags).set(inActiveServerCount * size);
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-InDiscovery", tags).set(sizeInDiscovery);
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-InHashing", tags).set(sizeInHashing);
                List<EVCacheClient> readClients = this.memcachedReadInstancesByServerGroup.get(serverGroup);
                if (readClients != null && readClients.size() > 0) {
                    EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-ReadInstanceCount", tags).set(readClients.get(0).getConnectionObserver().getActiveServerCount());
                }
                if ((writeClients = this.memcachedWriteInstancesByServerGroup.get(serverGroup)) != null && writeClients.size() > 0) {
                    EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-WriteInstanceCount", tags).set(writeClients.get(0).getConnectionObserver().getActiveServerCount());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tActive Count : " + activeServerCount + "\n\tInactive Count : " + inActiveServerCount + "\n\tDiscovery Count : " + sizeInDiscovery + "\n\tsizeInHashing : " + sizeInHashing);
            }
            long currentTime = System.currentTimeMillis();
            boolean reconcile = false;
            if (currentTime - this.lastReconcileTime > (long)this.reconcileInterval.get()) {
                reconcile = true;
                this.lastReconcileTime = currentTime;
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-Reconcile", tags).set(1L);
            } else {
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-Reconcile", tags).set(0L);
            }
            boolean bl = hashingSizeDiff = sizeInHashing != sizeInDiscovery && sizeInHashing != activeServerCount;
            if (reconcile || activeServerCount != sizeInDiscovery || inActiveServerCount > 0 || hashingSizeDiff) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\t" + this._appName + " & " + serverGroup + " experienced an issue.\n\tActive Server Count : " + activeServerCount);
                }
                if (log.isDebugEnabled()) {
                    log.debug("\n\tInActive Server Count : " + inActiveServerCount + "\n\tDiscovered Instances : " + sizeInDiscovery);
                }
                for (InetSocketAddress inetSocketAddress : discoveredHostsInServerGroup) {
                    if (connectionObserver.getActiveServers().containsKey(inetSocketAddress) || connectionObserver.getInActiveServers().containsKey(inetSocketAddress)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + inetSocketAddress + " not found and will shutdown the client and init it again.");
                    }
                    EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-haveInstancesInServerGroupChanged", tags).set(1L);
                    return true;
                }
                for (Map.Entry entry : connectionObserver.getInActiveServers().entrySet()) {
                    if (currentTime - (Long)entry.getValue() <= 1200000L || discoveredHostsInServerGroup.contains(entry.getKey())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + entry.getKey() + " not found in discovery and will shutdown the client and init it again.");
                    }
                    EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-haveInstancesInServerGroupChanged", tags).set(2L);
                    return true;
                }
                Collection allNodes = client.getNodeLocator().getAll();
                for (MemcachedNode node : allNodes) {
                    EVCacheNodeImpl evcNode;
                    if (!(node instanceof EVCacheNodeImpl) || (evcNode = (EVCacheNodeImpl)node).isActive() || discoveredHostsInServerGroup.contains(evcNode.getSocketAddress())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Node : " + node + " is not active. Will shutdown the client and init it again.");
                    }
                    EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-haveInstancesInServerGroupChanged", tags).set(3L);
                    return true;
                }
                if (hashingSizeDiff) {
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; PoolSize : " + size + "; ActiveConnections : " + activeServerCount + "; InactiveConnections : " + inActiveServerCount + "; InDiscovery : " + sizeInDiscovery + "; InHashing : " + sizeInHashing + "; hashingSizeDiff : " + hashingSizeDiff + ". Since there is a diff in hashing size will shutdown the client and init it again.");
                    }
                    EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-haveInstancesInServerGroupChanged", tags).set(4L);
                    return true;
                }
                for (InetSocketAddress instance : connectionObserver.getActiveServers().keySet()) {
                    if (discoveredHostsInServerGroup.contains(instance)) continue;
                    if (!this.evCacheDiscoveryConnectionLostSet.containsKey(instance)) {
                        this.evCacheDiscoveryConnectionLostSet.put(instance, currentTime);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + instance + " not found in discovery. We will add to our list and monitor it.");
                        continue;
                    }
                    long lostDur = currentTime - this.evCacheDiscoveryConnectionLostSet.get(instance);
                    if (lostDur >= 1200000L) {
                        if (log.isDebugEnabled()) {
                            log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + instance + " not found in discovery for the past 20 mins and will shutdown the client and init it again.");
                        }
                        EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-haveInstancesInServerGroupChanged", tags).set(5L);
                        this.evCacheDiscoveryConnectionLostSet.remove(instance);
                        return true;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + instance + " not found in discovery for " + lostDur + " msec.");
                }
                if (sizeInDiscovery == 0 && (activeServerCount == 0 || inActiveServerCount > activeServerCount)) {
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Will shutdown the client since there are no active servers and no servers for this ServerGroup in disocvery.");
                    }
                    EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-haveInstancesInServerGroupChanged", tags).set(9L);
                    return true;
                }
            }
            EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-haveInstancesInServerGroupChanged", tags).set(0L);
        }
        return false;
    }

    private List<InetSocketAddress> getMemcachedSocketAddressList(Set<InetSocketAddress> discoveredHostsInZone) {
        ArrayList<InetSocketAddress> memcachedNodesInZone = new ArrayList<InetSocketAddress>();
        for (InetSocketAddress hostAddress : discoveredHostsInZone) {
            memcachedNodesInZone.add(hostAddress);
        }
        return memcachedNodesInZone;
    }

    private void shutdownClientsInZone(List<EVCacheClient> clients) {
        if (clients == null || clients.isEmpty()) {
            return;
        }
        for (EVCacheClient oldClient : clients) {
            try {
                boolean obsRemoved = oldClient.removeConnectionObserver();
                if (log.isDebugEnabled()) {
                    log.debug("Connection observer removed " + obsRemoved);
                }
                boolean status = oldClient.shutdown(60L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down -> Client {" + oldClient.toString() + "}; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
    }

    private void setupNewClientsByServerGroup(ServerGroup serverGroup, List<EVCacheClient> newClients) {
        List<EVCacheClient> currentClients = this.memcachedInstancesByServerGroup.put(serverGroup, newClients);
        ChainedDynamicProperty.BooleanProperty isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(serverGroup);
        if (((Boolean)isZoneInWriteOnlyMode.get()).booleanValue()) {
            this.memcachedReadInstancesByServerGroup.remove(serverGroup);
        } else {
            this.memcachedReadInstancesByServerGroup.put(serverGroup, newClients);
        }
        this.memcachedWriteInstancesByServerGroup.put(serverGroup, newClients);
        if (currentClients == null || currentClients.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Replaced an existing Pool for ServerGroup : " + serverGroup + "; and app " + this._appName + " ;\n\tOldClients : " + currentClients + ";\n\tNewClients : " + newClients);
        }
        for (EVCacheClient client : currentClients) {
            if (client.isShutdown()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Shutting down in Fallback -> AppName : " + this._appName + "; ServerGroup : " + serverGroup + "; client {" + client + "};");
            }
            try {
                if (client.getConnectionObserver() != null) {
                    boolean obsRemoved = client.removeConnectionObserver();
                    if (log.isDebugEnabled()) {
                        log.debug("Connection observer removed " + obsRemoved);
                    }
                }
                boolean status = client.shutdown(5L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down {" + client + "} ; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
        this.shutdownClientsInZone(currentClients);
    }

    private void updateMemcachedReadInstancesByZone() {
        for (ServerGroup serverGroup : this.memcachedInstancesByServerGroup.keySet()) {
            EVCacheConnectionObserver connectionObserver;
            EVCacheClient client;
            List<EVCacheClient> clients;
            ChainedDynamicProperty.BooleanProperty isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(serverGroup);
            if (((Boolean)isZoneInWriteOnlyMode.get()).booleanValue()) {
                if (this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) {
                    EVCacheMetricsFactory.getInstance().increment(this._appName + "-" + serverGroup.getName() + "-WRITE_ONLY");
                    this.memcachedReadInstancesByServerGroup.remove(serverGroup);
                }
            } else if (!this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) {
                EVCacheMetricsFactory.getInstance().increment(this._appName + "-" + serverGroup.getName() + "-READ_ENABLED");
                this.memcachedReadInstancesByServerGroup.put(serverGroup, this.memcachedInstancesByServerGroup.get(serverGroup));
            }
            if ((clients = this.memcachedReadInstancesByServerGroup.get(serverGroup)) == null || clients.isEmpty() || (client = clients.get(0)) == null || (connectionObserver = client.getConnectionObserver()) == null) continue;
            int activeServerCount = connectionObserver.getActiveServerCount();
            int inActiveServerCount = connectionObserver.getInActiveServerCount();
            if (inActiveServerCount <= activeServerCount) continue;
            this.memcachedReadInstancesByServerGroup.remove(serverGroup);
        }
        if (this.memcachedReadInstancesByServerGroup.size() != this.memcachedFallbackReadInstances.getSize()) {
            this.memcachedFallbackReadInstances = new ServerGroupCircularIterator(this.memcachedReadInstancesByServerGroup.keySet());
            ConcurrentHashMap<String, HashSet<ServerGroup>> readServerGroupByZoneMap = new ConcurrentHashMap<String, HashSet<ServerGroup>>();
            for (ServerGroup serverGroup : this.memcachedReadInstancesByServerGroup.keySet()) {
                HashSet<ServerGroup> serverGroupList = (HashSet<ServerGroup>)readServerGroupByZoneMap.get(serverGroup.getZone());
                if (serverGroupList == null) {
                    serverGroupList = new HashSet<ServerGroup>();
                    readServerGroupByZoneMap.put(serverGroup.getZone(), serverGroupList);
                }
                serverGroupList.add(serverGroup);
            }
            ConcurrentHashMap<String, ServerGroupCircularIterator> concurrentHashMap = new ConcurrentHashMap<String, ServerGroupCircularIterator>();
            for (Map.Entry readServerGroupByZoneEntry : readServerGroupByZoneMap.entrySet()) {
                concurrentHashMap.put((String)readServerGroupByZoneEntry.getKey(), new ServerGroupCircularIterator((Set)readServerGroupByZoneEntry.getValue()));
            }
            this.readServerGroupByZone = concurrentHashMap;
            this.localServerGroupIterator = this.readServerGroupByZone.get(this._zone);
        }
    }

    private void cleanupMemcachedInstances(boolean force) {
        this.pingServers();
        Iterator<Map.Entry<ServerGroup, List<EVCacheClient>>> it = this.memcachedInstancesByServerGroup.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ServerGroup, List<EVCacheClient>> serverGroupEntry = it.next();
            List<EVCacheClient> instancesInAServerGroup = serverGroupEntry.getValue();
            boolean removeEntry = false;
            for (EVCacheClient client : instancesInAServerGroup) {
                EVCacheConnectionObserver connectionObserver = client.getConnectionObserver();
                if (connectionObserver.getActiveServerCount() != 0 || connectionObserver.getInActiveServerCount() <= 0) continue;
                removeEntry = true;
            }
            if (!force && !removeEntry) continue;
            ServerGroup serverGroup = serverGroupEntry.getKey();
            this.memcachedReadInstancesByServerGroup.remove(serverGroup);
            this.memcachedWriteInstancesByServerGroup.remove(serverGroup);
            for (EVCacheClient client : instancesInAServerGroup) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + " has no active servers. Cleaning up this ServerGroup.");
                }
                client.shutdown(0L, TimeUnit.SECONDS);
                client.getConnectionObserver().shutdown();
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refresh(boolean force) throws IOException {
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer("EVCacheClientPool-" + this._appName + "-refresh", null);
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("refresh APP : " + this._appName + "; force : " + force);
        }
        try {
            Map<ServerGroup, EVCacheServerGroupConfig> instances = this.provider.discoverInstances(this._appName);
            if (log.isDebugEnabled()) {
                log.debug("instances : " + instances);
            }
            if (instances == null || instances.isEmpty()) {
                if (!this.memcachedInstancesByServerGroup.isEmpty()) {
                    this.cleanupMemcachedInstances(false);
                }
                return;
            }
            for (Map.Entry<ServerGroup, EVCacheServerGroupConfig> serverGroupEntry : instances.entrySet()) {
                List<InetSocketAddress> memcachedSAInServerGroup;
                Set<Object> discoveredHostsInServerGroup;
                ServerGroup serverGroup = serverGroupEntry.getKey();
                EVCacheServerGroupConfig config = serverGroupEntry.getValue();
                Set<InetSocketAddress> discoverdInstanceInServerGroup = config.getInetSocketAddress();
                String zone = serverGroup.getZone();
                Set<Object> set = discoveredHostsInServerGroup = discoverdInstanceInServerGroup == null ? Collections.emptySet() : discoverdInstanceInServerGroup;
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tSize : " + discoveredHostsInServerGroup.size() + "\n\tInstances in ServerGroup : " + discoveredHostsInServerGroup);
                }
                if (discoveredHostsInServerGroup.size() == 0 && this.memcachedInstancesByServerGroup.containsKey(serverGroup)) {
                    if (log.isDebugEnabled()) {
                        log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + " has no active servers. Cleaning up this ServerGroup.");
                    }
                    List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.remove(serverGroup);
                    this.memcachedReadInstancesByServerGroup.remove(serverGroup);
                    this.memcachedWriteInstancesByServerGroup.remove(serverGroup);
                    for (EVCacheClient client : clients) {
                        if (log.isDebugEnabled()) {
                            log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tClient : " + client + " will be shutdown in 30 seconds.");
                        }
                        client.shutdown(30L, TimeUnit.SECONDS);
                        client.getConnectionObserver().shutdown();
                    }
                    continue;
                }
                boolean instanceChangeInServerGroup = force;
                if (instanceChangeInServerGroup) {
                    if (log.isWarnEnabled()) {
                        log.warn("FORCE REFRESH :: AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Changed : " + instanceChangeInServerGroup);
                    }
                } else {
                    instanceChangeInServerGroup = this.haveInstancesInServerGroupChanged(serverGroup, discoveredHostsInServerGroup);
                    if (log.isDebugEnabled()) {
                        log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tinstanceChangeInServerGroup : " + instanceChangeInServerGroup);
                    }
                    if (!instanceChangeInServerGroup) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Changed : " + instanceChangeInServerGroup);
                        continue;
                    }
                }
                if ((memcachedSAInServerGroup = this.getMemcachedSocketAddressList(discoveredHostsInServerGroup)).size() <= 0) continue;
                int poolSize = this._poolSize.get();
                ArrayList<EVCacheClient> newClients = new ArrayList<EVCacheClient>(poolSize);
                for (int i = 0; i < poolSize; ++i) {
                    int maxQueueSize = EVCacheConfig.getInstance().getDynamicIntProperty(this._appName + ".max.queue.length", 16384).get();
                    try {
                        EVCacheClient client = new EVCacheClient(this._appName, zone, i, config, memcachedSAInServerGroup, maxQueueSize, this._maxReadQueueSize, this._readTimeout, this._bulkReadTimeout, this._opQueueMaxBlockTime, this._operationTimeout, this);
                        newClients.add(client);
                        int id = client.getId();
                        if (log.isDebugEnabled()) {
                            log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; intit : client.getId() : " + id);
                        }
                        this.lastReconcileTime = System.currentTimeMillis();
                        continue;
                    }
                    catch (Exception e) {
                        EVCacheMetricsFactory.getInstance().increment("EVCacheClientPool-" + this._appName + "-" + serverGroup.getName() + "EVCacheClient-INIT_ERROR");
                        log.error("Unable to create EVCacheClient for app - " + this._appName + " and Server Group - " + serverGroup.getName(), (Throwable)e);
                    }
                }
                if (newClients.size() <= 0) continue;
                this.setupNewClientsByServerGroup(serverGroup, newClients);
            }
            if (this.memcachedInstancesByServerGroup.size() > instances.size()) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\tAppName :" + this._appName + ";\n\tServerGroup Discovered : " + instances.keySet() + ";\n\tCurrent ServerGroup in EVCache Client : " + this.memcachedInstancesByServerGroup.keySet());
                }
                this.cleanupMemcachedInstances(false);
            }
            this.updateMemcachedReadInstancesByZone();
            this.updateQueueStats();
            if (((Boolean)this._pingServers.get()).booleanValue()) {
                this.pingServers();
            }
        }
        catch (Throwable t) {
            log.error("Exception while refreshing the Server list", t);
        }
        finally {
            operationDuration.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
        }
        if (log.isDebugEnabled()) {
            log.debug("refresh APP : " + this._appName + "; DONE");
        }
    }

    private void updateQueueStats() {
        for (ServerGroup serverGroup : this.memcachedInstancesByServerGroup.keySet()) {
            List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.get(serverGroup);
            for (EVCacheClient client : clients) {
                int wSize = client.getWriteQueueLength();
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-WriteQueueSize", client.getTagList()).set(wSize);
                int rSize = client.getReadQueueLength();
                EVCacheMetricsFactory.getInstance().getLongGauge("EVCacheClientPool-ReadQueueSize", client.getTagList()).set(rSize);
                if (!((Boolean)this.refreshConnectionOnReadQueueFull.get()).booleanValue()) continue;
                Collection allNodes = client.getNodeLocator().getAll();
                for (MemcachedNode node : allNodes) {
                    EVCacheNodeImpl evcNode;
                    if (!(node instanceof EVCacheNodeImpl) || (evcNode = (EVCacheNodeImpl)node).getReadQueueSize() < (Integer)this.refreshConnectionOnReadQueueFullSize.get()) continue;
                    EVCacheMetricsFactory.getInstance().getCounter("EVCacheClientPool-REFRESH_ON_QUEUE_FULL", evcNode.getTags()).increment();
                    client.getEVCacheMemcachedClient().reconnectNode(evcNode);
                }
            }
        }
    }

    public void pingServers() {
        try {
            Map<ServerGroup, List<EVCacheClient>> allServers = this.getAllInstancesByZone();
            for (Map.Entry<ServerGroup, List<EVCacheClient>> entry : allServers.entrySet()) {
                List<EVCacheClient> listOfClients = entry.getValue();
                for (EVCacheClient client : listOfClients) {
                    Map<SocketAddress, String> versions = client.getVersions();
                    for (Map.Entry<SocketAddress, String> vEntry : versions.entrySet()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Host : " + vEntry.getKey() + " : " + vEntry.getValue());
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error("Error while pinging the servers", t);
        }
    }

    public void serverGroupDisabled(ServerGroup serverGroup) {
        if (this.memcachedInstancesByServerGroup.containsKey(serverGroup)) {
            if (log.isDebugEnabled()) {
                log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + " has no active servers. Cleaning up this ServerGroup.");
            }
            List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.remove(serverGroup);
            this.memcachedReadInstancesByServerGroup.remove(serverGroup);
            this.memcachedWriteInstancesByServerGroup.remove(serverGroup);
            for (EVCacheClient client : clients) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tClient : " + client + " will be shutdown in 30 seconds.");
                }
                client.shutdown(30L, TimeUnit.SECONDS);
                client.getConnectionObserver().shutdown();
            }
        }
    }

    public void refreshAsync(MemcachedNode node) {
        if (log.isInfoEnabled()) {
            log.info("Pool is being refresh as the EVCacheNode is not available. " + node.toString());
        }
        if (!this._disableAsyncRefresh.get()) {
            boolean force;
            EVCacheMetricsFactory.getInstance().increment("EVCacheClientPool-" + this._appName + "-refreshAsync");
            boolean bl = force = System.currentTimeMillis() - this.lastReconcileTime > (long)(this.manager.getDefaultRefreshInterval().get() * 1000);
            if (!force) {
                force = !node.isActive();
            }
            this.refreshPool(true, force);
        }
    }

    @Override
    public void run() {
        block2: {
            try {
                this.refresh();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list for " + this._appName, t);
            }
        }
    }

    void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("EVCacheClientPool for App : " + this._appName + " and Zone : " + this._zone + " is being shutdown.");
        }
        this._shutdown = true;
        for (List<EVCacheClient> instancesInAZone : this.memcachedInstancesByServerGroup.values()) {
            for (EVCacheClient client : instancesInAZone) {
                client.shutdown(30L, TimeUnit.SECONDS);
                client.getConnectionObserver().shutdown();
            }
        }
        this.setupMonitoring();
    }

    private void setupMonitoring() {
        block5: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this._appName + ",SubGroup=pool");
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                if (!this._shutdown) {
                    mbeanServer.registerMBean(this, mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    @Override
    public int getInstanceCount() {
        int instances = 0;
        for (ServerGroup serverGroup : this.memcachedInstancesByServerGroup.keySet()) {
            instances += this.memcachedInstancesByServerGroup.get(serverGroup).get(0).getConnectionObserver().getActiveServerCount();
        }
        return instances;
    }

    @Override
    public Map<String, String> getInstancesByZone() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (ServerGroup zone : this.memcachedInstancesByServerGroup.keySet()) {
            List<EVCacheClient> instanceList = this.memcachedInstancesByServerGroup.get(zone);
            instanceMap.put(zone.toString(), instanceList.toString());
        }
        return instanceMap;
    }

    @Override
    public Map<String, Integer> getInstanceCountByZone() {
        HashMap<String, Integer> instancesByZone = new HashMap<String, Integer>(this.memcachedInstancesByServerGroup.size() * 2);
        for (ServerGroup zone : this.memcachedInstancesByServerGroup.keySet()) {
            instancesByZone.put(zone.getName(), this.memcachedInstancesByServerGroup.get(zone).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instancesByZone;
    }

    @Override
    public Map<String, String> getReadZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (ServerGroup key : this.memcachedReadInstancesByServerGroup.keySet()) {
            instanceMap.put(key.getName(), this.memcachedReadInstancesByServerGroup.get(key).toString());
        }
        return instanceMap;
    }

    @Override
    public Map<String, Integer> getReadInstanceCountByZone() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (ServerGroup key : this.memcachedReadInstancesByServerGroup.keySet()) {
            instanceMap.put(key.getName(), this.memcachedReadInstancesByServerGroup.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instanceMap;
    }

    @Override
    public Map<String, String> getWriteZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (ServerGroup key : this.memcachedWriteInstancesByServerGroup.keySet()) {
            instanceMap.put(key.toString(), this.memcachedWriteInstancesByServerGroup.get(key).toString());
        }
        return instanceMap;
    }

    public Map<ServerGroup, List<EVCacheClient>> getAllInstancesByZone() {
        return Collections.unmodifiableMap(this.memcachedInstancesByServerGroup);
    }

    Map<ServerGroup, List<EVCacheClient>> getAllInstancesByServerGroup() {
        return this.memcachedInstancesByServerGroup;
    }

    @Override
    public Map<String, Integer> getWriteInstanceCountByZone() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (ServerGroup key : this.memcachedWriteInstancesByServerGroup.keySet()) {
            instanceMap.put(key.toString(), this.memcachedWriteInstancesByServerGroup.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instanceMap;
    }

    @Override
    public Map<String, String> getReadServerGroupByZone() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String key : this.readServerGroupByZone.keySet()) {
            instanceMap.put(key, this.readServerGroupByZone.get(key).toString());
        }
        return instanceMap;
    }

    @Override
    public void refreshPool() {
        this.refreshPool(false, true);
    }

    public void refreshPool(boolean async, final boolean force) {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("Refresh Pool : async : " + async + "; force : " + force);
            }
            try {
                if (async) {
                    this.asyncRefreshExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EVCacheClientPool.this.refresh(force);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                } else {
                    this.refresh(force);
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Error Refreshing EVCache Instance list from MBean : " + this._appName, t);
            }
        }
    }

    @Override
    public String getFallbackServerGroup() {
        return this.memcachedFallbackReadInstances.toString();
    }

    public boolean supportsFallback() {
        return this.memcachedFallbackReadInstances.getSize() > 1;
    }

    public boolean isLogEventEnabled() {
        return this.logOperations.get() > 0;
    }

    public boolean shouldLogOperation(String key, String op) {
        if (!this.isLogEventEnabled()) {
            return false;
        }
        if (!this.logOperationCalls.get().contains(op)) {
            return false;
        }
        return key.hashCode() % 1000 <= this.logOperations.get();
    }

    @Override
    public String getLocalServerGroupCircularIterator() {
        return this.localServerGroupIterator == null ? "NONE" : this.localServerGroupIterator.toString();
    }

    @Override
    public String getPoolDetails() {
        return this.toString();
    }

    public String toString() {
        return "\nEVCacheClientPool [\n\t_appName=" + this._appName + ",\n\t_zone=" + this._zone + ",\n\tlocalServerGroupIterator=" + this.localServerGroupIterator + ",\n\t_poolSize=" + this._poolSize + ",\n\t_readTimeout=" + this._readTimeout + ",\n\t_bulkReadTimeout=" + this._bulkReadTimeout + ",\n\tlogOperations=" + this.logOperations + ",\n\t_opQueueMaxBlockTime=" + this._opQueueMaxBlockTime + ",\n\t_operationTimeout=" + this._operationTimeout + ",\n\t_maxReadQueueSize=" + this._maxReadQueueSize + ",\n\t_pingServers=" + this._pingServers + ",\n\twriteOnlyFastPropertyMap=" + this.writeOnlyFastPropertyMap + ",\n\tnumberOfModOps=" + this.numberOfModOps.get() + ",\n\t_shutdown=" + this._shutdown + ",\n\tmemcachedInstancesByServerGroup=" + this.memcachedInstancesByServerGroup + ",\n\tmemcachedReadInstancesByServerGroup=" + this.memcachedReadInstancesByServerGroup + ",\n\tmemcachedWriteInstancesByServerGroup=" + this.memcachedWriteInstancesByServerGroup + ",\n\treadServerGroupByZone=" + this.readServerGroupByZone + ",\n\tmemcachedFallbackReadInstances=" + this.memcachedFallbackReadInstances + "\n]";
    }

    public int getPoolSize() {
        return this._poolSize.get();
    }

    public DynamicIntProperty getLogOperations() {
        return this.logOperations;
    }

    public DynamicIntProperty getOpQueueMaxBlockTime() {
        return this._opQueueMaxBlockTime;
    }

    public DynamicIntProperty getOperationTimeout() {
        return this._operationTimeout;
    }

    public DynamicIntProperty getMaxReadQueueSize() {
        return this._maxReadQueueSize;
    }

    public ChainedDynamicProperty.BooleanProperty getPingServers() {
        return this._pingServers;
    }

    public long getNumberOfModOps() {
        return this.numberOfModOps.get();
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    public String getZone() {
        return this._zone;
    }

    public String getAppName() {
        return this._appName;
    }

    public EVCacheClientPoolManager getEVCacheClientPoolManager() {
        return this.manager;
    }

    public Map<ServerGroup, ChainedDynamicProperty.BooleanProperty> getWriteOnlyFastPropertyMap() {
        return Collections.unmodifiableMap(this.writeOnlyFastPropertyMap);
    }

    public ChainedDynamicProperty.IntProperty getReadTimeout() {
        return this._readTimeout;
    }

    public ChainedDynamicProperty.IntProperty getBulkReadTimeout() {
        return this._bulkReadTimeout;
    }
}

