/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.EVCacheReadQueueException;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheFutures;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.pool.ChunkTranscoder;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.pool.observer.EVCacheConnectionObserver;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.CRC32;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.EVCacheMemcachedClient;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.protocol.binary.EVCacheNodeImpl;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;

@SuppressFBWarnings(value={"REC_CATCH_EXCEPTION", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public class EVCacheClient {
    private static Logger log = LoggerFactory.getLogger(EVCacheClient.class);
    private final ConnectionFactory connectionFactory;
    private final EVCacheMemcachedClient evcacheMemcachedClient;
    private final List<InetSocketAddress> memcachedNodesInZone;
    private EVCacheConnectionObserver connectionObserver = null;
    private boolean shutdown = false;
    private final int id;
    private final String appName;
    private final String zone;
    private final ServerGroup serverGroup;
    private final EVCacheServerGroupConfig config;
    private final int maxWriteQueueSize;
    private final ChainedDynamicProperty.IntProperty readTimeout;
    private final ChainedDynamicProperty.IntProperty bulkReadTimeout;
    private final DynamicIntProperty operationTimeout;
    private final DynamicIntProperty maxReadQueueSize;
    private final ChainedDynamicProperty.BooleanProperty enableChunking;
    private final ChainedDynamicProperty.IntProperty chunkSize;
    private final ChainedDynamicProperty.IntProperty writeBlock;
    private final ChunkTranscoder chunkingTranscoder;
    private final SerializingTranscoder decodingTranscoder;
    private static final int SPECIAL_BYTEARRAY = 2048;
    private final EVCacheClientPool pool;
    private final ChainedDynamicProperty.BooleanProperty ignoreTouch;
    private final List<Tag> tags;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    EVCacheClient(String appName, String zone, int id, EVCacheServerGroupConfig config, List<InetSocketAddress> memcachedNodesInZone, int maxQueueSize, DynamicIntProperty maxReadQueueSize, ChainedDynamicProperty.IntProperty readTimeout, ChainedDynamicProperty.IntProperty bulkReadTimeout, DynamicIntProperty opQueueMaxBlockTime, DynamicIntProperty operationTimeout, EVCacheClientPool pool) throws IOException {
        this.memcachedNodesInZone = memcachedNodesInZone;
        this.id = id;
        this.appName = appName;
        this.zone = zone;
        this.config = config;
        this.serverGroup = config.getServerGroup();
        this.readTimeout = readTimeout;
        this.bulkReadTimeout = bulkReadTimeout;
        this.maxReadQueueSize = maxReadQueueSize;
        this.operationTimeout = operationTimeout;
        this.pool = pool;
        this.tags = new ArrayList<Tag>(3);
        this.tags.add((Tag)new BasicTag("APP", appName));
        this.tags.add((Tag)new BasicTag("Id", String.valueOf(id)));
        this.tags.add((Tag)new BasicTag("ServerGroup", this.serverGroup.getName()));
        this.enableChunking = EVCacheConfig.getInstance().getChainedBooleanProperty(this.serverGroup.getName() + ".chunk.data", appName + ".chunk.data", Boolean.FALSE);
        this.chunkSize = EVCacheConfig.getInstance().getChainedIntProperty(this.serverGroup.getName() + ".chunk.size", appName + ".chunk.size", 1180);
        this.writeBlock = EVCacheConfig.getInstance().getChainedIntProperty(appName + "." + this.serverGroup.getName() + ".write.block.duration", appName + ".write.block.duration", 25);
        this.chunkingTranscoder = new ChunkTranscoder();
        this.maxWriteQueueSize = maxQueueSize;
        this.ignoreTouch = EVCacheConfig.getInstance().getChainedBooleanProperty(appName + "." + this.serverGroup.getName() + ".ignore.touch", appName + ".ignore.touch", false);
        this.decodingTranscoder = new SerializingTranscoder(Integer.MAX_VALUE);
        this.decodingTranscoder.setCompressionThreshold(Integer.MAX_VALUE);
        this.connectionFactory = pool.getEVCacheClientPoolManager().getConnectionFactoryProvider().getConnectionFactory(this);
        this.evcacheMemcachedClient = new EVCacheMemcachedClient(this.connectionFactory, memcachedNodesInZone, readTimeout, this);
        this.connectionObserver = new EVCacheConnectionObserver(this);
        this.evcacheMemcachedClient.addObserver(this.connectionObserver);
    }

    private Collection<String> validateReadQueueSize(Collection<String> canonicalKeys) throws EVCacheException {
        if (this.evcacheMemcachedClient.getNodeLocator() == null) {
            return canonicalKeys;
        }
        ArrayList<String> retKeys = new ArrayList<String>(canonicalKeys.size());
        for (String key : canonicalKeys) {
            boolean canAddToOpQueue;
            EVCacheNodeImpl evcNode;
            MemcachedNode node = this.evcacheMemcachedClient.getNodeLocator().getPrimary(key);
            if (!(node instanceof EVCacheNodeImpl) || !(evcNode = (EVCacheNodeImpl)node).isAvailable()) continue;
            int size = evcNode.getReadQueueSize();
            boolean bl = canAddToOpQueue = size < this.maxReadQueueSize.get() * 2;
            if (!canAddToOpQueue) {
                EVCacheMetricsFactory.getInstance().increment(this.appName + "-READ_QUEUE_FULL", evcNode.getTags());
                if (!log.isDebugEnabled()) continue;
                log.debug("Read Queue Full on Bulk Operation for app : " + this.appName + "; zone : " + this.zone + "; Current Size : " + size + "; Max Size : " + this.maxReadQueueSize.get() * 2);
                continue;
            }
            retKeys.add(key);
        }
        return retKeys;
    }

    private boolean ensureWriteQueueSize(MemcachedNode node, String key) throws EVCacheException {
        block7: {
            if (node instanceof EVCacheNodeImpl) {
                EVCacheNodeImpl evcNode = (EVCacheNodeImpl)node;
                if (!evcNode.isAvailable()) {
                    EVCacheMetricsFactory.getInstance().getCounter("EVCacheClient-" + this.appName + "-INACTIVE_NODE", evcNode.getTags()).increment();
                    this.getEVCacheMemcachedClient().reconnectNode(evcNode);
                }
                int i = 0;
                do {
                    int size;
                    boolean canAddToOpQueue;
                    boolean bl = canAddToOpQueue = (size = evcNode.getWriteQueueSize()) < this.maxWriteQueueSize;
                    if (log.isDebugEnabled()) {
                        log.debug("App : " + this.appName + "; zone : " + this.zone + "; key : " + key + "; WriteQSize : " + size);
                    }
                    if (canAddToOpQueue) break block7;
                    EVCacheMetricsFactory.getInstance().getCounter("EVCacheClient-" + this.appName + "-WRITE_BLOCK", evcNode.getTags()).increment();
                    try {
                        Thread.sleep(((Integer)this.writeBlock.get()).intValue());
                    }
                    catch (InterruptedException e) {
                        throw new EVCacheException("Thread was Interrupted", e);
                    }
                } while (i++ <= 3);
                EVCacheMetricsFactory.getInstance().getCounter("EVCacheClient-" + this.appName + "-INACTIVE_NODE", evcNode.getTags()).increment();
                if (log.isDebugEnabled()) {
                    log.debug("Node : " + evcNode + " for app : " + this.appName + "; zone : " + this.zone + " is not active. Will Fail Fast and the write will be dropped for key : " + key);
                }
                evcNode.shutdown();
                return false;
            }
        }
        return true;
    }

    private boolean validateNode(String key, boolean _throwException) throws EVCacheException {
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (node instanceof EVCacheNodeImpl) {
            boolean canAddToOpQueue;
            EVCacheNodeImpl evcNode = (EVCacheNodeImpl)node;
            if (!evcNode.isAvailable()) {
                EVCacheMetricsFactory.getInstance().getCounter("EVCacheClient-" + this.appName + "-INACTIVE_NODE", evcNode.getTags()).increment();
                if (log.isDebugEnabled()) {
                    log.debug("Node : " + node + " for app : " + this.appName + "; zone : " + this.zone + " is not active. Will Fail Fast so that we can fallback to Other Zone if available.");
                }
                if (_throwException) {
                    throw new EVCacheException("Connection for Node : " + node + " for app : " + this.appName + "; zone : " + this.zone + " is not active");
                }
                return false;
            }
            int size = evcNode.getReadQueueSize();
            boolean bl = canAddToOpQueue = size < this.maxReadQueueSize.get();
            if (log.isDebugEnabled()) {
                log.debug("Current Read Queue Size - " + size + " for app " + this.appName + " & zone " + this.zone);
            }
            if (!canAddToOpQueue) {
                EVCacheMetricsFactory.getInstance().getCounter(this.appName + "-READ_QUEUE_FULL", evcNode.getTags()).increment();
                if (log.isDebugEnabled()) {
                    log.debug("Read Queue Full for Node : " + node + "; app : " + this.appName + "; zone : " + this.zone + "; Current Size : " + size + "; Max Size : " + this.maxReadQueueSize.get());
                }
                if (_throwException) {
                    throw new EVCacheReadQueueException("Read Queue Full for Node : " + node + "; app : " + this.appName + "; zone : " + this.zone + "; Current Size : " + size + "; Max Size : " + this.maxReadQueueSize.get());
                }
                return false;
            }
        }
        return true;
    }

    private <T> ChunkDetails<T> getChunkDetails(String key) {
        ArrayList<String> firstKeys = new ArrayList<String>(2);
        firstKeys.add(key);
        String firstKey = key + "_00";
        firstKeys.add(firstKey);
        try {
            Map<String, CachedData> metadataMap = this.evcacheMemcachedClient.asyncGetBulk(firstKeys, this.chunkingTranscoder, null, "GetChunkMetadataOperation").getSome(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false);
            if (metadataMap.containsKey(key)) {
                return new ChunkDetails<CachedData>(null, null, false, metadataMap.get(key));
            }
            if (metadataMap.containsKey(firstKey)) {
                ChunkInfo ci = this.getChunkInfo(firstKey, (String)this.decodingTranscoder.decode(metadataMap.get(firstKey)));
                if (ci == null) {
                    return null;
                }
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 1; i < ci.getChunks(); ++i) {
                    String prefix = i < 10 ? "0" : "";
                    keys.add(ci.getKey() + "_" + prefix + i);
                }
                return new ChunkDetails<Object>(keys, ci, true, null);
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private <T> Single<ChunkDetails<T>> getChunkDetails(String key, Scheduler scheduler) {
        ArrayList<String> firstKeys = new ArrayList<String>(2);
        firstKeys.add(key);
        String firstKey = key + "_00";
        firstKeys.add(firstKey);
        return this.evcacheMemcachedClient.asyncGetBulk(firstKeys, this.chunkingTranscoder, null, "GetChunkMetadataOperation").getSome(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false, scheduler).map(metadataMap -> {
            if (metadataMap.containsKey(key)) {
                return new ChunkDetails(null, null, false, metadataMap.get(key));
            }
            if (metadataMap.containsKey(firstKey)) {
                ChunkInfo ci = this.getChunkInfo(firstKey, (String)this.decodingTranscoder.decode((CachedData)metadataMap.get(firstKey)));
                if (ci == null) {
                    return null;
                }
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 1; i < ci.getChunks(); ++i) {
                    String prefix = i < 10 ? "0" : "";
                    keys.add(ci.getKey() + "_" + prefix + i);
                }
                return new ChunkDetails<Object>(keys, ci, true, null);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T assembleChunks(String key, boolean touch, int ttl, Transcoder<T> tc, boolean hasZF) {
        long start = System.currentTimeMillis();
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-LatencyChunk", this.getTagList());
        try {
            String _key;
            ChunkDetails<T> cd = this.getChunkDetails(key);
            if (cd == null) {
                T t = null;
                return t;
            }
            if (!cd.isChunked()) {
                if (cd.getData() == null) {
                    T t = null;
                    return t;
                }
                Transcoder transcoder = tc == null ? this.evcacheMemcachedClient.getTranscoder() : tc;
                Object object = transcoder.decode((CachedData)cd.getData());
                return (T)object;
            }
            List<String> keys = cd.getChunkKeys();
            ChunkInfo ci = cd.getChunkInfo();
            Map<String, CachedData> dataMap = this.evcacheMemcachedClient.asyncGetBulk(keys, this.chunkingTranscoder, null, "GetChunksOperation").getSome(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false);
            if (dataMap.size() != ci.getChunks() - 1) {
                EVCacheMetricsFactory.getInstance().increment(this.appName + "-INCORRECT_NUM_CHUNKS");
                T t = null;
                return t;
            }
            byte[] data = new byte[(ci.getChunks() - 2) * ci.getChunkSize() + (ci.getLastChunk() == 0 ? ci.getChunkSize() : ci.getLastChunk())];
            int index = 0;
            for (int i = 0; i < keys.size(); ++i) {
                int len;
                _key = keys.get(i);
                CachedData _cd = dataMap.get(_key);
                if (log.isDebugEnabled()) {
                    log.debug("Chunk Key " + _key + "; Value : " + _cd);
                }
                if (_cd == null) continue;
                byte[] val = _cd.getData();
                if (val == null) {
                    T t = null;
                    return t;
                }
                int n = i == keys.size() - 1 ? (ci.getLastChunk() == 0 || ci.getLastChunk() > ci.getChunkSize() ? ci.getChunkSize() : ci.getLastChunk()) : (len = val.length);
                if (len != ci.getChunkSize() && i != keys.size() - 1) {
                    EVCacheMetricsFactory.getInstance().increment(this.appName + "-INVALID_CHUNK_SIZE");
                    if (log.isWarnEnabled()) {
                        log.warn("CHUNK_SIZE_ERROR : Chunks : " + ci.getChunks() + " ; " + "length : " + len + "; expectedLength : " + ci.getChunkSize() + " for key : " + _key);
                    }
                }
                if (len <= 0) continue;
                try {
                    System.arraycopy(val, 0, data, index, len);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("ArrayCopyError - Key : " + _key + "; final data Size : " + data.length + "; copy array size : " + len + "; val size : " + val.length + "; key index : " + i + "; copy from : " + index + "; ChunkInfo : " + ci + "\n");
                    for (int j = 0; j < keys.size(); ++j) {
                        String skey = keys.get(j);
                        byte[] sval = dataMap.get(skey).getData();
                        sb.append(skey + "=" + sval.length + "\n");
                    }
                    if (log.isWarnEnabled()) {
                        log.warn(sb.toString(), (Throwable)e);
                    }
                    throw e;
                }
                index += val.length;
                if (!touch) continue;
                this.evcacheMemcachedClient.touch(_key, ttl);
            }
            boolean checksumPass = this.checkCRCChecksum(data, ci, hasZF);
            if (!checksumPass) {
                _key = null;
                return (T)_key;
            }
            Transcoder transcoder = tc == null ? this.evcacheMemcachedClient.getTranscoder() : tc;
            Object object = transcoder.decode(new CachedData(ci.getFlags(), data, Integer.MAX_VALUE));
            return (T)object;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (operationDuration != null) {
                operationDuration.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
            }
        }
        return null;
    }

    private <T> Single<T> assembleChunks(String key, boolean touch, int ttl, Transcoder<T> tc, boolean hasZF, Scheduler scheduler) {
        long start = System.currentTimeMillis();
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-LatencyChunk", this.getTagList());
        return this.getChunkDetails(key, scheduler).flatMap(cd -> {
            if (cd == null) {
                return Single.just(null);
            }
            if (!cd.isChunked()) {
                if (cd.getData() == null) {
                    return Single.just(null);
                }
                Transcoder transcoder2 = tc == null ? this.evcacheMemcachedClient.getTranscoder() : tc;
                return Single.just((Object)transcoder2.decode((CachedData)cd.getData()));
            }
            List<String> keys = cd.getChunkKeys();
            ChunkInfo ci = cd.getChunkInfo();
            return this.evcacheMemcachedClient.asyncGetBulk(keys, this.chunkingTranscoder, null, "GetChunksOperation").getSome(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false, scheduler).map(dataMap -> {
                if (dataMap.size() != ci.getChunks() - 1) {
                    EVCacheMetricsFactory.getInstance().increment(this.appName + "-INCORRECT_NUM_CHUNKS");
                    return null;
                }
                byte[] data = new byte[(ci.getChunks() - 2) * ci.getChunkSize() + (ci.getLastChunk() == 0 ? ci.getChunkSize() : ci.getLastChunk())];
                int index = 0;
                for (int i = 0; i < keys.size(); ++i) {
                    int len;
                    String _key = (String)keys.get(i);
                    CachedData _cd = (CachedData)dataMap.get(_key);
                    if (log.isDebugEnabled()) {
                        log.debug("Chunk Key " + _key + "; Value : " + _cd);
                    }
                    if (_cd == null) continue;
                    byte[] val = _cd.getData();
                    if (val == null) {
                        return null;
                    }
                    int n2 = i == keys.size() - 1 ? (ci.getLastChunk() == 0 || ci.getLastChunk() > ci.getChunkSize() ? ci.getChunkSize() : ci.getLastChunk()) : (len = val.length);
                    if (len != ci.getChunkSize() && i != keys.size() - 1) {
                        EVCacheMetricsFactory.getInstance().increment(this.appName + "-INVALID_CHUNK_SIZE");
                        if (log.isWarnEnabled()) {
                            log.warn("CHUNK_SIZE_ERROR : Chunks : " + ci.getChunks() + " ; " + "length : " + len + "; expectedLength : " + ci.getChunkSize() + " for key : " + _key);
                        }
                    }
                    if (len <= 0) continue;
                    try {
                        System.arraycopy(val, 0, data, index, len);
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("ArrayCopyError - Key : " + _key + "; final data Size : " + data.length + "; copy array size : " + len + "; val size : " + val.length + "; key index : " + i + "; copy from : " + index + "; ChunkInfo : " + ci + "\n");
                        for (int j = 0; j < keys.size(); ++j) {
                            String skey = (String)keys.get(j);
                            byte[] sval = ((CachedData)dataMap.get(skey)).getData();
                            sb.append(skey + "=" + sval.length + "\n");
                        }
                        if (log.isWarnEnabled()) {
                            log.warn(sb.toString(), (Throwable)e);
                        }
                        throw e;
                    }
                    System.arraycopy(val, 0, data, index, len);
                    index += val.length;
                    if (!touch) continue;
                    this.evcacheMemcachedClient.touch(_key, ttl);
                }
                boolean checksumPass = this.checkCRCChecksum(data, ci, hasZF);
                if (!checksumPass) {
                    return null;
                }
                Transcoder transcoder2 = tc == null ? this.evcacheMemcachedClient.getTranscoder() : tc;
                return transcoder2.decode(new CachedData(ci.getFlags(), data, Integer.MAX_VALUE));
            });
        }).doAfterTerminate(() -> operationDuration.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS));
    }

    private boolean checkCRCChecksum(byte[] data, ChunkInfo ci, boolean hasZF) {
        if (data == null || data.length == 0) {
            return false;
        }
        CRC32 checksum = new CRC32();
        checksum.update(data, 0, data.length);
        long currentChecksum = checksum.getValue();
        long expectedChecksum = ci.getChecksum();
        if (log.isDebugEnabled()) {
            log.debug("CurrentChecksum : " + currentChecksum + "; ExpectedChecksum : " + expectedChecksum + " for key : " + ci.getKey());
        }
        if (currentChecksum != expectedChecksum) {
            if (!hasZF) {
                if (log.isWarnEnabled()) {
                    log.warn("CHECKSUM_ERROR : Chunks : " + ci.getChunks() + " ; " + "currentChecksum : " + currentChecksum + "; expectedChecksum : " + expectedChecksum + " for key : " + ci.getKey());
                }
                EVCacheMetricsFactory.getInstance().increment(this.appName + "-CHECK_SUM_ERROR");
            }
            return false;
        }
        return true;
    }

    private ChunkInfo getChunkInfo(String firstKey, String metadata) {
        if (metadata == null) {
            return null;
        }
        String[] metaItems = metadata.split(":");
        if (metaItems.length != 5) {
            return null;
        }
        String key = firstKey.substring(0, firstKey.length() - 3);
        ChunkInfo ci = new ChunkInfo(Integer.parseInt(metaItems[0]), Integer.parseInt(metaItems[1]), Integer.parseInt(metaItems[2]), Integer.parseInt(metaItems[3]), key, Long.parseLong(metaItems[4]));
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<String, T> assembleChunks(Collection<String> keyList, Transcoder<T> tc, boolean hasZF) {
        ArrayList<String> firstKeys = new ArrayList<String>();
        for (String key : keyList) {
            firstKeys.add(key);
            firstKeys.add(key + "_00");
        }
        long start = System.currentTimeMillis();
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-LatencyChunk", this.getTagList());
        try {
            byte[] data;
            List<String> ciKeys;
            Map<String, CachedData> metadataMap = this.evcacheMemcachedClient.asyncGetBulk(firstKeys, this.chunkingTranscoder, null, "GetChunkMetadataOperation").getSome(((Integer)this.bulkReadTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false);
            if (metadataMap == null) {
                Map<String, T> map = null;
                return map;
            }
            HashMap<String, Object> returnMap = new HashMap<String, Object>(keyList.size() * 2);
            for (String key : keyList) {
                if (!metadataMap.containsKey(key)) continue;
                CachedData val = metadataMap.remove(key);
                returnMap.put(key, tc.decode(val));
            }
            ArrayList<String> allKeys = new ArrayList<String>();
            HashMap responseMap = new HashMap();
            for (Map.Entry hashMap : metadataMap.entrySet()) {
                ChunkInfo ci;
                String firstKey = (String)hashMap.getKey();
                String metadata = (String)this.decodingTranscoder.decode((CachedData)hashMap.getValue());
                if (metadata == null || (ci = this.getChunkInfo(firstKey, metadata)) == null) continue;
                ciKeys = new ArrayList();
                for (int i = 1; i < ci.getChunks(); ++i) {
                    String prefix = i < 10 ? "0" : "";
                    String _key = ci.getKey() + "_" + prefix + i;
                    allKeys.add(_key);
                    ciKeys.add(_key);
                }
                data = new byte[(ci.getChunks() - 2) * ci.getChunkSize() + ci.getLastChunk()];
                responseMap.put(ci, new AbstractMap.SimpleEntry(ciKeys, data));
            }
            Map<String, CachedData> dataMap = this.evcacheMemcachedClient.asyncGetBulk(allKeys, this.chunkingTranscoder, null, "GetChunksOperation").getSome(((Integer)this.bulkReadTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false);
            for (Map.Entry entry : responseMap.entrySet()) {
                ChunkInfo ci = (ChunkInfo)entry.getKey();
                AbstractMap.SimpleEntry pair = (AbstractMap.SimpleEntry)entry.getValue();
                ciKeys = (List)pair.getKey();
                data = (byte[])pair.getValue();
                int index = 0;
                for (int i = 0; i < ciKeys.size(); ++i) {
                    String _key = (String)ciKeys.get(i);
                    CachedData cd = dataMap.get(_key);
                    if (log.isDebugEnabled()) {
                        log.debug("Chunk Key " + _key + "; Value : " + cd);
                    }
                    if (cd == null) continue;
                    byte[] val = cd.getData();
                    if (val == null) {
                        data = null;
                        break;
                    }
                    int len = i == ciKeys.size() - 1 ? (ci.getLastChunk() == 0 || ci.getLastChunk() > ci.getChunkSize() ? ci.getChunkSize() : ci.getLastChunk()) : val.length;
                    try {
                        System.arraycopy(val, 0, data, index, len);
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("ArrayCopyError - Key : " + _key + "; final data Size : " + data.length + "; copy array size : " + len + "; val size : " + val.length + "; key index : " + i + "; copy from : " + index + "; ChunkInfo : " + ci + "\n");
                        for (int j = 0; j < ciKeys.size(); ++j) {
                            String skey = (String)ciKeys.get(j);
                            byte[] sval = dataMap.get(skey).getData();
                            sb.append(skey + "=" + sval.length + "\n");
                        }
                        if (log.isWarnEnabled()) {
                            log.warn(sb.toString(), (Throwable)e);
                        }
                        throw e;
                    }
                    index += val.length;
                }
                boolean checksumPass = this.checkCRCChecksum(data, ci, hasZF);
                if (data != null && checksumPass) {
                    CachedData cd = new CachedData(ci.getFlags(), data, Integer.MAX_VALUE);
                    returnMap.put(ci.getKey(), tc.decode(cd));
                    continue;
                }
                returnMap.put(ci.getKey(), null);
            }
            HashMap<String, Object> hashMap = returnMap;
            return hashMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (operationDuration != null) {
                operationDuration.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
            }
        }
        return null;
    }

    private <T> Single<Map<String, T>> assembleChunks(Collection<String> keyList, Transcoder<T> tc, boolean hasZF, Scheduler scheduler) {
        ArrayList<String> firstKeys = new ArrayList<String>();
        for (String key : keyList) {
            firstKeys.add(key);
            firstKeys.add(key + "_00");
        }
        long start = System.currentTimeMillis();
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-LatencyChunk", this.getTagList());
        return this.evcacheMemcachedClient.asyncGetBulk(firstKeys, this.chunkingTranscoder, null, "GetChunkMetadataOperation").getSome(((Integer)this.bulkReadTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false, scheduler).flatMap(metadataMap -> {
            if (metadataMap == null) {
                return null;
            }
            HashMap<String, Object> returnMap = new HashMap<String, Object>(keyList.size() * 2);
            for (String key : keyList) {
                if (!metadataMap.containsKey(key)) continue;
                CachedData val = (CachedData)metadataMap.remove(key);
                returnMap.put(key, tc.decode(val));
            }
            ArrayList<String> allKeys = new ArrayList<String>();
            HashMap responseMap = new HashMap();
            for (Map.Entry entry : metadataMap.entrySet()) {
                ChunkInfo ci;
                String firstKey = (String)entry.getKey();
                String metadata = (String)this.decodingTranscoder.decode((CachedData)entry.getValue());
                if (metadata == null || (ci = this.getChunkInfo(firstKey, metadata)) == null) continue;
                ArrayList<String> ciKeys = new ArrayList<String>();
                for (int i = 1; i < ci.getChunks(); ++i) {
                    String prefix = i < 10 ? "0" : "";
                    String _key = ci.getKey() + "_" + prefix + i;
                    allKeys.add(_key);
                    ciKeys.add(_key);
                }
                byte[] data = new byte[(ci.getChunks() - 2) * ci.getChunkSize() + ci.getLastChunk()];
                responseMap.put(ci, new AbstractMap.SimpleEntry(ciKeys, data));
            }
            return this.evcacheMemcachedClient.asyncGetBulk(allKeys, this.chunkingTranscoder, null, "GetChunksOperation").getSome(((Integer)this.bulkReadTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false, scheduler).map(dataMap -> {
                for (Map.Entry entry : responseMap.entrySet()) {
                    ChunkInfo ci = (ChunkInfo)entry.getKey();
                    AbstractMap.SimpleEntry pair = (AbstractMap.SimpleEntry)entry.getValue();
                    List ciKeys = (List)pair.getKey();
                    byte[] data = (byte[])pair.getValue();
                    int index = 0;
                    for (int i = 0; i < ciKeys.size(); ++i) {
                        String _key = (String)ciKeys.get(i);
                        CachedData cd = (CachedData)dataMap.get(_key);
                        if (log.isDebugEnabled()) {
                            log.debug("Chunk Key " + _key + "; Value : " + cd);
                        }
                        if (cd == null) continue;
                        byte[] val = cd.getData();
                        if (val == null) {
                            data = null;
                            break;
                        }
                        int len = i == ciKeys.size() - 1 ? (ci.getLastChunk() == 0 || ci.getLastChunk() > ci.getChunkSize() ? ci.getChunkSize() : ci.getLastChunk()) : val.length;
                        try {
                            System.arraycopy(val, 0, data, index, len);
                        }
                        catch (Exception e) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("ArrayCopyError - Key : " + _key + "; final data Size : " + data.length + "; copy array size : " + len + "; val size : " + val.length + "; key index : " + i + "; copy from : " + index + "; ChunkInfo : " + ci + "\n");
                            for (int j = 0; j < ciKeys.size(); ++j) {
                                String skey = (String)ciKeys.get(j);
                                byte[] sval = ((CachedData)dataMap.get(skey)).getData();
                                sb.append(skey + "=" + sval.length + "\n");
                            }
                            if (log.isWarnEnabled()) {
                                log.warn(sb.toString(), (Throwable)e);
                            }
                            throw e;
                        }
                        index += val.length;
                    }
                    boolean checksumPass = this.checkCRCChecksum(data, ci, hasZF);
                    if (data != null && checksumPass) {
                        CachedData cd = new CachedData(ci.getFlags(), data, Integer.MAX_VALUE);
                        returnMap.put(ci.getKey(), tc.decode(cd));
                        continue;
                    }
                    returnMap.put(ci.getKey(), null);
                }
                return returnMap;
            });
        }).doAfterTerminate(() -> operationDuration.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS));
    }

    private CachedData[] createChunks(CachedData cd, String key) {
        int cSize = (Integer)this.chunkSize.get();
        if (key.length() + 3 > cSize) {
            throw new IllegalArgumentException("The chunksize " + cSize + " is smaller than the key size. Will not be able to proceed. key size = " + key.length());
        }
        int len = cd.getData().length;
        int overheadSize = key.length() + 71 + 3;
        int actualChunkSize = cSize - overheadSize;
        int lastChunkSize = len % actualChunkSize;
        int numOfChunks = len / actualChunkSize + (lastChunkSize > 0 ? 1 : 0) + 1;
        CachedData[] chunkData = new CachedData[numOfChunks];
        if (lastChunkSize == 0) {
            lastChunkSize = actualChunkSize;
        }
        long sTime = System.nanoTime();
        CRC32 checksum = new CRC32();
        checksum.update(cd.getData(), 0, len);
        long checkSumValue = checksum.getValue();
        int srcPos = 0;
        if (log.isDebugEnabled()) {
            log.debug("Ths size of data is " + len + " ; we will create " + (numOfChunks - 1) + " of " + actualChunkSize + " bytes. Checksum : " + checkSumValue + "; Checksum Duration : " + (System.nanoTime() - sTime));
        }
        chunkData[0] = this.decodingTranscoder.encode((Object)(numOfChunks + ":" + actualChunkSize + ":" + lastChunkSize + ":" + cd.getFlags() + ":" + checkSumValue));
        for (int i = 1; i < numOfChunks; ++i) {
            int lengthOfArray = actualChunkSize;
            if (srcPos + actualChunkSize > len) {
                lengthOfArray = len - srcPos;
            }
            byte[] dest = new byte[actualChunkSize];
            System.arraycopy(cd.getData(), srcPos, dest, 0, lengthOfArray);
            if (actualChunkSize > lengthOfArray) {
                for (int j = lengthOfArray; j < actualChunkSize; ++j) {
                    dest[j] = 0;
                }
            }
            srcPos += lengthOfArray;
            chunkData[i] = new CachedData(2048, dest, Integer.MAX_VALUE);
        }
        EVCacheMetricsFactory.getInstance().getDistributionSummary(this.appName + "-ChunkData-NumberOfChunks", this.getTagList()).record((long)numOfChunks);
        EVCacheMetricsFactory.getInstance().getDistributionSummary(this.appName + "-ChunkData-TotalSize", this.getTagList()).record((long)len);
        return chunkData;
    }

    public Map<String, CachedData> getAllChunks(String key) throws EVCacheReadQueueException, EVCacheException, Exception {
        try {
            ChunkDetails cd = this.getChunkDetails(key);
            if (log.isDebugEnabled()) {
                log.debug("Chunkdetails " + cd);
            }
            if (cd == null) {
                return null;
            }
            if (!cd.isChunked()) {
                HashMap<String, CachedData> rv = new HashMap<String, CachedData>();
                rv.put(key, (CachedData)cd.getData());
                if (log.isDebugEnabled()) {
                    log.debug("Data : " + rv);
                }
                return rv;
            }
            List<String> keys = cd.getChunkKeys();
            if (log.isDebugEnabled()) {
                log.debug("Keys - " + keys);
            }
            Map<String, CachedData> dataMap = this.evcacheMemcachedClient.asyncGetBulk(keys, this.chunkingTranscoder, null, "GetAllChunksOperation").getSome(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, false, false);
            if (log.isDebugEnabled()) {
                log.debug("Datamap " + dataMap);
            }
            return dataMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public long incr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        return this.evcacheMemcachedClient.incr(key, by, defaultVal, timeToLive);
    }

    public long decr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        return this.evcacheMemcachedClient.decr(key, by, defaultVal, timeToLive);
    }

    public <T> T get(String key, Transcoder<T> tc, boolean _throwException, boolean hasZF, boolean chunked) throws Exception {
        if (chunked) {
            return this.assembleChunks(key, false, 0, tc, hasZF);
        }
        return this.evcacheMemcachedClient.asyncGet(key, tc, null).get(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, _throwException, hasZF);
    }

    public <T> T get(String key, Transcoder<T> tc, boolean _throwException, boolean hasZF) throws Exception {
        if (!this.validateNode(key, _throwException)) {
            return null;
        }
        return this.get(key, tc, _throwException, hasZF, (Boolean)this.enableChunking.get());
    }

    public <T> Single<T> get(String key, Transcoder<T> tc, boolean _throwException, boolean hasZF, boolean chunked, Scheduler scheduler) {
        if (chunked) {
            return this.assembleChunks(key, _throwException, 0, tc, hasZF, scheduler);
        }
        return this.evcacheMemcachedClient.asyncGet(key, tc, null).get(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, _throwException, hasZF, scheduler);
    }

    public <T> Single<T> get(String key, Transcoder<T> tc, boolean _throwException, boolean hasZF, Scheduler scheduler) {
        try {
            if (!this.validateNode(key, _throwException)) {
                return Single.just(null);
            }
            return this.get(key, tc, _throwException, hasZF, (Boolean)this.enableChunking.get(), scheduler);
        }
        catch (Throwable e) {
            return Single.error((Throwable)e);
        }
    }

    public <T> T getAndTouch(String key, Transcoder<T> tc, int timeToLive, boolean _throwException, boolean hasZF) throws Exception {
        CASValue value;
        if (!this.validateNode(key, _throwException)) {
            return null;
        }
        if (tc == null) {
            tc = this.getTranscoder();
        }
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            return this.assembleChunks(key, false, 0, (Transcoder<T>)tc, hasZF);
        }
        Object returnVal = (Boolean)this.ignoreTouch.get() != false ? this.evcacheMemcachedClient.get(key, (Transcoder)tc) : ((value = (CASValue)this.evcacheMemcachedClient.asyncGetAndTouch(key, timeToLive, (Transcoder)tc).get(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, _throwException, hasZF)) == null ? null : value.getValue());
        return (T)returnVal;
    }

    public <T> Single<T> getAndTouch(String key, Transcoder<T> tc, int timeToLive, boolean _throwException, boolean hasZF, Scheduler scheduler) {
        try {
            if (!this.validateNode(key, _throwException)) {
                return null;
            }
            if (tc == null) {
                tc = this.getTranscoder();
            }
            if (((Boolean)this.enableChunking.get()).booleanValue()) {
                return this.assembleChunks(key, false, 0, (Transcoder<T>)tc, hasZF, scheduler);
            }
            return this.evcacheMemcachedClient.asyncGetAndTouch(key, timeToLive, (Transcoder)tc).get(((Integer)this.readTimeout.get()).intValue(), TimeUnit.MILLISECONDS, _throwException, hasZF, scheduler).map(value -> value == null ? null : value.getValue());
        }
        catch (Throwable e) {
            return Single.error((Throwable)e);
        }
    }

    public <T> Map<String, T> getBulk(Collection<String> _canonicalKeys, Transcoder<T> tc, boolean _throwException, boolean hasZF) throws Exception {
        Map<String, T> returnVal;
        Collection<String> canonicalKeys = this.validateReadQueueSize(_canonicalKeys);
        try {
            if (tc == null) {
                tc = this.getTranscoder();
            }
            returnVal = ((Boolean)this.enableChunking.get()).booleanValue() ? this.assembleChunks(_canonicalKeys, (Transcoder<T>)tc, hasZF) : this.evcacheMemcachedClient.asyncGetBulk(canonicalKeys, tc, null, "BulkOperation").getSome(((Integer)this.bulkReadTimeout.get()).intValue(), TimeUnit.MILLISECONDS, _throwException, hasZF);
        }
        catch (Exception e) {
            if (_throwException) {
                throw e;
            }
            return Collections.emptyMap();
        }
        return returnVal;
    }

    public <T> Single<Map<String, T>> getBulk(Collection<String> _canonicalKeys, Transcoder<T> tc, boolean _throwException, boolean hasZF, Scheduler scheduler) {
        try {
            Collection<String> canonicalKeys = this.validateReadQueueSize(_canonicalKeys);
            if (tc == null) {
                tc = this.getTranscoder();
            }
            if (((Boolean)this.enableChunking.get()).booleanValue()) {
                return this.assembleChunks(_canonicalKeys, (Transcoder<T>)tc, hasZF, scheduler);
            }
            return this.evcacheMemcachedClient.asyncGetBulk(canonicalKeys, tc, null, "BulkOperation").getSome(((Integer)this.bulkReadTimeout.get()).intValue(), TimeUnit.MILLISECONDS, _throwException, hasZF, scheduler);
        }
        catch (Throwable e) {
            return Single.error((Throwable)e);
        }
    }

    public <T> Future<Boolean> append(String key, T value) throws Exception {
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            throw new EVCacheException("This operation is not supported as chunking is enabled on this EVCacheClient.");
        }
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            return this.getDefaultFuture();
        }
        return this.evcacheMemcachedClient.append(key, value);
    }

    public <T> Future<Boolean> set(String key, T value, int timeToLive) throws Exception {
        return this.set(key, value, timeToLive, null);
    }

    public <T> Future<Boolean> set(String key, T value, int timeToLive, EVCacheLatch evcacheLatch) throws Exception {
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            if (log.isInfoEnabled()) {
                log.info("Node : " + node + " is not active. Failing fast and dropping the write event.");
            }
            ListenableFuture defaultFuture = (ListenableFuture)this.getDefaultFuture();
            if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.isInWriteOnly()) {
                ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)defaultFuture);
            }
            return defaultFuture;
        }
        try {
            int dataSize = Integer.MAX_VALUE;
            if (value instanceof CachedData) {
                dataSize = ((CachedData)value).getData().length;
            }
            if (((Boolean)this.enableChunking.get()).booleanValue()) {
                if (value instanceof CachedData && dataSize > (Integer)this.chunkSize.get()) {
                    CachedData[] cd = this.createChunks((CachedData)value, key);
                    int len = cd.length;
                    OperationFuture[] futures = new OperationFuture[len];
                    for (int i = 0; i < cd.length; ++i) {
                        String prefix = i < 10 ? "0" : "";
                        futures[i] = this.evcacheMemcachedClient.set(key + "_" + prefix + i, timeToLive, cd[i], null, null);
                    }
                    this.evcacheMemcachedClient.delete(key);
                    return new EVCacheFutures(futures, key, this.appName, this.serverGroup, evcacheLatch);
                }
                this.delete(key);
                return this.evcacheMemcachedClient.set(key, timeToLive, value, null, evcacheLatch);
            }
            return this.evcacheMemcachedClient.set(key, timeToLive, value, null, evcacheLatch);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public <T> Future<Boolean> appendOrAdd(String key, CachedData value, int timeToLive, EVCacheLatch evcacheLatch) throws Exception {
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            if (log.isInfoEnabled()) {
                log.info("Node : " + node + " is not active. Failing fast and dropping the write event.");
            }
            ListenableFuture defaultFuture = (ListenableFuture)this.getDefaultFuture();
            if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.isInWriteOnly()) {
                ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)defaultFuture);
            }
            return defaultFuture;
        }
        try {
            return this.evcacheMemcachedClient.asyncAppendOrAdd(key, timeToLive, value, evcacheLatch);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public <T> Future<Boolean> replace(String key, T value, int timeToLive, EVCacheLatch evcacheLatch) throws Exception {
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            if (log.isInfoEnabled()) {
                log.info("Node : " + node + " is not active. Failing fast and dropping the replace event.");
            }
            ListenableFuture defaultFuture = (ListenableFuture)this.getDefaultFuture();
            if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.isInWriteOnly()) {
                ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)defaultFuture);
            }
            return defaultFuture;
        }
        try {
            int dataSize = Integer.MAX_VALUE;
            if (value instanceof CachedData) {
                dataSize = ((CachedData)value).getData().length;
            }
            if (value instanceof CachedData && ((Boolean)this.enableChunking.get()).booleanValue() && dataSize > (Integer)this.chunkSize.get()) {
                CachedData[] cd = this.createChunks((CachedData)value, key);
                int len = cd.length;
                OperationFuture[] futures = new OperationFuture[len];
                for (int i = 0; i < cd.length; ++i) {
                    String prefix = i < 10 ? "0" : "";
                    futures[i] = this.evcacheMemcachedClient.replace(key + "_" + prefix + i, timeToLive, cd[i], null, null);
                }
                return new EVCacheFutures(futures, key, this.appName, this.serverGroup, evcacheLatch);
            }
            return this.evcacheMemcachedClient.replace(key, timeToLive, value, null, evcacheLatch);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean appendOrAdd(String key, CachedData value, int timeToLive) throws EVCacheException {
        int i = 0;
        try {
            do {
                OperationFuture future = this.evcacheMemcachedClient.append(key, value);
                try {
                    if (future.get(this.operationTimeout.get(), TimeUnit.MILLISECONDS) == Boolean.FALSE) {
                        OperationFuture f = this.evcacheMemcachedClient.add(key, timeToLive, value);
                        if (f.get(this.operationTimeout.get(), TimeUnit.MILLISECONDS) == Boolean.TRUE) {
                            return true;
                        }
                        continue;
                    }
                    return true;
                }
                catch (TimeoutException te) {
                    return false;
                }
            } while (i++ < 2);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception appendOrAdd data for APP " + this.appName + ", key : " + key, (Throwable)ex);
            }
            return false;
        }
        return false;
    }

    public <T> Future<Boolean> add(String key, int exp, T value) throws Exception {
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            throw new EVCacheException("This operation is not supported as chunking is enabled on this EVCacheClient.");
        }
        EVCacheMetricsFactory.getInstance().increment(this.serverGroup.getName() + "-AddCall");
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            return this.getDefaultFuture();
        }
        return this.evcacheMemcachedClient.add(key, exp, value, null);
    }

    public <T> Future<Boolean> add(String key, int exp, T value, Transcoder<T> tc) throws Exception {
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            throw new EVCacheException("This operation is not supported as chunking is enabled on this EVCacheClient.");
        }
        EVCacheMetricsFactory.getInstance().increment(this.serverGroup.getName() + "-AddCall");
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            return this.getDefaultFuture();
        }
        return this.evcacheMemcachedClient.add(key, exp, value, tc);
    }

    public <T> Future<Boolean> add(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) throws Exception {
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            throw new EVCacheException("This operation is not supported as chunking is enabled on this EVCacheClient.");
        }
        EVCacheMetricsFactory.getInstance().increment(this.serverGroup.getName() + "-AddCall");
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            return this.getDefaultFuture();
        }
        return this.evcacheMemcachedClient.add(key, exp, o, tc, latch);
    }

    public <T> Future<Boolean> touch(String key, int timeToLive) throws Exception {
        return this.touch(key, timeToLive, null);
    }

    public <T> Future<Boolean> touch(String key, int timeToLive, EVCacheLatch latch) throws Exception {
        if (((Boolean)this.ignoreTouch.get()).booleanValue()) {
            SuccessFuture sf = new SuccessFuture();
            if (latch != null && latch instanceof EVCacheLatchImpl && !this.isInWriteOnly()) {
                ((EVCacheLatchImpl)latch).addFuture(sf);
            }
            return sf;
        }
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            ListenableFuture defaultFuture = (ListenableFuture)this.getDefaultFuture();
            if (latch != null && latch instanceof EVCacheLatchImpl && !this.isInWriteOnly()) {
                ((EVCacheLatchImpl)latch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)defaultFuture);
            }
            return defaultFuture;
        }
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            ChunkDetails<T> cd = this.getChunkDetails(key);
            if (cd.isChunked()) {
                List<String> keys = cd.getChunkKeys();
                OperationFuture[] futures = new OperationFuture[keys.size() + 1];
                futures[0] = this.evcacheMemcachedClient.touch(key + "_00", timeToLive, latch);
                for (int i = 0; i < keys.size(); ++i) {
                    String prefix = i < 10 ? "0" : "";
                    String _key = key + "_" + prefix + i;
                    futures[i + 1] = this.evcacheMemcachedClient.touch(_key, timeToLive, latch);
                }
                return new EVCacheFutures(futures, key, this.appName, this.serverGroup, latch);
            }
            return this.evcacheMemcachedClient.touch(key, timeToLive, latch);
        }
        return this.evcacheMemcachedClient.touch(key, timeToLive, latch);
    }

    public <T> Future<T> asyncGet(String key, Transcoder<T> tc, boolean _throwException, boolean hasZF) throws Exception {
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            throw new EVCacheException("This operation is not supported as chunking is enabled on this EVCacheClient.");
        }
        if (!this.validateNode(key, _throwException)) {
            return null;
        }
        if (tc == null) {
            tc = this.getTranscoder();
        }
        return this.evcacheMemcachedClient.asyncGet(key, tc, null);
    }

    public Future<Boolean> delete(String key) throws Exception {
        return this.delete(key, null);
    }

    public Future<Boolean> delete(String key, EVCacheLatch latch) throws Exception {
        MemcachedNode node = this.evcacheMemcachedClient.getEVCacheNode(key);
        if (!this.ensureWriteQueueSize(node, key)) {
            ListenableFuture defaultFuture = (ListenableFuture)this.getDefaultFuture();
            if (latch != null && latch instanceof EVCacheLatchImpl && !this.isInWriteOnly()) {
                ((EVCacheLatchImpl)latch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)defaultFuture);
            }
            return defaultFuture;
        }
        if (((Boolean)this.enableChunking.get()).booleanValue()) {
            ChunkDetails cd = this.getChunkDetails(key);
            if (cd == null) {
                return this.evcacheMemcachedClient.delete(key + "_00", latch);
            }
            if (!cd.isChunked()) {
                return this.evcacheMemcachedClient.delete(key, latch);
            }
            List<String> keys = cd.getChunkKeys();
            OperationFuture[] futures = new OperationFuture[keys.size() + 1];
            futures[0] = this.evcacheMemcachedClient.delete(key + "_00");
            for (int i = 0; i < keys.size(); ++i) {
                futures[i + 1] = this.evcacheMemcachedClient.delete(keys.get(i), null);
            }
            return new EVCacheFutures(futures, key, this.appName, this.serverGroup, latch);
        }
        return this.evcacheMemcachedClient.delete(key, latch);
    }

    public boolean removeConnectionObserver() {
        try {
            boolean removed = this.evcacheMemcachedClient.removeObserver(this.connectionObserver);
            if (removed) {
                this.connectionObserver = null;
            }
            return removed;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean shutdown(long timeout, TimeUnit unit) {
        this.shutdown = true;
        return this.evcacheMemcachedClient.shutdown(timeout, unit);
    }

    public EVCacheConnectionObserver getConnectionObserver() {
        return this.connectionObserver;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getZone() {
        return this.zone;
    }

    public int getId() {
        return this.id;
    }

    public ServerGroup getServerGroup() {
        return this.serverGroup;
    }

    public String getServerGroupName() {
        return this.serverGroup == null ? "NA" : this.serverGroup.getName();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isInWriteOnly() {
        return this.pool.isInWriteOnly(this.getServerGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<SocketAddress, Map<String, String>> getStats(String cmd) {
        if (this.config.isRendInstance()) {
            ArrayList<InetSocketAddress> udsproxyInetSocketAddress = new ArrayList<InetSocketAddress>(this.memcachedNodesInZone.size());
            for (InetSocketAddress inetSocketAddress : this.memcachedNodesInZone) {
                udsproxyInetSocketAddress.add(new InetSocketAddress(inetSocketAddress.getHostName(), this.config.getUdsproxyMemcachedPort()));
            }
            MemcachedClient mc = null;
            try {
                mc = new MemcachedClient(this.connectionFactory, udsproxyInetSocketAddress);
                Map map = mc.getStats(cmd);
                return map;
            }
            catch (Exception exception) {
            }
            finally {
                if (mc != null) {
                    mc.shutdown();
                }
            }
            return Collections.emptyMap();
        }
        return this.evcacheMemcachedClient.getStats(cmd);
    }

    public Map<SocketAddress, String> getVersions() {
        return this.evcacheMemcachedClient.getVersions();
    }

    public Future<Boolean> flush() {
        return this.evcacheMemcachedClient.flush();
    }

    public Transcoder<Object> getTranscoder() {
        return this.evcacheMemcachedClient.getTranscoder();
    }

    public ConnectionFactory getEVCacheConnectionFactory() {
        return this.connectionFactory;
    }

    public NodeLocator getNodeLocator() {
        return this.evcacheMemcachedClient.getNodeLocator();
    }

    private Future<Boolean> getDefaultFuture() {
        DefaultFuture defaultFuture = new DefaultFuture();
        return defaultFuture;
    }

    public String toString() {
        return "App : " + this.appName + "; Zone : " + this.zone + "; Id : " + this.id + "; " + this.serverGroup.toString() + "; Nodes : " + this.memcachedNodesInZone.toString();
    }

    public EVCacheMemcachedClient getEVCacheMemcachedClient() {
        return this.evcacheMemcachedClient;
    }

    public List<InetSocketAddress> getMemcachedNodesInZone() {
        return this.memcachedNodesInZone;
    }

    public int getMaxWriteQueueSize() {
        return this.maxWriteQueueSize;
    }

    public ChainedDynamicProperty.IntProperty getReadTimeout() {
        return this.readTimeout;
    }

    public ChainedDynamicProperty.IntProperty getBulkReadTimeout() {
        return this.bulkReadTimeout;
    }

    public DynamicIntProperty getMaxReadQueueSize() {
        return this.maxReadQueueSize;
    }

    public ChainedDynamicProperty.BooleanProperty getEnableChunking() {
        return this.enableChunking;
    }

    public ChainedDynamicProperty.IntProperty getChunkSize() {
        return this.chunkSize;
    }

    public ChunkTranscoder getChunkingTranscoder() {
        return this.chunkingTranscoder;
    }

    public SerializingTranscoder getDecodingTranscoder() {
        return this.decodingTranscoder;
    }

    public EVCacheClientPool getPool() {
        return this.pool;
    }

    public EVCacheServerGroupConfig getEVCacheConfig() {
        return this.config;
    }

    public int getWriteQueueLength() {
        Collection allNodes = this.evcacheMemcachedClient.getNodeLocator().getAll();
        int size = 0;
        for (MemcachedNode node : allNodes) {
            if (!(node instanceof EVCacheNodeImpl)) continue;
            size += ((EVCacheNodeImpl)node).getWriteQueueSize();
        }
        return size;
    }

    public int getReadQueueLength() {
        Collection allNodes = this.evcacheMemcachedClient.getNodeLocator().getAll();
        int size = 0;
        for (MemcachedNode node : allNodes) {
            if (!(node instanceof EVCacheNodeImpl)) continue;
            size += ((EVCacheNodeImpl)node).getReadQueueSize();
        }
        return size;
    }

    public List<Tag> getTagList() {
        return this.tags;
    }

    static class ChunkInfo {
        final int chunks;
        final int chunkSize;
        final int lastChunk;
        final int flags;
        final String key;
        final long checksum;

        public ChunkInfo(int chunks, int chunkSize, int lastChunk, int flags, String firstKey, long checksum) {
            this.chunks = chunks;
            this.chunkSize = chunkSize;
            this.lastChunk = lastChunk;
            this.flags = flags;
            this.key = firstKey;
            this.checksum = checksum;
        }

        public int getChunks() {
            return this.chunks;
        }

        public int getChunkSize() {
            return this.chunkSize;
        }

        public int getLastChunk() {
            return this.lastChunk;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getKey() {
            return this.key;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{\"chunks\":\"");
            builder.append(this.chunks);
            builder.append("\",\"chunkSize\":\"");
            builder.append(this.chunkSize);
            builder.append("\",\"lastChunk\":\"");
            builder.append(this.lastChunk);
            builder.append("\",\"flags\":\"");
            builder.append(this.flags);
            builder.append("\",\"key\":\"");
            builder.append(this.key);
            builder.append("\",\"checksum\":\"");
            builder.append(this.checksum);
            builder.append("\"}");
            return builder.toString();
        }
    }

    static class ChunkDetails<T> {
        final List<String> chunkKeys;
        final ChunkInfo chunkInfo;
        final boolean chunked;
        final T data;

        public ChunkDetails(List<String> chunkKeys, ChunkInfo chunkInfo, boolean chunked, T data) {
            this.chunkKeys = chunkKeys;
            this.chunkInfo = chunkInfo;
            this.chunked = chunked;
            this.data = data;
        }

        public List<String> getChunkKeys() {
            return this.chunkKeys;
        }

        public ChunkInfo getChunkInfo() {
            return this.chunkInfo;
        }

        public boolean isChunked() {
            return this.chunked;
        }

        public T getData() {
            return this.data;
        }

        public String toString() {
            return "ChunkDetails [chunkKeys=" + this.chunkKeys + ", chunkInfo=" + this.chunkInfo + ", chunked=" + this.chunked + ", data=" + this.data + "]";
        }
    }

    static class DefaultFuture
    implements ListenableFuture<Boolean, OperationCompletionListener> {
        DefaultFuture() {
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public Boolean get() throws InterruptedException, ExecutionException {
            return Boolean.FALSE;
        }

        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return Boolean.FALSE;
        }

        public Future<Boolean> addListener(OperationCompletionListener listener) {
            return this;
        }

        public Future<Boolean> removeListener(OperationCompletionListener listener) {
            return this;
        }
    }

    static class SuccessFuture
    implements ListenableFuture<Boolean, OperationCompletionListener> {
        SuccessFuture() {
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public Boolean get() throws InterruptedException, ExecutionException {
            return Boolean.TRUE;
        }

        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return Boolean.TRUE;
        }

        public Future<Boolean> addListener(OperationCompletionListener listener) {
            return this;
        }

        public Future<Boolean> removeListener(OperationCompletionListener listener) {
            return this;
        }
    }
}

