/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.observer;

import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.observer.EVCacheConnectionObserverMBean;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.ConnectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheConnectionObserver
implements ConnectionObserver,
EVCacheConnectionObserverMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheConnectionObserver.class);
    private final EVCacheClient client;
    private long lostCount = 0L;
    private long connectCount = 0L;
    private final Set<SocketAddress> evCacheActiveSet;
    private final Set<SocketAddress> evCacheInActiveSet;
    private final Map<InetSocketAddress, Long> evCacheActiveStringSet;
    private final Map<InetSocketAddress, Long> evCacheInActiveStringSet;

    public EVCacheConnectionObserver(EVCacheClient client) {
        this.client = client;
        this.evCacheActiveSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.evCacheInActiveSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.evCacheActiveStringSet = new ConcurrentHashMap<InetSocketAddress, Long>();
        this.evCacheInActiveStringSet = new ConcurrentHashMap<InetSocketAddress, Long>();
        this.setupMonitoring(false);
    }

    public void connectionEstablished(SocketAddress sa, int reconnectCount) {
        String address = sa.toString();
        this.evCacheActiveSet.add(sa);
        this.evCacheInActiveSet.remove(sa);
        InetSocketAddress inetAdd = (InetSocketAddress)sa;
        this.evCacheActiveStringSet.put(inetAdd, System.currentTimeMillis());
        this.evCacheInActiveStringSet.remove(inetAdd);
        if (log.isDebugEnabled()) {
            log.debug(this.client.getAppName() + ":CONNECTION ESTABLISHED : To " + address + " was established after " + reconnectCount + " retries");
        }
        if (log.isTraceEnabled()) {
            log.trace("Stack", (Throwable)new Exception());
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(4);
        tags.addAll(this.client.getTagList());
        tags.add((Tag)new BasicTag("evc.config", "connect"));
        tags.add((Tag)new BasicTag("evc.host", address));
        tags.add((Tag)new BasicTag("evc.reconnectCount", String.valueOf(reconnectCount)));
        EVCacheMetricsFactory.getInstance().increment("internal-evc.client.config", tags);
        ++this.connectCount;
    }

    public void connectionLost(SocketAddress sa) {
        String address = sa.toString();
        this.evCacheInActiveSet.add(sa);
        this.evCacheActiveSet.remove(sa);
        InetSocketAddress inetAdd = (InetSocketAddress)sa;
        this.evCacheInActiveStringSet.put(inetAdd, System.currentTimeMillis());
        this.evCacheActiveStringSet.remove(inetAdd);
        if (log.isDebugEnabled()) {
            log.debug(this.client.getAppName() + ":CONNECTION LOST : To " + address);
        }
        if (log.isTraceEnabled()) {
            log.trace("Stack", (Throwable)new Exception());
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(4);
        tags.addAll(this.client.getTagList());
        tags.add((Tag)new BasicTag("evc.config", "disconnect"));
        tags.add((Tag)new BasicTag("evc.host", address));
        EVCacheMetricsFactory.getInstance().increment("internal-evc.client.config", tags);
        ++this.lostCount;
    }

    @Override
    public int getActiveServerCount() {
        return this.evCacheActiveSet.size();
    }

    @Override
    public Set<SocketAddress> getActiveServerNames() {
        return this.evCacheActiveSet;
    }

    @Override
    public int getInActiveServerCount() {
        return this.evCacheInActiveSet.size();
    }

    @Override
    public Set<SocketAddress> getInActiveServerNames() {
        return this.evCacheInActiveSet;
    }

    @Override
    public long getLostCount() {
        return this.lostCount;
    }

    @Override
    public long getConnectCount() {
        return this.connectCount;
    }

    public Map<InetSocketAddress, Long> getInActiveServers() {
        return this.evCacheInActiveStringSet;
    }

    public Map<InetSocketAddress, Long> getActiveServers() {
        return this.evCacheActiveStringSet;
    }

    private void setupMonitoring(boolean shutdown) {
        block5: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this.client.getAppName() + ",SubGroup=pool,SubSubGroup=" + this.client.getServerGroupName() + ",SubSubSubGroup=" + this.client.getId());
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                if (!shutdown) {
                    mbeanServer.registerMBean(this, mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void unRegisterInActiveNodes() {
        block4: {
            try {
                for (SocketAddress sa : this.evCacheInActiveSet) {
                    ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this.client.getAppName() + ",SubGroup=pool,SubSubGroup=" + this.client.getServerGroupName() + ",SubSubSubGroup=" + this.client.getId() + ",SubSubSubSubGroup=" + ((InetSocketAddress)sa).getHostName());
                    MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                    if (!mbeanServer.isRegistered(mBeanName)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.unRegisterInActiveNodes();
        this.setupMonitoring(true);
    }

    public String toString() {
        return "EVCacheConnectionObserver [EVCacheClient=" + this.client + ", evCacheActiveSet=" + this.evCacheActiveSet + ", evCacheInActiveSet=" + this.evCacheInActiveSet + ", evCacheActiveStringSet=" + this.evCacheActiveStringSet + ", evCacheInActiveStringSet=" + this.evCacheInActiveStringSet + "]";
    }

    public String getAppName() {
        return this.client.getAppName();
    }

    public String getServerGroup() {
        return this.client.getServerGroup().toString();
    }

    public int getId() {
        return this.client.getId();
    }

    public EVCacheClient getClient() {
        return this.client;
    }
}

