/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;
import rx.functions.Action0;

@SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED"})
public class EVCacheOperationFuture<T>
extends OperationFuture<T> {
    private Logger log = LoggerFactory.getLogger(EVCacheOperationFuture.class);
    private final CountDownLatch latch;
    private final AtomicReference<T> objRef;
    private Operation op;
    private final String key;
    private final long start;
    private final EVCacheClient client;

    public EVCacheOperationFuture(String k, CountDownLatch l, AtomicReference<T> oref, long opTimeout, ExecutorService service, EVCacheClient client) {
        super(k, l, oref, opTimeout, service);
        this.latch = l;
        this.objRef = oref;
        this.key = k;
        this.client = client;
        this.start = System.currentTimeMillis();
    }

    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation to) {
        this.op = to;
        super.setOperation(to);
    }

    public String getApp() {
        return this.client.getAppName();
    }

    public String getKey() {
        return this.key;
    }

    public String getZone() {
        return this.client.getZone();
    }

    public ServerGroup getServerGroup() {
        return this.client.getServerGroup();
    }

    public EVCacheClient getEVCacheClient() {
        return this.client;
    }

    public EVCacheOperationFuture<T> addListener(EVCacheGetOperationListener<T> listener) {
        super.addToListeners(listener);
        return this;
    }

    public EVCacheOperationFuture<T> removeListener(EVCacheGetOperationListener<T> listener) {
        super.removeFromListeners(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long duration, TimeUnit units, boolean throwException, boolean hasZF) throws InterruptedException, TimeoutException, ExecutionException {
        T t;
        block23: {
            boolean status = this.latch.await(duration, units);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Took " + (System.currentTimeMillis() - this.start) + " to fetch key " + this.key + " from " + this.client);
            }
            long gcDuration = -1L;
            ArrayList<Tag> tagList = null;
            String statusString = "success";
            try {
                if (!status) {
                    boolean gcPause = false;
                    tagList = new ArrayList<Tag>(6);
                    tagList.addAll(this.client.getTagList());
                    RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
                    long vmStartTime = runtimeBean.getStartTime();
                    List<java.lang.management.GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
                    for (java.lang.management.GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                        long gcStartTime;
                        GcInfo lastGcInfo;
                        if (!(gcMXBean instanceof GarbageCollectorMXBean) || (lastGcInfo = ((GarbageCollectorMXBean)gcMXBean).getLastGcInfo()) == null || (gcStartTime = lastGcInfo.getStartTime() + vmStartTime) <= this.start) continue;
                        gcPause = true;
                        gcDuration = System.currentTimeMillis() - this.start;
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Total duration due to gc event = " + gcDuration + " msec.");
                        break;
                    }
                    if (!gcPause) {
                        if (gcPause) {
                            status = this.latch.await(duration, units);
                            tagList.add((Tag)new BasicTag("evc.pauseReason", "gc"));
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Retry status : " + status);
                            }
                            if (status) {
                                tagList.add((Tag)new BasicTag("evc.fetchAfterPause", "yes"));
                            } else {
                                tagList.add((Tag)new BasicTag("evc.fetchAfterPause", "no"));
                            }
                        } else {
                            gcDuration = System.currentTimeMillis() - this.start;
                            boolean bl = gcPause = gcDuration > units.toMillis(duration) + 10L;
                            if (gcPause) {
                                tagList.add((Tag)new BasicTag("evc.pauseReason", "unknown"));
                            }
                        }
                    }
                }
                if (!status) {
                    MemcachedConnection.opTimedOut((Operation)this.op);
                    if (this.op != null) {
                        this.op.timeOut();
                    }
                    if (!hasZF) {
                        statusString = "timeout";
                    }
                    if (throwException) {
                        throw new CheckedOperationTimeoutException("Timed out waiting for operation", this.op);
                    }
                } else {
                    MemcachedConnection.opSucceeded((Operation)this.op);
                }
                if (this.op != null && this.op.hasErrored() && throwException) {
                    throw new ExecutionException((Throwable)this.op.getException());
                }
                if (this.isCancelled()) {
                    if (hasZF) {
                        statusString = "cancelled";
                    }
                    if (throwException) {
                        throw new ExecutionException(new CancellationException("Cancelled"));
                    }
                }
                if (this.op != null && this.op.isTimedOut() && throwException) {
                    throw new ExecutionException(new CheckedOperationTimeoutException("Operation timed out.", this.op));
                }
                t = this.objRef.get();
                if (gcDuration <= 0L) break block23;
                tagList.add((Tag)new BasicTag("evc.status", statusString));
            }
            catch (Throwable throwable) {
                if (gcDuration > 0L) {
                    tagList.add((Tag)new BasicTag("evc.status", statusString));
                    EVCacheMetricsFactory.getInstance().getPercentileTimer("internal-evc.client.pause", tagList).record(gcDuration, TimeUnit.MILLISECONDS);
                }
                throw throwable;
            }
            EVCacheMetricsFactory.getInstance().getPercentileTimer("internal-evc.client.pause", tagList).record(gcDuration, TimeUnit.MILLISECONDS);
        }
        return t;
    }

    public Single<T> observe() {
        return Single.create(subscriber -> this.addListener(future -> {
            try {
                subscriber.onSuccess(this.get());
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }));
    }

    public Single<T> get(long duration, TimeUnit units, boolean throwException, boolean hasZF, Scheduler scheduler) {
        return this.observe().timeout(duration, units, Single.create(subscriber -> {
            MemcachedConnection.opTimedOut((Operation)this.op);
            if (this.op != null) {
                this.op.timeOut();
            }
            if (throwException) {
                subscriber.onError((Throwable)new CheckedOperationTimeoutException("Timed out waiting for operation", this.op));
            } else {
                if (this.isCancelled()) {
                    // empty if block
                }
                subscriber.onSuccess(this.objRef.get());
            }
        }), scheduler).doAfterTerminate(new Action0(){

            public void call() {
            }
        });
    }

    public void signalComplete() {
        super.signalComplete();
    }

    public boolean cancel(boolean ign) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return super.cancel(ign);
    }

    public boolean cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return super.cancel();
    }

    public long getStartTime() {
        return this.start;
    }
}

